/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAutoShardingEvent;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamAction
extends ActionType<Response> {
    public static final GetDataStreamAction INSTANCE = new GetDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/get";

    private GetDataStreamAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField DATA_STREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamInfo> dataStreams;
        @Nullable
        private final RolloverConfiguration rolloverConfiguration;
        @Nullable
        private final DataStreamGlobalRetention globalRetention;

        public Response(List<DataStreamInfo> dataStreams) {
            this(dataStreams, null, null);
        }

        public Response(List<DataStreamInfo> dataStreams, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) {
            this.dataStreams = dataStreams;
            this.rolloverConfiguration = rolloverConfiguration;
            this.globalRetention = globalRetention;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readCollectionAsList(DataStreamInfo::new), in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readOptionalWriteable(RolloverConfiguration::new) : null, in.getTransportVersion().onOrAfter(TransportVersions.USE_DATA_STREAM_GLOBAL_RETENTION) ? in.readOptionalWriteable(DataStreamGlobalRetention::read) : null);
        }

        public List<DataStreamInfo> getDataStreams() {
            return this.dataStreams;
        }

        @Nullable
        public RolloverConfiguration getRolloverConfiguration() {
            return this.rolloverConfiguration;
        }

        @Nullable
        public DataStreamGlobalRetention getGlobalRetention() {
            return this.globalRetention;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.dataStreams);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                out.writeOptionalWriteable(this.rolloverConfiguration);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.USE_DATA_STREAM_GLOBAL_RETENTION)) {
                out.writeOptionalWriteable(this.globalRetention);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(DATA_STREAMS_FIELD.getPreferredName());
            for (DataStreamInfo dataStream : this.dataStreams) {
                dataStream.toXContent(builder, DataStreamLifecycle.maybeAddEffectiveRetentionParams(params), this.rolloverConfiguration, this.globalRetention);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.dataStreams.equals(response.dataStreams) && Objects.equals(this.rolloverConfiguration, response.rolloverConfiguration) && Objects.equals(this.globalRetention, response.globalRetention);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams, this.rolloverConfiguration, this.globalRetention);
        }

        public static class DataStreamInfo
        implements SimpleDiffable<DataStreamInfo>,
        ToXContentObject {
            public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
            public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
            public static final ParseField PREFER_ILM = new ParseField("prefer_ilm", new String[0]);
            public static final ParseField MANAGED_BY = new ParseField("managed_by", new String[0]);
            public static final ParseField NEXT_GENERATION_INDEX_MANAGED_BY = new ParseField("next_generation_managed_by", new String[0]);
            public static final ParseField ILM_POLICY_FIELD = new ParseField("ilm_policy", new String[0]);
            public static final ParseField LIFECYCLE_FIELD = new ParseField("lifecycle", new String[0]);
            public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
            public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
            public static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
            public static final ParseField REPLICATED = new ParseField("replicated", new String[0]);
            public static final ParseField ROLLOVER_ON_WRITE = new ParseField("rollover_on_write", new String[0]);
            public static final ParseField TIME_SERIES = new ParseField("time_series", new String[0]);
            public static final ParseField TEMPORAL_RANGES = new ParseField("temporal_ranges", new String[0]);
            public static final ParseField TEMPORAL_RANGE_START = new ParseField("start", new String[0]);
            public static final ParseField TEMPORAL_RANGE_END = new ParseField("end", new String[0]);
            public static final ParseField TIME_SINCE_LAST_AUTO_SHARD_EVENT = new ParseField("time_since_last_auto_shard_event", new String[0]);
            public static final ParseField TIME_SINCE_LAST_AUTO_SHARD_EVENT_MILLIS = new ParseField("time_since_last_auto_shard_event_millis", new String[0]);
            public static final ParseField FAILURE_STORE_ENABLED = new ParseField("enabled", new String[0]);
            private final DataStream dataStream;
            private final ClusterHealthStatus dataStreamStatus;
            @Nullable
            private final String indexTemplate;
            @Nullable
            private final String ilmPolicyName;
            @Nullable
            private final TimeSeries timeSeries;
            private final Map<Index, IndexProperties> indexSettingsValues;
            private final boolean templatePreferIlmValue;

            public DataStreamInfo(DataStream dataStream, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate, @Nullable String ilmPolicyName, @Nullable TimeSeries timeSeries, Map<Index, IndexProperties> indexSettingsValues, boolean templatePreferIlmValue) {
                this.dataStream = dataStream;
                this.dataStreamStatus = dataStreamStatus;
                this.indexTemplate = indexTemplate;
                this.ilmPolicyName = ilmPolicyName;
                this.timeSeries = timeSeries;
                this.indexSettingsValues = indexSettingsValues;
                this.templatePreferIlmValue = templatePreferIlmValue;
            }

            DataStreamInfo(StreamInput in) throws IOException {
                this(DataStream.read(in), ClusterHealthStatus.readFrom(in), in.readOptionalString(), in.readOptionalString(), in.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0) ? in.readOptionalWriteable(TimeSeries::new) : null, in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? in.readMap(Index::new, IndexProperties::new) : Map.of(), in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? in.readBoolean() : true);
            }

            public DataStream getDataStream() {
                return this.dataStream;
            }

            public ClusterHealthStatus getDataStreamStatus() {
                return this.dataStreamStatus;
            }

            @Nullable
            public String getIndexTemplate() {
                return this.indexTemplate;
            }

            @Nullable
            public String getIlmPolicy() {
                return this.ilmPolicyName;
            }

            @Nullable
            public TimeSeries getTimeSeries() {
                return this.timeSeries;
            }

            public Map<Index, IndexProperties> getIndexSettingsValues() {
                return this.indexSettingsValues;
            }

            public boolean templatePreferIlmValue() {
                return this.templatePreferIlmValue;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.dataStream.writeTo(out);
                this.dataStreamStatus.writeTo(out);
                out.writeOptionalString(this.indexTemplate);
                out.writeOptionalString(this.ilmPolicyName);
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_3_0)) {
                    out.writeOptionalWriteable(this.timeSeries);
                }
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
                    out.writeMap(this.indexSettingsValues);
                    out.writeBoolean(this.templatePreferIlmValue);
                }
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return this.toXContent(builder, params, null, null);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) throws IOException {
                builder.startObject();
                builder.field(DataStream.NAME_FIELD.getPreferredName(), this.dataStream.getName());
                builder.field(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName()).startObject().field(DataStream.NAME_FIELD.getPreferredName(), "@timestamp").endObject();
                this.indicesToXContent(builder, this.dataStream.getIndices());
                builder.field(DataStream.GENERATION_FIELD.getPreferredName(), this.dataStream.getGeneration());
                if (this.dataStream.getMetadata() != null) {
                    builder.field(DataStream.METADATA_FIELD.getPreferredName(), this.dataStream.getMetadata());
                }
                builder.field(STATUS_FIELD.getPreferredName(), this.dataStreamStatus);
                if (this.indexTemplate != null) {
                    builder.field(INDEX_TEMPLATE_FIELD.getPreferredName(), this.indexTemplate);
                }
                if (this.dataStream.getLifecycle() != null) {
                    builder.field(LIFECYCLE_FIELD.getPreferredName());
                    this.dataStream.getLifecycle().toXContent(builder, params, rolloverConfiguration, this.dataStream.isSystem() ? null : globalRetention);
                }
                if (this.ilmPolicyName != null) {
                    builder.field(ILM_POLICY_FIELD.getPreferredName(), this.ilmPolicyName);
                }
                builder.field(NEXT_GENERATION_INDEX_MANAGED_BY.getPreferredName(), this.getNextGenerationManagedBy().displayValue);
                builder.field(PREFER_ILM.getPreferredName(), this.templatePreferIlmValue);
                builder.field(HIDDEN_FIELD.getPreferredName(), this.dataStream.isHidden());
                builder.field(SYSTEM_FIELD.getPreferredName(), this.dataStream.isSystem());
                builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.dataStream.isAllowCustomRouting());
                builder.field(REPLICATED.getPreferredName(), this.dataStream.isReplicated());
                builder.field(ROLLOVER_ON_WRITE.getPreferredName(), this.dataStream.rolloverOnWrite());
                this.addAutoShardingEvent(builder, params, this.dataStream.getAutoShardingEvent());
                if (this.timeSeries != null) {
                    builder.startObject(TIME_SERIES.getPreferredName());
                    builder.startArray(TEMPORAL_RANGES.getPreferredName());
                    for (Tuple<Instant, Instant> range : this.timeSeries.temporalRanges()) {
                        builder.startObject();
                        Instant start = range.v1();
                        builder.field(TEMPORAL_RANGE_START.getPreferredName(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(start));
                        Instant end = range.v2();
                        builder.field(TEMPORAL_RANGE_END.getPreferredName(), DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(end));
                        builder.endObject();
                    }
                    builder.endArray();
                    builder.endObject();
                }
                if (DataStream.isFailureStoreFeatureFlagEnabled()) {
                    builder.startObject(DataStream.FAILURE_STORE_FIELD.getPreferredName());
                    builder.field(FAILURE_STORE_ENABLED.getPreferredName(), this.dataStream.isFailureStoreEnabled());
                    builder.field(DataStream.ROLLOVER_ON_WRITE_FIELD.getPreferredName(), this.dataStream.getFailureIndices().isRolloverOnWrite());
                    this.indicesToXContent(builder, this.dataStream.getFailureIndices().getIndices());
                    this.addAutoShardingEvent(builder, params, this.dataStream.getFailureIndices().getAutoShardingEvent());
                    builder.endObject();
                }
                builder.endObject();
                return builder;
            }

            private XContentBuilder indicesToXContent(XContentBuilder builder, List<Index> indices) throws IOException {
                builder.field(DataStream.INDICES_FIELD.getPreferredName());
                builder.startArray();
                for (Index index : indices) {
                    builder.startObject();
                    index.toXContentFragment(builder);
                    IndexProperties indexProperties = this.indexSettingsValues.get(index);
                    if (indexProperties != null) {
                        builder.field(PREFER_ILM.getPreferredName(), indexProperties.preferIlm());
                        if (indexProperties.ilmPolicyName() != null) {
                            builder.field(ILM_POLICY_FIELD.getPreferredName(), indexProperties.ilmPolicyName());
                        }
                        builder.field(MANAGED_BY.getPreferredName(), indexProperties.managedBy.displayValue);
                    }
                    builder.endObject();
                }
                builder.endArray();
                return builder;
            }

            private void addAutoShardingEvent(XContentBuilder builder, ToXContent.Params params, DataStreamAutoShardingEvent autoShardingEvent) throws IOException {
                if (autoShardingEvent == null) {
                    return;
                }
                builder.startObject(DataStream.AUTO_SHARDING_FIELD.getPreferredName());
                autoShardingEvent.toXContent(builder, params);
                builder.humanReadableField(TIME_SINCE_LAST_AUTO_SHARD_EVENT_MILLIS.getPreferredName(), TIME_SINCE_LAST_AUTO_SHARD_EVENT.getPreferredName(), autoShardingEvent.getTimeSinceLastAutoShardingEvent(System::currentTimeMillis));
                builder.endObject();
            }

            public ManagedBy getNextGenerationManagedBy() {
                if (this.ilmPolicyName != null && this.dataStream.getLifecycle() != null && this.dataStream.getLifecycle().isEnabled()) {
                    return this.templatePreferIlmValue ? ManagedBy.ILM : ManagedBy.LIFECYCLE;
                }
                if (this.ilmPolicyName != null) {
                    return ManagedBy.ILM;
                }
                if (this.dataStream.getLifecycle() != null && this.dataStream.getLifecycle().isEnabled()) {
                    return ManagedBy.LIFECYCLE;
                }
                return ManagedBy.UNMANAGED;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DataStreamInfo that = (DataStreamInfo)o;
                return this.templatePreferIlmValue == that.templatePreferIlmValue && Objects.equals(this.dataStream, that.dataStream) && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate) && Objects.equals(this.ilmPolicyName, that.ilmPolicyName) && Objects.equals(this.timeSeries, that.timeSeries) && Objects.equals(this.indexSettingsValues, that.indexSettingsValues);
            }

            public int hashCode() {
                return Objects.hash(this.dataStream, this.dataStreamStatus, this.indexTemplate, this.ilmPolicyName, this.timeSeries, this.indexSettingsValues, this.templatePreferIlmValue);
            }
        }

        public record IndexProperties(boolean preferIlm, @Nullable String ilmPolicyName, ManagedBy managedBy) implements Writeable
        {
            public IndexProperties(StreamInput in) throws IOException {
                this(in.readBoolean(), in.readOptionalString(), in.readEnum(ManagedBy.class));
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeBoolean(this.preferIlm);
                out.writeOptionalString(this.ilmPolicyName);
                out.writeEnum(this.managedBy);
            }
        }

        public record TimeSeries(List<Tuple<Instant, Instant>> temporalRanges) implements Writeable
        {
            TimeSeries(StreamInput in) throws IOException {
                this(in.readCollectionAsList(in1 -> new Tuple<Instant, Instant>(in1.readInstant(), in1.readInstant())));
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeCollection(this.temporalRanges, (out1, value) -> {
                    out1.writeInstant((Instant)value.v1());
                    out1.writeInstant((Instant)value.v2());
                });
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TimeSeries that = (TimeSeries)o;
                return this.temporalRanges.equals(that.temporalRanges);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.temporalRanges);
            }
        }

        public static enum ManagedBy {
            ILM("Index Lifecycle Management"),
            LIFECYCLE("Data stream lifecycle"),
            UNMANAGED("Unmanaged");

            public final String displayValue;

            private ManagedBy(String displayValue) {
                this.displayValue = displayValue;
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, true, true, true, false, false, true, false);
        private boolean includeDefaults = false;

        public Request(String[] names) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.names = names;
        }

        public Request(String[] names, boolean includeDefaults) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.names = names;
            this.includeDefaults = includeDefaults;
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.includeDefaults = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readBoolean() : false;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                out.writeBoolean(this.includeDefaults);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names) && this.indicesOptions.equals(request.indicesOptions) && this.includeDefaults == request.includeDefaults;
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions, this.includeDefaults);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }
    }
}

