/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.SimulateBulkAction;
import org.elasticsearch.action.bulk.SimulateBulkRequest;
import org.elasticsearch.action.bulk.TransportAbstractBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.SimulateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.SimulateIngestService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSimulateBulkAction
extends TransportAbstractBulkAction {
    @Inject
    public TransportSimulateBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, ActionFilters actionFilters, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        super(SimulateBulkAction.INSTANCE, transportService, actionFilters, SimulateBulkRequest::new, threadPool, clusterService, ingestService, indexingPressure, systemIndices, System::nanoTime);
    }

    @Override
    protected void doInternalExecute(Task task, BulkRequest bulkRequest, Executor executor, ActionListener<BulkResponse> listener, long relativeStartTime) {
        AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            DocWriteRequest<?> docRequest = bulkRequest.requests.get(i);
            assert (docRequest instanceof IndexRequest) : "TransportSimulateBulkAction should only ever be called with IndexRequests";
            IndexRequest request = (IndexRequest)docRequest;
            responses.set(i, BulkItemResponse.success(0, DocWriteRequest.OpType.CREATE, new SimulateIndexResponse(request.id(), request.index(), request.version(), request.source(), request.getContentType(), request.getExecutedPipelines(), null)));
        }
        listener.onResponse(new BulkResponse(responses.toArray(new BulkItemResponse[responses.length()]), this.buildTookInMillis(relativeStartTime)));
    }

    @Override
    protected IngestService getIngestService(BulkRequest request) {
        IngestService rawIngestService = super.getIngestService(request);
        return new SimulateIngestService(rawIngestService, request);
    }

    @Override
    protected boolean shouldStoreFailure(String indexName, Metadata metadata, long time) {
        return false;
    }
}

