/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.template.reservedstate.ReservedComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutComposableIndexTemplateAction
extends AcknowledgedTransportMasterNodeAction<Request> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("indices:admin/index_template/put");
    private final MetadataIndexTemplateService indexTemplateService;

    @Inject
    public TransportPutComposableIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        TransportPutComposableIndexTemplateAction.verifyIfUsingReservedComponentTemplates(request, state);
        ComposableIndexTemplate indexTemplate = request.indexTemplate();
        this.indexTemplateService.putIndexTemplateV2(request.cause(), request.create(), request.name(), request.masterNodeTimeout(), indexTemplate, listener);
    }

    public static void verifyIfUsingReservedComponentTemplates(Request request, ClusterState state) {
        ComposableIndexTemplate indexTemplate = request.indexTemplate();
        Set<String> composedOfKeys = indexTemplate.composedOf().stream().map(c -> ReservedComposableIndexTemplateAction.reservedComponentName(c)).collect(Collectors.toSet());
        ArrayList<String> errors = new ArrayList<String>();
        for (ReservedStateMetadata metadata : state.metadata().reservedStateMetadata().values()) {
            Set<String> conflicts = metadata.conflicts("index_templates", composedOfKeys);
            if (conflicts.isEmpty()) continue;
            errors.add(Strings.format("[%s] is reserved by [%s]", String.join((CharSequence)", ", conflicts), metadata.namespace()));
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(Strings.format("Failed to process request [%s] with errors: [%s]", request, String.join((CharSequence)", ", errors)));
        }
    }

    @Override
    public Optional<String> reservedStateHandlerName() {
        return Optional.of("index_templates");
    }

    @Override
    public Set<String> modifiedKeys(Request request) {
        return Set.of(ReservedComposableIndexTemplateAction.reservedComposableIndexName(request.name()));
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements IndicesRequest {
        private final String name;
        @Nullable
        private String cause;
        private boolean create;
        private ComposableIndexTemplate indexTemplate;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.cause = in.readOptionalString();
            this.create = in.readBoolean();
            this.indexTemplate = new ComposableIndexTemplate(in);
        }

        public Request(String name) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.name = name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeOptionalString(this.cause);
            out.writeBoolean(this.create);
            this.indexTemplate.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null || !org.elasticsearch.common.Strings.hasText(this.name)) {
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
            validationException = this.validateIndexTemplate(validationException);
            return validationException;
        }

        public ActionRequestValidationException validateIndexTemplate(@Nullable ActionRequestValidationException validationException) {
            if (this.indexTemplate == null) {
                validationException = ValidateActions.addValidationError("an index template is required", validationException);
            } else {
                if (this.indexTemplate.template() != null && this.indexTemplate.indexPatterns().stream().anyMatch(Regex::isMatchAllPattern) && this.indexTemplate.template().settings() != null && IndexMetadata.INDEX_HIDDEN_SETTING.exists(this.indexTemplate.template().settings())) {
                    validationException = ValidateActions.addValidationError("global composable templates may not specify the setting " + IndexMetadata.INDEX_HIDDEN_SETTING.getKey(), validationException);
                }
                if (this.indexTemplate.priority() != null && this.indexTemplate.priority() < 0L) {
                    validationException = ValidateActions.addValidationError("index template priority must be >= 0", validationException);
                }
            }
            return validationException;
        }

        public String name() {
            return this.name;
        }

        public Request create(boolean create) {
            this.create = create;
            return this;
        }

        public boolean create() {
            return this.create;
        }

        public Request cause(@Nullable String cause) {
            this.cause = cause;
            return this;
        }

        @Nullable
        public String cause() {
            return this.cause;
        }

        public Request indexTemplate(ComposableIndexTemplate template) {
            this.indexTemplate = template;
            return this;
        }

        public ComposableIndexTemplate indexTemplate() {
            return this.indexTemplate;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("PutTemplateV2Request[");
            sb.append("name=").append(this.name);
            sb.append(", cause=").append(this.cause);
            sb.append(", create=").append(this.create);
            sb.append(", index_template=").append(this.indexTemplate);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public String[] indices() {
            return this.indexTemplate.indexPatterns().toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictExpand();
        }

        public int hashCode() {
            return Objects.hash(this.name, this.cause, this.create, this.indexTemplate);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.cause, other.cause) && Objects.equals(this.indexTemplate, other.indexTemplate) && this.create == other.create;
        }
    }
}

