/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionResolver;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetComposableIndexTemplateAction
extends TransportMasterNodeReadAction<GetComposableIndexTemplateAction.Request, GetComposableIndexTemplateAction.Response> {
    private final ClusterSettings clusterSettings;
    private final DataStreamGlobalRetentionResolver globalRetentionResolver;

    @Inject
    public TransportGetComposableIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DataStreamGlobalRetentionResolver globalRetentionResolver) {
        super("indices:admin/index_template/get", transportService, clusterService, threadPool, actionFilters, GetComposableIndexTemplateAction.Request::new, indexNameExpressionResolver, GetComposableIndexTemplateAction.Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterSettings = clusterService.getClusterSettings();
        this.globalRetentionResolver = globalRetentionResolver;
    }

    @Override
    protected ClusterBlockException checkBlock(GetComposableIndexTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(Task task, GetComposableIndexTemplateAction.Request request, ClusterState state, ActionListener<GetComposableIndexTemplateAction.Response> listener) {
        Map<String, ComposableIndexTemplate> results;
        Map<String, ComposableIndexTemplate> allTemplates = state.metadata().templatesV2();
        if (request.name() == null) {
            results = allTemplates;
        } else {
            results = new HashMap<String, ComposableIndexTemplate>();
            String name = request.name();
            if (Regex.isSimpleMatchPattern(name)) {
                for (Map.Entry<String, ComposableIndexTemplate> entry : allTemplates.entrySet()) {
                    if (!Regex.simpleMatch(name, entry.getKey())) continue;
                    results.put(entry.getKey(), entry.getValue());
                }
            } else if (allTemplates.containsKey(name)) {
                results.put(name, allTemplates.get(name));
            } else {
                throw new ResourceNotFoundException("index template matching [" + request.name() + "] not found", new Object[0]);
            }
        }
        if (request.includeDefaults()) {
            listener.onResponse(new GetComposableIndexTemplateAction.Response(results, this.clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING), this.globalRetentionResolver.resolve(state)));
        } else {
            listener.onResponse(new GetComposableIndexTemplateAction.Response(results, this.globalRetentionResolver.resolve(state)));
        }
    }
}

