/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.bulk.stats.BulkStats;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.cache.request.RequestCacheStats;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.NodeMappingStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.DenseVectorStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.ShardCountStats;
import org.elasticsearch.index.shard.SparseVectorStats;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class CommonStats
implements Writeable,
ToXContentFragment {
    private static final TransportVersion VERSION_SUPPORTING_NODE_MAPPINGS = TransportVersions.V_8_5_0;
    private static final TransportVersion VERSION_SUPPORTING_DENSE_VECTOR_STATS = TransportVersions.V_8_10_X;
    @Nullable
    public DocsStats docs;
    @Nullable
    public StoreStats store;
    @Nullable
    public IndexingStats indexing;
    @Nullable
    public GetStats get;
    @Nullable
    public SearchStats search;
    @Nullable
    public MergeStats merge;
    @Nullable
    public RefreshStats refresh;
    @Nullable
    public FlushStats flush;
    @Nullable
    public WarmerStats warmer;
    @Nullable
    public QueryCacheStats queryCache;
    @Nullable
    public FieldDataStats fieldData;
    @Nullable
    public CompletionStats completion;
    @Nullable
    public SegmentsStats segments;
    @Nullable
    public TranslogStats translog;
    @Nullable
    public RequestCacheStats requestCache;
    @Nullable
    public RecoveryStats recoveryStats;
    @Nullable
    public BulkStats bulk;
    @Nullable
    public ShardCountStats shards;
    @Nullable
    public NodeMappingStats nodeMappings;
    @Nullable
    public DenseVectorStats denseVectorStats;
    @Nullable
    public SparseVectorStats sparseVectorStats;

    public CommonStats() {
        this(CommonStatsFlags.NONE);
    }

    public CommonStats(CommonStatsFlags flags) {
        CommonStatsFlags.Flag[] setFlags;
        block23: for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
            switch (flag) {
                case Docs: {
                    this.docs = new DocsStats();
                    continue block23;
                }
                case Store: {
                    this.store = new StoreStats();
                    continue block23;
                }
                case Indexing: {
                    this.indexing = new IndexingStats();
                    continue block23;
                }
                case Get: {
                    this.get = new GetStats();
                    continue block23;
                }
                case Search: {
                    this.search = new SearchStats();
                    continue block23;
                }
                case Merge: {
                    this.merge = new MergeStats();
                    continue block23;
                }
                case Refresh: {
                    this.refresh = new RefreshStats();
                    continue block23;
                }
                case Flush: {
                    this.flush = new FlushStats();
                    continue block23;
                }
                case Warmer: {
                    this.warmer = new WarmerStats();
                    continue block23;
                }
                case QueryCache: {
                    this.queryCache = new QueryCacheStats();
                    continue block23;
                }
                case FieldData: {
                    this.fieldData = new FieldDataStats();
                    continue block23;
                }
                case Completion: {
                    this.completion = new CompletionStats();
                    continue block23;
                }
                case Segments: {
                    this.segments = new SegmentsStats();
                    continue block23;
                }
                case Translog: {
                    this.translog = new TranslogStats();
                    continue block23;
                }
                case RequestCache: {
                    this.requestCache = new RequestCacheStats();
                    continue block23;
                }
                case Recovery: {
                    this.recoveryStats = new RecoveryStats();
                    continue block23;
                }
                case Bulk: {
                    this.bulk = new BulkStats();
                    continue block23;
                }
                case Shards: {
                    this.shards = new ShardCountStats();
                    continue block23;
                }
                case Mappings: {
                    this.nodeMappings = new NodeMappingStats();
                    continue block23;
                }
                case DenseVector: {
                    this.denseVectorStats = new DenseVectorStats();
                    continue block23;
                }
                case SparseVector: {
                    this.sparseVectorStats = new SparseVectorStats();
                    continue block23;
                }
                default: {
                    throw new IllegalStateException("Unknown Flag: " + flag);
                }
            }
        }
    }

    public static CommonStats getShardLevelStats(IndicesQueryCache indicesQueryCache, IndexShard indexShard, CommonStatsFlags flags) {
        CommonStatsFlags filteredFlags = flags.clone();
        for (CommonStatsFlags.Flag flag : filteredFlags.getFlags()) {
            filteredFlags.set(flag, CommonStatsFlags.SHARD_LEVEL.isSet(flag));
        }
        CommonStats stats = new CommonStats(filteredFlags);
        for (CommonStatsFlags.Flag flag : filteredFlags.getFlags()) {
            try {
                switch (flag) {
                    case Docs: {
                        stats.docs = indexShard.docStats();
                        break;
                    }
                    case Store: {
                        stats.store = indexShard.storeStats();
                        break;
                    }
                    case Indexing: {
                        stats.indexing = indexShard.indexingStats();
                        break;
                    }
                    case Get: {
                        stats.get = indexShard.getStats();
                        break;
                    }
                    case Search: {
                        stats.search = indexShard.searchStats(flags.groups());
                        break;
                    }
                    case Merge: {
                        stats.merge = indexShard.mergeStats();
                        break;
                    }
                    case Refresh: {
                        stats.refresh = indexShard.refreshStats();
                        break;
                    }
                    case Flush: {
                        stats.flush = indexShard.flushStats();
                        break;
                    }
                    case Warmer: {
                        stats.warmer = indexShard.warmerStats();
                        break;
                    }
                    case QueryCache: {
                        stats.queryCache = indicesQueryCache.getStats(indexShard.shardId());
                        break;
                    }
                    case FieldData: {
                        stats.fieldData = indexShard.fieldDataStats(flags.fieldDataFields());
                        break;
                    }
                    case Completion: {
                        stats.completion = indexShard.completionStats(flags.completionDataFields());
                        break;
                    }
                    case Segments: {
                        stats.segments = indexShard.segmentStats(flags.includeSegmentFileSizes(), flags.includeUnloadedSegments());
                        break;
                    }
                    case Translog: {
                        stats.translog = indexShard.translogStats();
                        break;
                    }
                    case RequestCache: {
                        stats.requestCache = indexShard.requestCache().stats();
                        break;
                    }
                    case Recovery: {
                        stats.recoveryStats = indexShard.recoveryStats();
                        break;
                    }
                    case Bulk: {
                        stats.bulk = indexShard.bulkStats();
                        break;
                    }
                    case Shards: {
                        stats.shards = new ShardCountStats(1L);
                        break;
                    }
                    case DenseVector: {
                        stats.denseVectorStats = indexShard.denseVectorStats();
                        break;
                    }
                    case SparseVector: {
                        stats.sparseVectorStats = indexShard.sparseVectorStats();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown or invalid flag for shard-level stats: " + flag);
                    }
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        return stats;
    }

    public CommonStats(StreamInput in) throws IOException {
        this.docs = in.readOptionalWriteable(DocsStats::new);
        this.store = in.readOptionalWriteable(StoreStats::new);
        this.indexing = in.readOptionalWriteable(IndexingStats::new);
        this.get = in.readOptionalWriteable(GetStats::new);
        this.search = in.readOptionalWriteable(SearchStats::new);
        this.merge = in.readOptionalWriteable(MergeStats::new);
        this.refresh = in.readOptionalWriteable(RefreshStats::new);
        this.flush = in.readOptionalWriteable(FlushStats::new);
        this.warmer = in.readOptionalWriteable(WarmerStats::new);
        this.queryCache = in.readOptionalWriteable(QueryCacheStats::new);
        this.fieldData = in.readOptionalWriteable(FieldDataStats::new);
        this.completion = in.readOptionalWriteable(CompletionStats::new);
        this.segments = in.readOptionalWriteable(SegmentsStats::new);
        this.translog = in.readOptionalWriteable(TranslogStats::new);
        this.requestCache = in.readOptionalWriteable(RequestCacheStats::new);
        this.recoveryStats = in.readOptionalWriteable(RecoveryStats::new);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            this.bulk = in.readOptionalWriteable(BulkStats::new);
        }
        this.shards = in.readOptionalWriteable(ShardCountStats::new);
        if (in.getTransportVersion().onOrAfter(VERSION_SUPPORTING_NODE_MAPPINGS)) {
            this.nodeMappings = in.readOptionalWriteable(NodeMappingStats::new);
        }
        if (in.getTransportVersion().onOrAfter(VERSION_SUPPORTING_DENSE_VECTOR_STATS)) {
            this.denseVectorStats = in.readOptionalWriteable(DenseVectorStats::new);
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.VERSION_SUPPORTING_SPARSE_VECTOR_STATS)) {
            this.sparseVectorStats = in.readOptionalWriteable(SparseVectorStats::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.docs);
        out.writeOptionalWriteable(this.store);
        out.writeOptionalWriteable(this.indexing);
        out.writeOptionalWriteable(this.get);
        out.writeOptionalWriteable(this.search);
        out.writeOptionalWriteable(this.merge);
        out.writeOptionalWriteable(this.refresh);
        out.writeOptionalWriteable(this.flush);
        out.writeOptionalWriteable(this.warmer);
        out.writeOptionalWriteable(this.queryCache);
        out.writeOptionalWriteable(this.fieldData);
        out.writeOptionalWriteable(this.completion);
        out.writeOptionalWriteable(this.segments);
        out.writeOptionalWriteable(this.translog);
        out.writeOptionalWriteable(this.requestCache);
        out.writeOptionalWriteable(this.recoveryStats);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            out.writeOptionalWriteable(this.bulk);
        }
        out.writeOptionalWriteable(this.shards);
        if (out.getTransportVersion().onOrAfter(VERSION_SUPPORTING_NODE_MAPPINGS)) {
            out.writeOptionalWriteable(this.nodeMappings);
        }
        if (out.getTransportVersion().onOrAfter(VERSION_SUPPORTING_DENSE_VECTOR_STATS)) {
            out.writeOptionalWriteable(this.denseVectorStats);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.VERSION_SUPPORTING_SPARSE_VECTOR_STATS)) {
            out.writeOptionalWriteable(this.sparseVectorStats);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonStats that = (CommonStats)o;
        return Objects.equals(this.docs, that.docs) && Objects.equals(this.store, that.store) && Objects.equals(this.indexing, that.indexing) && Objects.equals(this.get, that.get) && Objects.equals(this.search, that.search) && Objects.equals(this.merge, that.merge) && Objects.equals(this.refresh, that.refresh) && Objects.equals(this.flush, that.flush) && Objects.equals(this.warmer, that.warmer) && Objects.equals(this.queryCache, that.queryCache) && Objects.equals(this.fieldData, that.fieldData) && Objects.equals(this.completion, that.completion) && Objects.equals(this.segments, that.segments) && Objects.equals(this.translog, that.translog) && Objects.equals(this.requestCache, that.requestCache) && Objects.equals(this.recoveryStats, that.recoveryStats) && Objects.equals(this.bulk, that.bulk) && Objects.equals(this.shards, that.shards) && Objects.equals(this.nodeMappings, that.nodeMappings) && Objects.equals(this.denseVectorStats, that.denseVectorStats) && Objects.equals(this.sparseVectorStats, that.sparseVectorStats);
    }

    public int hashCode() {
        return Objects.hash(this.docs, this.store, this.indexing, this.get, this.search, this.merge, this.refresh, this.flush, this.warmer, this.queryCache, this.fieldData, this.completion, this.segments, this.translog, this.requestCache, this.recoveryStats, this.bulk, this.shards, this.nodeMappings, this.denseVectorStats, this.sparseVectorStats);
    }

    public void add(CommonStats stats) {
        if (this.docs == null) {
            if (stats.getDocs() != null) {
                this.docs = new DocsStats();
                this.docs.add(stats.getDocs());
            }
        } else {
            this.docs.add(stats.getDocs());
        }
        if (this.store == null) {
            if (stats.getStore() != null) {
                this.store = new StoreStats();
                this.store.add(stats.getStore());
            }
        } else {
            this.store.add(stats.getStore());
        }
        if (this.indexing == null) {
            if (stats.getIndexing() != null) {
                this.indexing = new IndexingStats();
                this.indexing.add(stats.getIndexing());
            }
        } else {
            this.indexing.add(stats.getIndexing());
        }
        if (this.get == null) {
            if (stats.getGet() != null) {
                this.get = new GetStats();
                this.get.add(stats.getGet());
            }
        } else {
            this.get.add(stats.getGet());
        }
        if (this.search == null) {
            if (stats.getSearch() != null) {
                this.search = new SearchStats();
                this.search.add(stats.getSearch());
            }
        } else {
            this.search.add(stats.getSearch());
        }
        if (this.merge == null) {
            if (stats.getMerge() != null) {
                this.merge = new MergeStats();
                this.merge.add(stats.getMerge());
            }
        } else {
            this.merge.add(stats.getMerge());
        }
        if (this.refresh == null) {
            if (stats.getRefresh() != null) {
                this.refresh = new RefreshStats();
                this.refresh.add(stats.getRefresh());
            }
        } else {
            this.refresh.add(stats.getRefresh());
        }
        if (this.flush == null) {
            if (stats.getFlush() != null) {
                this.flush = new FlushStats();
                this.flush.add(stats.getFlush());
            }
        } else {
            this.flush.add(stats.getFlush());
        }
        if (this.warmer == null) {
            if (stats.getWarmer() != null) {
                this.warmer = new WarmerStats();
                this.warmer.add(stats.getWarmer());
            }
        } else {
            this.warmer.add(stats.getWarmer());
        }
        if (this.queryCache == null) {
            if (stats.getQueryCache() != null) {
                this.queryCache = new QueryCacheStats();
                this.queryCache.add(stats.getQueryCache());
            }
        } else {
            this.queryCache.add(stats.getQueryCache());
        }
        if (this.fieldData == null) {
            if (stats.getFieldData() != null) {
                this.fieldData = new FieldDataStats();
                this.fieldData.add(stats.getFieldData());
            }
        } else {
            this.fieldData.add(stats.getFieldData());
        }
        if (this.completion == null) {
            if (stats.getCompletion() != null) {
                this.completion = new CompletionStats();
                this.completion.add(stats.getCompletion());
            }
        } else {
            this.completion.add(stats.getCompletion());
        }
        if (this.segments == null) {
            if (stats.getSegments() != null) {
                this.segments = new SegmentsStats();
                this.segments.add(stats.getSegments());
            }
        } else {
            this.segments.add(stats.getSegments());
        }
        if (this.translog == null) {
            if (stats.getTranslog() != null) {
                this.translog = new TranslogStats();
                this.translog.add(stats.getTranslog());
            }
        } else {
            this.translog.add(stats.getTranslog());
        }
        if (this.requestCache == null) {
            if (stats.getRequestCache() != null) {
                this.requestCache = new RequestCacheStats();
                this.requestCache.add(stats.getRequestCache());
            }
        } else {
            this.requestCache.add(stats.getRequestCache());
        }
        if (this.recoveryStats == null) {
            if (stats.getRecoveryStats() != null) {
                this.recoveryStats = new RecoveryStats();
                this.recoveryStats.add(stats.getRecoveryStats());
            }
        } else {
            this.recoveryStats.add(stats.getRecoveryStats());
        }
        if (this.bulk == null) {
            if (stats.getBulk() != null) {
                this.bulk = new BulkStats();
                this.bulk.add(stats.getBulk());
            }
        } else {
            this.bulk.add(stats.getBulk());
        }
        if (stats.shards != null) {
            this.shards = this.shards == null ? stats.shards : this.shards.add(stats.shards);
        }
        if (stats.getNodeMappings() != null) {
            if (this.nodeMappings == null) {
                this.nodeMappings = new NodeMappingStats();
                this.nodeMappings.add(stats.getNodeMappings());
            } else {
                this.nodeMappings.add(stats.getNodeMappings());
            }
        }
        if (this.denseVectorStats == null) {
            if (stats.getDenseVectorStats() != null) {
                this.denseVectorStats = new DenseVectorStats();
                this.denseVectorStats.add(stats.getDenseVectorStats());
            }
        } else {
            this.denseVectorStats.add(stats.getDenseVectorStats());
        }
        if (this.sparseVectorStats == null) {
            if (stats.getSparseVectorStats() != null) {
                this.sparseVectorStats = new SparseVectorStats();
                this.sparseVectorStats.add(stats.getSparseVectorStats());
            }
        } else {
            this.sparseVectorStats.add(stats.getSparseVectorStats());
        }
    }

    @Nullable
    public DocsStats getDocs() {
        return this.docs;
    }

    @Nullable
    public StoreStats getStore() {
        return this.store;
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.indexing;
    }

    @Nullable
    public GetStats getGet() {
        return this.get;
    }

    @Nullable
    public SearchStats getSearch() {
        return this.search;
    }

    @Nullable
    public MergeStats getMerge() {
        return this.merge;
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.refresh;
    }

    @Nullable
    public FlushStats getFlush() {
        return this.flush;
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.warmer;
    }

    @Nullable
    public QueryCacheStats getQueryCache() {
        return this.queryCache;
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.fieldData;
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.completion;
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.segments;
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.translog;
    }

    @Nullable
    public RequestCacheStats getRequestCache() {
        return this.requestCache;
    }

    @Nullable
    public RecoveryStats getRecoveryStats() {
        return this.recoveryStats;
    }

    @Nullable
    public BulkStats getBulk() {
        return this.bulk;
    }

    @Nullable
    public ShardCountStats getShards() {
        return this.shards;
    }

    @Nullable
    public NodeMappingStats getNodeMappings() {
        return this.nodeMappings;
    }

    @Nullable
    public DenseVectorStats getDenseVectorStats() {
        return this.denseVectorStats;
    }

    @Nullable
    public SparseVectorStats getSparseVectorStats() {
        return this.sparseVectorStats;
    }

    public ByteSizeValue getTotalMemory() {
        long size = 0L;
        if (this.getFieldData() != null) {
            size += this.getFieldData().getMemorySizeInBytes();
        }
        if (this.getQueryCache() != null) {
            size += this.getQueryCache().getMemorySizeInBytes();
        }
        if (this.getSegments() != null) {
            size += this.getSegments().getIndexWriterMemoryInBytes() + this.getSegments().getVersionMapMemoryInBytes();
        }
        return ByteSizeValue.ofBytes(size);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        CommonStats.addIfNonNull(builder, params, this.docs);
        CommonStats.addIfNonNull(builder, params, this.shards);
        CommonStats.addIfNonNull(builder, params, this.store);
        CommonStats.addIfNonNull(builder, params, this.indexing);
        CommonStats.addIfNonNull(builder, params, this.get);
        CommonStats.addIfNonNull(builder, params, this.search);
        CommonStats.addIfNonNull(builder, params, this.merge);
        CommonStats.addIfNonNull(builder, params, this.refresh);
        CommonStats.addIfNonNull(builder, params, this.flush);
        CommonStats.addIfNonNull(builder, params, this.warmer);
        CommonStats.addIfNonNull(builder, params, this.queryCache);
        CommonStats.addIfNonNull(builder, params, this.fieldData);
        CommonStats.addIfNonNull(builder, params, this.completion);
        CommonStats.addIfNonNull(builder, params, this.segments);
        CommonStats.addIfNonNull(builder, params, this.translog);
        CommonStats.addIfNonNull(builder, params, this.requestCache);
        CommonStats.addIfNonNull(builder, params, this.recoveryStats);
        CommonStats.addIfNonNull(builder, params, this.bulk);
        CommonStats.addIfNonNull(builder, params, this.nodeMappings);
        CommonStats.addIfNonNull(builder, params, this.denseVectorStats);
        CommonStats.addIfNonNull(builder, params, this.sparseVectorStats);
        return builder;
    }

    private static void addIfNonNull(XContentBuilder builder, ToXContent.Params params, @Nullable ToXContent toXContent) throws IOException {
        if (toXContent != null) {
            toXContent.toXContent(builder, params);
        }
    }
}

