/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionMultiListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class AutoCreateAction
extends ActionType<CreateIndexResponse> {
    private static final Logger logger = LogManager.getLogger(AutoCreateAction.class);
    public static final AutoCreateAction INSTANCE = new AutoCreateAction();
    public static final String NAME = "indices:admin/auto_create";

    private AutoCreateAction() {
        super(NAME);
    }

    static ComposableIndexTemplate resolveTemplate(CreateIndexRequest request, Metadata metadata) {
        String v2Template = MetadataIndexTemplateService.findV2Template(metadata, request.index(), false);
        return v2Template != null ? metadata.templatesV2().get(v2Template) : null;
    }

    public static final class TransportAction
    extends TransportMasterNodeAction<CreateIndexRequest, CreateIndexResponse> {
        private final MetadataCreateIndexService createIndexService;
        private final MetadataCreateDataStreamService metadataCreateDataStreamService;
        private final AutoCreateIndex autoCreateIndex;
        private final SystemIndices systemIndices;
        private final MasterServiceTaskQueue<CreateIndexTask> taskQueue;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService createIndexService, MetadataCreateDataStreamService metadataCreateDataStreamService, AutoCreateIndex autoCreateIndex, SystemIndices systemIndices, AllocationService allocationService) {
            super(AutoCreateAction.NAME, transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver, CreateIndexResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.systemIndices = systemIndices;
            this.createIndexService = createIndexService;
            this.metadataCreateDataStreamService = metadataCreateDataStreamService;
            this.autoCreateIndex = autoCreateIndex;
            this.taskQueue = clusterService.createTaskQueue("auto-create", Priority.URGENT, batchExecutionContext -> {
                AllocationActionMultiListener<CreateIndexResponse> listener = new AllocationActionMultiListener<CreateIndexResponse>(threadPool.getThreadContext());
                List taskContexts = batchExecutionContext.taskContexts();
                Map<CreateIndexRequest, List<String>> successfulRequests = Maps.newMapWithExpectedSize(taskContexts.size());
                ClusterState state = batchExecutionContext.initialState();
                for (ClusterStateTaskExecutor.TaskContext<CreateIndexTask> taskContext : taskContexts) {
                    CreateIndexTask task = (CreateIndexTask)taskContext.getTask();
                    try {
                        Releasable ignored = taskContext.captureResponseHeaders();
                        try {
                            state = task.execute(state, successfulRequests, taskContext, listener);
                            assert (successfulRequests.containsKey(task.request));
                        }
                        finally {
                            if (ignored == null) continue;
                            ignored.close();
                        }
                    }
                    catch (Exception e) {
                        taskContext.onFailure(e);
                    }
                }
                if (state != batchExecutionContext.initialState()) {
                    try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                        state = allocationService.reroute(state, "auto-create", listener.reroute());
                    }
                } else {
                    listener.noRerouteNeeded();
                }
                return state;
            });
        }

        @Override
        protected void masterOperation(Task task, CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> listener) {
            this.taskQueue.submitTask("auto create [" + request.index() + "]", new CreateIndexTask(request, listener), request.masterNodeTimeout());
        }

        @Override
        protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
            return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
        }

        private final class CreateIndexTask
        implements ClusterStateTaskListener {
            private final CreateIndexRequest request;
            private final ActionListener<CreateIndexResponse> listener;

            private CreateIndexTask(CreateIndexRequest request, ActionListener<CreateIndexResponse> listener) {
                this.request = request;
                this.listener = listener;
            }

            @Override
            public void onFailure(Exception e) {
                this.listener.onFailure(e);
            }

            private ClusterStateAckListener getAckListener(String indexName, AllocationActionMultiListener<CreateIndexResponse> allocationActionMultiListener) {
                return this.getAckListener(List.of(indexName), allocationActionMultiListener);
            }

            private ClusterStateAckListener getAckListener(final List<String> indexNames, final AllocationActionMultiListener<CreateIndexResponse> allocationActionMultiListener) {
                return new ClusterStateAckListener(){

                    @Override
                    public boolean mustAck(DiscoveryNode discoveryNode) {
                        return true;
                    }

                    @Override
                    public void onAllNodesAcked() {
                        ActiveShardsObserver.waitForActiveShards(TransportAction.this.clusterService, (String[])indexNames.toArray(String[]::new), ActiveShardCount.DEFAULT, CreateIndexTask.this.request.ackTimeout(), allocationActionMultiListener.delay(CreateIndexTask.this.listener).map(shardsAcked -> new CreateIndexResponse(true, (boolean)shardsAcked, (String)indexNames.get(0))));
                    }

                    @Override
                    public void onAckFailure(Exception e) {
                        allocationActionMultiListener.delay(CreateIndexTask.this.listener).onResponse(new CreateIndexResponse(false, false, (String)indexNames.get(0)));
                    }

                    @Override
                    public void onAckTimeout() {
                        allocationActionMultiListener.delay(CreateIndexTask.this.listener).onResponse(new CreateIndexResponse(false, false, (String)indexNames.get(0)));
                    }

                    @Override
                    public TimeValue ackTimeout() {
                        return CreateIndexTask.this.request.ackTimeout();
                    }
                };
            }

            ClusterState execute(ClusterState currentState, Map<CreateIndexRequest, List<String>> successfulRequests, ClusterStateTaskExecutor.TaskContext<CreateIndexTask> taskContext, AllocationActionMultiListener<CreateIndexResponse> allocationActionMultiListener) throws Exception {
                CreateIndexClusterStateUpdateRequest updateRequest;
                boolean isManagedSystemIndex;
                boolean isDataStream;
                List<String> previousIndexName = successfulRequests.get(this.request);
                if (previousIndexName != null) {
                    taskContext.success(this.getAckListener(previousIndexName, allocationActionMultiListener));
                    return currentState;
                }
                SystemDataStreamDescriptor dataStreamDescriptor = TransportAction.this.systemIndices.validateDataStreamAccess(this.request.index(), TransportAction.this.threadPool.getThreadContext());
                boolean isSystemDataStream = dataStreamDescriptor != null;
                boolean isSystemIndex = !isSystemDataStream && TransportAction.this.systemIndices.isSystemIndex(this.request.index());
                ComposableIndexTemplate template = AutoCreateAction.resolveTemplate(this.request, currentState.metadata());
                boolean bl = isDataStream = !isSystemIndex && (isSystemDataStream || template != null && template.getDataStreamTemplate() != null);
                if (isDataStream) {
                    if (!isSystemDataStream && Boolean.FALSE.equals(template.getAllowAutoCreate())) {
                        throw new IndexNotFoundException("composable template " + template.indexPatterns() + " forbids index auto creation", this.request.index());
                    }
                    MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest createRequest = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(this.request.index(), dataStreamDescriptor, this.request.masterNodeTimeout(), this.request.ackTimeout(), false);
                    assert (!createRequest.performReroute()) : "rerouteCompletionIsNotRequired() assumes reroute is not called by underlying service";
                    ClusterState clusterState = TransportAction.this.metadataCreateDataStreamService.createDataStream(createRequest, currentState, AllocationActionListener.rerouteCompletionIsNotRequired(), this.request.isInitializeFailureStore());
                    DataStream dataStream = clusterState.metadata().dataStreams().get(this.request.index());
                    String backingIndexName = dataStream.getIndices().get(0).getName();
                    List<String> indexNames = dataStream.getFailureIndices().getIndices().isEmpty() ? List.of(backingIndexName) : List.of(backingIndexName, dataStream.getFailureIndices().getIndices().get(0).getName());
                    taskContext.success(this.getAckListener(indexNames, allocationActionMultiListener));
                    successfulRequests.put(this.request, indexNames);
                    return clusterState;
                }
                if (this.request.isRequireDataStream()) {
                    throw new IndexNotFoundException("the index creation request requires a data stream, but no matching index template with data stream template was found for it", this.request.index());
                }
                String indexName = IndexNameExpressionResolver.resolveDateMathExpression(this.request.index());
                if (isSystemIndex) {
                    if (!indexName.equals(this.request.index())) {
                        throw new IllegalStateException("system indices do not support date math expressions");
                    }
                } else {
                    boolean shouldAutoCreate = TransportAction.this.autoCreateIndex.shouldAutoCreate(indexName, currentState);
                    if (!shouldAutoCreate) {
                        taskContext.success(this.getAckListener(indexName, allocationActionMultiListener));
                        successfulRequests.put(this.request, List.of(indexName));
                        return currentState;
                    }
                }
                SystemIndexDescriptor mainDescriptor = isSystemIndex ? TransportAction.this.systemIndices.findMatchingDescriptor(indexName) : null;
                boolean bl2 = isManagedSystemIndex = mainDescriptor != null && mainDescriptor.isAutomaticallyManaged();
                if (isManagedSystemIndex) {
                    SystemIndexDescriptor descriptor = mainDescriptor.getDescriptorCompatibleWith(currentState.getMinSystemIndexMappingVersions().get(mainDescriptor.getPrimaryIndex()));
                    if (descriptor == null) {
                        String message = mainDescriptor.getMinimumMappingsVersionMessage("auto-create index");
                        logger.warn(message);
                        throw new IllegalStateException(message);
                    }
                    updateRequest = this.buildSystemIndexUpdateRequest(indexName, descriptor);
                } else if (isSystemIndex) {
                    updateRequest = this.buildUpdateRequest(indexName);
                    if (Objects.isNull(this.request.settings())) {
                        updateRequest.settings(SystemIndexDescriptor.DEFAULT_SETTINGS);
                    } else if (!this.request.settings().hasValue("index.hidden")) {
                        updateRequest.settings(Settings.builder().put(this.request.settings()).put("index.hidden", true).build());
                    } else if ("false".equals(this.request.settings().get("index.hidden"))) {
                        String message = "Cannot auto-create system index [" + indexName + "] with [index.hidden] set to 'false'";
                        logger.warn(message);
                        throw new IllegalStateException(message);
                    }
                } else {
                    updateRequest = this.buildUpdateRequest(indexName);
                }
                assert (!updateRequest.performReroute()) : "rerouteCompletionIsNotRequired() assumes reroute is not called by underlying service";
                ClusterState clusterState = TransportAction.this.createIndexService.applyCreateIndexRequest(currentState, updateRequest, false, AllocationActionListener.rerouteCompletionIsNotRequired());
                taskContext.success(this.getAckListener(indexName, allocationActionMultiListener));
                successfulRequests.put(this.request, List.of(indexName));
                return clusterState;
            }

            private CreateIndexClusterStateUpdateRequest buildUpdateRequest(String indexName) {
                CreateIndexClusterStateUpdateRequest updateRequest = (CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(this.request.cause(), indexName, this.request.index()).ackTimeout(this.request.ackTimeout())).performReroute(false).masterNodeTimeout(this.request.masterNodeTimeout());
                logger.debug("Auto-creating index {}", (Object)indexName);
                return updateRequest;
            }

            private CreateIndexClusterStateUpdateRequest buildSystemIndexUpdateRequest(String indexName, SystemIndexDescriptor descriptor) {
                String mappings = descriptor.getMappings();
                Settings settings = descriptor.getSettings();
                String aliasName = descriptor.getAliasName();
                String concreteIndexName = indexName.equals(aliasName) ? descriptor.getPrimaryIndex() : indexName;
                CreateIndexClusterStateUpdateRequest updateRequest = ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(this.request.cause(), concreteIndexName, this.request.index()).ackTimeout(this.request.ackTimeout())).masterNodeTimeout(this.request.masterNodeTimeout())).performReroute(false);
                updateRequest.waitForActiveShards(ActiveShardCount.ALL);
                if (mappings != null) {
                    updateRequest.mappings(mappings);
                }
                if (settings != null) {
                    updateRequest.settings(settings);
                }
                if (aliasName != null) {
                    Alias systemAlias = new Alias(aliasName).isHidden(true);
                    if (concreteIndexName.equals(descriptor.getPrimaryIndex())) {
                        systemAlias.writeIndex(true);
                    }
                    updateRequest.aliases(Set.of(systemAlias));
                }
                if (logger.isDebugEnabled()) {
                    if (!concreteIndexName.equals(indexName)) {
                        logger.debug("Auto-creating backing system index {} for alias {}", (Object)concreteIndexName, (Object)indexName);
                    } else {
                        logger.debug("Auto-creating system index {}", (Object)concreteIndexName);
                    }
                }
                return updateRequest;
            }
        }
    }
}

