/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.MappingStats;
import org.elasticsearch.action.admin.cluster.stats.SearchUsageStats;
import org.elasticsearch.action.admin.cluster.stats.VersionStats;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterSnapshotStats;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CancellableSingleObjectCache;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.seqno.RetentionLeaseStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.usage.UsageService;

public class TransportClusterStatsAction
extends TransportNodesAction<ClusterStatsRequest, ClusterStatsResponse, ClusterStatsNodeRequest, ClusterStatsNodeResponse> {
    public static final ActionType<ClusterStatsResponse> TYPE = new ActionType("cluster:monitor/stats");
    private static final CommonStatsFlags SHARD_STATS_FLAGS = new CommonStatsFlags(CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Completion, CommonStatsFlags.Flag.Segments, CommonStatsFlags.Flag.DenseVector, CommonStatsFlags.Flag.SparseVector);
    private final NodeService nodeService;
    private final IndicesService indicesService;
    private final SearchUsageHolder searchUsageHolder;
    private final MetadataStatsCache<MappingStats> mappingStatsCache;
    private final MetadataStatsCache<AnalysisStats> analysisStatsCache;

    @Inject
    public TransportClusterStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, IndicesService indicesService, UsageService usageService, ActionFilters actionFilters) {
        super(TYPE.name(), clusterService, transportService, actionFilters, ClusterStatsNodeRequest::new, threadPool.executor("management"));
        this.nodeService = nodeService;
        this.indicesService = indicesService;
        this.searchUsageHolder = usageService.getSearchUsageHolder();
        this.mappingStatsCache = new MetadataStatsCache<MappingStats>(threadPool.getThreadContext(), MappingStats::of);
        this.analysisStatsCache = new MetadataStatsCache<AnalysisStats>(threadPool.getThreadContext(), AnalysisStats::of);
    }

    @Override
    protected void newResponseAsync(Task task, ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures, ActionListener<ClusterStatsResponse> listener) {
        assert (Transports.assertNotTransportThread("Computation of mapping/analysis stats runs expensive computations on mappings found in the cluster state that are too slow for a transport thread"));
        assert (ThreadPool.assertCurrentThreadPool("management"));
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        ClusterState state = this.clusterService.state();
        Metadata metadata = state.metadata();
        ClusterSnapshotStats clusterSnapshotStats = ClusterSnapshotStats.of(state, this.clusterService.threadPool().absoluteTimeInMillis());
        ListenableFuture<MappingStats> mappingStatsStep = new ListenableFuture<MappingStats>();
        ListenableFuture analysisStatsStep = new ListenableFuture();
        this.mappingStatsCache.get(metadata, cancellableTask::isCancelled, mappingStatsStep);
        this.analysisStatsCache.get(metadata, cancellableTask::isCancelled, analysisStatsStep);
        mappingStatsStep.addListener(listener.delegateFailureAndWrap((l, mappingStats) -> analysisStatsStep.addListener(l.delegateFailureAndWrap((ll, analysisStats) -> ActionListener.completeWith(ll, () -> new ClusterStatsResponse(System.currentTimeMillis(), metadata.clusterUUID(), this.clusterService.getClusterName(), responses, failures, (MappingStats)mappingStats, (AnalysisStats)analysisStats, VersionStats.of(metadata, responses), clusterSnapshotStats))))));
    }

    @Override
    protected ClusterStatsResponse newResponse(ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures) {
        assert (false);
        throw new UnsupportedOperationException("use newResponseAsync instead");
    }

    @Override
    protected ClusterStatsNodeRequest newNodeRequest(ClusterStatsRequest request) {
        return new ClusterStatsNodeRequest();
    }

    @Override
    protected ClusterStatsNodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest, Task task) {
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        NodeInfo nodeInfo = this.nodeService.info(true, true, false, true, false, true, false, false, true, false, false, false);
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, false, true, true, true, false, true, false, false, false, false, false, true, false, false, false, false);
        ArrayList<ShardStats> shardsStats = new ArrayList<ShardStats>();
        for (IndexService indexService : this.indicesService) {
            for (IndexShard indexShard : indexService) {
                RetentionLeaseStats retentionLeaseStats;
                SeqNoStats seqNoStats;
                CommitStats commitStats;
                cancellableTask.ensureNotCancelled();
                if (indexShard.routingEntry() == null || !indexShard.routingEntry().active()) continue;
                try {
                    commitStats = indexShard.commitStats();
                    seqNoStats = indexShard.seqNoStats();
                    retentionLeaseStats = indexShard.getRetentionLeaseStats();
                }
                catch (AlreadyClosedException e) {
                    commitStats = null;
                    seqNoStats = null;
                    retentionLeaseStats = null;
                }
                shardsStats.add(new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), CommonStats.getShardLevelStats(this.indicesService.getIndicesQueryCache(), indexShard, SHARD_STATS_FLAGS), commitStats, seqNoStats, retentionLeaseStats, indexShard.isSearchIdle(), indexShard.searchIdleTime()));
            }
        }
        ClusterHealthStatus clusterStatus = null;
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            clusterStatus = new ClusterStateHealth(this.clusterService.state()).getStatus();
        }
        SearchUsageStats searchUsageStats = this.searchUsageHolder.getSearchUsageStats();
        return new ClusterStatsNodeResponse(nodeInfo.getNode(), clusterStatus, nodeInfo, nodeStats, shardsStats.toArray(new ShardStats[shardsStats.size()]), searchUsageStats);
    }

    private static class MetadataStatsCache<T>
    extends CancellableSingleObjectCache<Metadata, Long, T> {
        private final BiFunction<Metadata, Runnable, T> function;

        MetadataStatsCache(ThreadContext threadContext, BiFunction<Metadata, Runnable, T> function) {
            super(threadContext);
            this.function = function;
        }

        @Override
        protected void refresh(Metadata metadata, Runnable ensureNotCancelled, BooleanSupplier supersedeIfStale, ActionListener<T> listener) {
            ActionListener.completeWith(listener, () -> this.function.apply(metadata, ensureNotCancelled));
        }

        @Override
        protected Long getKey(Metadata indexMetadata) {
            return indexMetadata.version();
        }

        @Override
        protected boolean isFresh(Long currentKey, Long newKey) {
            return newKey <= currentKey;
        }
    }

    public static class ClusterStatsNodeRequest
    extends TransportRequest {
        ClusterStatsNodeRequest() {
        }

        public ClusterStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            TransportNodesAction.skipLegacyNodesRequestHeader(TransportVersions.DROP_UNUSED_NODES_REQUESTS, in);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            TransportNodesAction.sendLegacyNodesRequestHeader(TransportVersions.DROP_UNUSED_NODES_REQUESTS, out);
        }
    }
}

