/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.apache.lucene.util.HotspotVMOptions;
import org.apache.lucene.util.SuppressForbidden;

public final class Constants {
    private static final String UNKNOWN = "Unknown";
    public static final String JVM_VENDOR = Constants.getSysProp("java.vm.vendor", "Unknown");
    public static final String JVM_NAME = Constants.getSysProp("java.vm.name", "Unknown");
    @Deprecated
    public static final String JVM_VERSION = Runtime.version().toString();
    @Deprecated
    public static final String JVM_SPEC_VERSION = Integer.toString(Runtime.version().feature());
    @Deprecated
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = Constants.getSysProp("os.name", "Unknown");
    public static final boolean LINUX = OS_NAME.startsWith("Linux");
    public static final boolean WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean SUN_OS = OS_NAME.startsWith("SunOS");
    public static final boolean MAC_OS_X = OS_NAME.startsWith("Mac OS X");
    public static final boolean FREE_BSD = OS_NAME.startsWith("FreeBSD");
    public static final String OS_ARCH = Constants.getSysProp("os.arch", "Unknown");
    public static final String OS_VERSION = Constants.getSysProp("os.version", "Unknown");
    public static final String JAVA_VENDOR = Constants.getSysProp("java.vendor", "Unknown");
    public static final boolean IS_CLIENT_VM = Constants.getSysProp("java.vm.info", "").contains("emulated-client");
    public static final boolean IS_HOTSPOT_VM = HotspotVMOptions.IS_HOTSPOT_VM;
    public static final boolean IS_JVMCI_VM = HotspotVMOptions.get("UseJVMCICompiler").map(Boolean::valueOf).orElse(false);
    public static final boolean JRE_IS_64BIT = Constants.is64Bit();
    private static final boolean HAS_FMA = !IS_CLIENT_VM && HotspotVMOptions.get("UseFMA").map(Boolean::valueOf).orElse(false) != false;
    private static final int MAX_VECTOR_SIZE = HotspotVMOptions.get("MaxVectorSize").map(Integer::valueOf).orElse(0);
    private static final boolean HAS_SSE4A = HotspotVMOptions.get("UseXmmI2F").map(Boolean::valueOf).orElse(false);
    public static final boolean HAS_FAST_VECTOR_FMA = Constants.hasFastVectorFMA();
    public static final boolean HAS_FAST_SCALAR_FMA = Constants.hasFastScalarFMA();
    @Deprecated
    public static final boolean JRE_IS_MINIMUM_JAVA8 = true;
    @Deprecated
    public static final boolean JRE_IS_MINIMUM_JAVA9 = true;
    @Deprecated
    public static final boolean JRE_IS_MINIMUM_JAVA11 = true;

    private Constants() {
    }

    private static boolean is64Bit() {
        String datamodel = Constants.getSysProp("sun.arch.data.model");
        if (datamodel != null) {
            return datamodel.contains("64");
        }
        return OS_ARCH != null && OS_ARCH.contains("64");
    }

    private static boolean hasFastVectorFMA() {
        if (HAS_FMA) {
            String value = Constants.getSysProp("lucene.useVectorFMA", "auto");
            if ("auto".equals(value)) {
                if (OS_ARCH.equals("aarch64") && !MAC_OS_X) {
                    return true;
                }
                if (HAS_SSE4A && MAX_VECTOR_SIZE >= 32) {
                    return true;
                }
                if (OS_ARCH.equals("amd64") && !HAS_SSE4A) {
                    return true;
                }
            } else {
                return Boolean.parseBoolean(value);
            }
        }
        return false;
    }

    private static boolean hasFastScalarFMA() {
        if (HAS_FMA) {
            String value = Constants.getSysProp("lucene.useScalarFMA", "auto");
            if ("auto".equals(value)) {
                if (OS_ARCH.equals("aarch64") && !MAC_OS_X) {
                    return true;
                }
                if (HAS_SSE4A && MAX_VECTOR_SIZE >= 64) {
                    return true;
                }
                if (OS_ARCH.equals("amd64") && !HAS_SSE4A) {
                    return true;
                }
            } else {
                return Boolean.parseBoolean(value);
            }
        }
        return false;
    }

    private static String getSysProp(String property) {
        try {
            return Constants.doPrivileged(() -> System.getProperty(property));
        }
        catch (SecurityException se) {
            Constants.logSecurityWarning(property);
            return null;
        }
    }

    private static String getSysProp(String property, String def2) {
        try {
            return Constants.doPrivileged(() -> System.getProperty(property, def2));
        }
        catch (SecurityException se) {
            Constants.logSecurityWarning(property);
            return def2;
        }
    }

    private static void logSecurityWarning(String property) {
        Logger log = Logger.getLogger(Constants.class.getName());
        log.warning("SecurityManager prevented access to system property: " + property);
    }

    @SuppressForbidden(reason="security manager")
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }
}

