/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.geoip;

import co.elastic.logstash.filters.elasticintegration.geoip.ConstantGeoipDatabaseHolder;
import co.elastic.logstash.filters.elasticintegration.geoip.GeoIpDatabaseAdapter;
import co.elastic.logstash.filters.elasticintegration.geoip.GeoipDatabaseHolder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.ingest.geoip.GeoIpDatabase;

public class GeoIpDatabaseProvider
implements org.elasticsearch.ingest.geoip.GeoIpDatabaseProvider,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger(GeoIpDatabaseProvider.class);
    private final Map<String, GeoipDatabaseHolder> databaseMap;

    GeoIpDatabaseProvider(Map<String, GeoipDatabaseHolder> databaseMap) {
        this.databaseMap = Map.copyOf(databaseMap);
    }

    @Override
    public Boolean isValid(String databaseIdentifierFileName) {
        GeoipDatabaseHolder holder = this.databaseMap.get(databaseIdentifierFileName);
        return Objects.nonNull(holder) && holder.isValid();
    }

    @Override
    public GeoIpDatabase getDatabase(String databaseIdentifierFileName) {
        GeoipDatabaseHolder holder = this.databaseMap.get(databaseIdentifierFileName);
        if (Objects.isNull(holder)) {
            return null;
        }
        return holder.getDatabase();
    }

    @Override
    public void close() throws IOException {
        this.databaseMap.forEach((name, holder) -> {
            if (holder instanceof Closeable) {
                IOUtils.closeWhileHandlingException((Closeable)((Object)holder));
            }
        });
    }

    public static class Builder {
        private final Map<String, GeoipDatabaseHolder> databaseMap = new HashMap<String, GeoipDatabaseHolder>();

        public synchronized Builder setDatabaseHolder(String identifierFileName, GeoipDatabaseHolder holder) {
            GeoipDatabaseHolder previous = this.databaseMap.put(identifierFileName, holder);
            if (Objects.nonNull(previous)) {
                LOGGER.warn(String.format("de-registered previous entry for `%s`: %s", identifierFileName, previous.info()));
                if (previous instanceof Closeable) {
                    IOUtils.closeWhileHandlingException((Closeable)((Object)previous));
                }
            }
            return this;
        }

        public Builder discoverDatabases(File directory) throws IOException {
            List<Path> databases = Files.find(directory.toPath(), 3, Builder::isMaxMindDatabase, new FileVisitOption[0]).toList();
            if (databases.isEmpty()) {
                LOGGER.warn(String.format("Failed to find Maxmind DB files in `%s`", directory));
            } else {
                for (Path database : databases) {
                    try {
                        GeoIpDatabaseAdapter adapter = GeoIpDatabaseAdapter.defaultForPath(database);
                        ConstantGeoipDatabaseHolder holder = new ConstantGeoipDatabaseHolder(adapter);
                        this.setDatabaseHolder(database.getFileName().toString(), holder);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return this;
        }

        private static boolean isMaxMindDatabase(Path path, BasicFileAttributes basicFileAttributes) {
            return basicFileAttributes.isRegularFile() && path.getFileName().toString().endsWith(".mmdb");
        }

        public final GeoIpDatabaseProvider build() {
            return new GeoIpDatabaseProvider(this.databaseMap);
        }
    }
}

