/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.geoip;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.ingest.geoip.GeoIpDatabase;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.CHMCache;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.NodeCache;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.DatabaseReader;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.AbstractResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.AnonymousIpResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.AsnResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.CityResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.ConnectionTypeResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.CountryResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.DomainResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.EnterpriseResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.IspResponse;

public class GeoIpDatabaseAdapter
implements GeoIpDatabase,
Closeable {
    private final DatabaseReader databaseReader;
    private final String databaseType;

    public GeoIpDatabaseAdapter(DatabaseReader databaseReader) {
        this.databaseReader = databaseReader;
        this.databaseType = databaseReader.getMetadata().getDatabaseType();
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public CityResponse getCity(InetAddress inetAddress) {
        return (CityResponse)this.getResponse(inetAddress, this.databaseReader::tryCity);
    }

    @Override
    public CountryResponse getCountry(InetAddress inetAddress) {
        return (CountryResponse)this.getResponse(inetAddress, this.databaseReader::tryCountry);
    }

    @Override
    public AsnResponse getAsn(InetAddress inetAddress) {
        return (AsnResponse)this.getResponse(inetAddress, this.databaseReader::tryAsn);
    }

    @Override
    public AnonymousIpResponse getAnonymousIp(InetAddress ipAddress) {
        return (AnonymousIpResponse)this.getResponse(ipAddress, this.databaseReader::tryAnonymousIp);
    }

    @Override
    public EnterpriseResponse getEnterprise(InetAddress ipAddress) {
        return (EnterpriseResponse)this.getResponse(ipAddress, this.databaseReader::tryEnterprise);
    }

    @Override
    public ConnectionTypeResponse getConnectionType(InetAddress inetAddress) {
        return (ConnectionTypeResponse)this.getResponse(inetAddress, this.databaseReader::tryConnectionType);
    }

    @Override
    public DomainResponse getDomain(InetAddress ipAddress) {
        return (DomainResponse)this.getResponse(ipAddress, this.databaseReader::tryDomain);
    }

    @Override
    public IspResponse getIsp(InetAddress ipAddress) {
        return (IspResponse)this.getResponse(ipAddress, this.databaseReader::tryIsp);
    }

    private <T extends AbstractResponse> T getResponse(InetAddress inetAddress, MaxmindTryLookup<T> resolver) {
        try {
            return (T)((AbstractResponse)resolver.lookup(inetAddress).orElse(null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void release() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.databaseReader.close();
    }

    public static GeoIpDatabaseAdapter defaultForPath(Path database) throws IOException {
        return new Builder(database.toFile()).setCache(new CHMCache(10000)).build();
    }

    static interface MaxmindTryLookup<T extends AbstractResponse> {
        public Optional<T> lookup(InetAddress var1) throws Exception;
    }

    public static class Builder {
        private File databasePath;
        private NodeCache nodeCache;

        public Builder(File databasePath) {
            this.databasePath = databasePath;
        }

        public Builder setCache(NodeCache nodeCache) {
            this.nodeCache = nodeCache;
            return this;
        }

        public GeoIpDatabaseAdapter build() throws IOException {
            DatabaseReader.Builder readerBuilder = new DatabaseReader.Builder(this.databasePath);
            if (Objects.nonNull(this.nodeCache)) {
                readerBuilder.withCache(this.nodeCache);
            }
            return new GeoIpDatabaseAdapter(readerBuilder.build());
        }
    }
}

