/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

public class PreflightCheck {
    private final RestClient elasticsearchRestClient;
    private final Logger logger;
    private static final Set<String> SUPPORTED_LICENSE_TYPES = Set.of("enterprise", "trial");
    private static final Logger LOGGER = LogManager.getLogger(PreflightCheck.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Map<String, String> REQUIRED_CLUSTER_PRIVILEGES;

    public PreflightCheck(RestClient elasticsearchRestClient) {
        this(LOGGER, elasticsearchRestClient);
    }

    PreflightCheck(Logger logger, RestClient elasticsearchRestClient) {
        this.logger = logger;
        this.elasticsearchRestClient = elasticsearchRestClient;
    }

    public void checkUserPrivileges() {
        try {
            Request hasPrivilegesRequest = new Request("POST", "/_security/user/_has_privileges");
            hasPrivilegesRequest.setJsonEntity(OBJECT_MAPPER.writeValueAsString(Map.of("cluster", REQUIRED_CLUSTER_PRIVILEGES.keySet())));
            Response hasPrivilegesResponse = this.elasticsearchRestClient.performRequest(hasPrivilegesRequest);
            String responseBody = new String(hasPrivilegesResponse.getEntity().getContent().readAllBytes(), StandardCharsets.UTF_8);
            JsonNode hasPrivilegesRootNode = OBJECT_MAPPER.readTree(responseBody);
            Map clusterPrivileges = (Map)OBJECT_MAPPER.convertValue((Object)hasPrivilegesRootNode.path("cluster"), (TypeReference)new TypeReference<Map<String, Boolean>>(){});
            for (Map.Entry<String, String> requiredPrivilegeAndReason : REQUIRED_CLUSTER_PRIVILEGES.entrySet()) {
                String requiredPrivilege = requiredPrivilegeAndReason.getKey();
                if (((Boolean)clusterPrivileges.get(requiredPrivilege)).booleanValue()) continue;
                this.logger.debug(() -> String.format("missing required privilege `%s`: %s", requiredPrivilege, responseBody));
                throw new Failure(String.format("The cluster privilege `%s` is REQUIRED in order to %s", requiredPrivilege, requiredPrivilegeAndReason.getValue()));
            }
            this.logger.debug(() -> String.format("has all required privileges: %s", responseBody));
        }
        catch (Failure f) {
            throw f;
        }
        catch (Exception e) {
            throw new Failure(String.format("Preflight check failed: %s", e.getMessage()), e);
        }
    }

    public void checkLicense() {
        try {
            Request licenseRequest = new Request("GET", "/_license");
            Response licenseResponse = this.elasticsearchRestClient.performRequest(licenseRequest);
            String responseBody = new String(licenseResponse.getEntity().getContent().readAllBytes(), StandardCharsets.UTF_8);
            JsonNode licenseNode = OBJECT_MAPPER.readTree(responseBody).get("license");
            String licenseStatus = licenseNode.get("status").asText();
            String licenseType = licenseNode.get("type").asText();
            this.logger.debug(() -> String.format("Elasticsearch license RAW: %s", responseBody));
            if (!SUPPORTED_LICENSE_TYPES.contains(licenseType)) {
                this.logger.warn(String.format("Elasticsearch license.type is `%s`", licenseType));
            } else if (!Objects.equals(licenseStatus, "active")) {
                this.logger.warn(String.format("Elasticsearch license.status is `%s`", licenseStatus));
            } else {
                this.logger.info(String.format("Elasticsearch license OK (%s %s)", licenseStatus, licenseType));
            }
        }
        catch (Failure f) {
            throw f;
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception checking license: %s", e.getMessage()));
            throw new Failure(String.format("Preflight check failed: %s", e.getMessage()), e);
        }
    }

    public boolean isServerless() {
        try {
            Request req = new Request("GET", "/");
            Response res = this.elasticsearchRestClient.performRequest(req);
            String resBody = new String(res.getEntity().getContent().readAllBytes(), StandardCharsets.UTF_8);
            this.logger.debug(() -> String.format("Elasticsearch '/' RAW: %s", resBody));
            JsonNode versionNode = OBJECT_MAPPER.readTree(resBody).get("version");
            String buildFlavor = versionNode.get("build_flavor").asText();
            this.logger.info(String.format("Elasticsearch build_flavor: %s", buildFlavor));
            return buildFlavor.equals("serverless");
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception checking serverless: %s", e.getMessage()));
            throw new Failure(String.format("Preflight check failed: %s", e.getMessage()), e);
        }
    }

    static {
        LinkedHashMap<String, String> prv = new LinkedHashMap<String, String>();
        prv.put("monitor", "validate Elasticsearch license");
        prv.put("read_pipeline", "retrieve Elasticsearch ingest pipeline definitions");
        prv.put("manage_index_templates", "resolve a data stream name to its default pipeline");
        REQUIRED_CLUSTER_PRIVILEGES = Collections.unmodifiableMap(prv);
    }

    public static class Failure
    extends RuntimeException {
        public Failure(String message, Throwable cause) {
            super(message, cause);
        }

        public Failure(String message) {
            super(message);
        }
    }
}

