/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.filters.elasticintegration.IngestPipeline;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.ingest.PipelineProcessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;

public class IngestPipelineFactory {
    private final ScriptService scriptService;
    private final Map<String, Processor.Factory> processorFactories;
    private static final Logger LOGGER = LogManager.getLogger(IngestPipelineFactory.class);

    public IngestPipelineFactory(ScriptService scriptService) {
        this(scriptService, Map.of());
    }

    private IngestPipelineFactory(ScriptService scriptService, Map<String, Processor.Factory> processorFactories) {
        this.scriptService = scriptService;
        this.processorFactories = Map.copyOf(processorFactories);
    }

    public IngestPipelineFactory withProcessors(Map<String, Processor.Factory> processorFactories) {
        HashMap<String, Processor.Factory> intermediate = new HashMap<String, Processor.Factory>(this.processorFactories);
        intermediate.putAll(processorFactories);
        return new IngestPipelineFactory(this.scriptService, intermediate);
    }

    public Optional<IngestPipeline> create(PipelineConfiguration pipelineConfiguration) {
        try {
            Pipeline pipeline = Pipeline.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfigAsMap(), this.processorFactories, this.scriptService);
            IngestPipeline ingestPipeline = new IngestPipeline(pipelineConfiguration, pipeline);
            LOGGER.debug(() -> String.format("successfully created ingest pipeline `%s` from pipeline configuration", pipelineConfiguration.getId()));
            return Optional.of(ingestPipeline);
        }
        catch (Exception e) {
            LOGGER.error(() -> String.format("failed to create ingest pipeline `%s` from pipeline configuration", pipelineConfiguration.getId()), (Throwable)e);
            return Optional.empty();
        }
    }

    public IngestPipelineFactory withIngestPipelineResolver(IngestPipelineResolver ingestPipelineResolver) {
        HashMap<String, Processor.Factory> modifiedProcessorFactories = new HashMap<String, Processor.Factory>(this.processorFactories);
        modifiedProcessorFactories.put("pipeline", new PipelineProcessor.Factory(ingestPipelineResolver, this.scriptService));
        return new IngestPipelineFactory(this.scriptService, modifiedProcessorFactories);
    }
}

