/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpdateTrainedModelDeploymentResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateTrainedModelDeploymentRequest
extends RequestBase
implements JsonpSerializable {
    private final String modelId;
    @Nullable
    private final Integer numberOfAllocations;
    public static final JsonpDeserializer<UpdateTrainedModelDeploymentRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateTrainedModelDeploymentRequest::setupUpdateTrainedModelDeploymentRequestDeserializer);
    public static final Endpoint<UpdateTrainedModelDeploymentRequest, UpdateTrainedModelDeploymentResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateTrainedModelDeploymentRequest, UpdateTrainedModelDeploymentResponse>("es/ml.update_trained_model_deployment", request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/deployment");
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateTrainedModelDeploymentResponse._DESERIALIZER);

    private UpdateTrainedModelDeploymentRequest(Builder builder) {
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.numberOfAllocations = builder.numberOfAllocations;
    }

    public static UpdateTrainedModelDeploymentRequest of(Function<Builder, ObjectBuilder<UpdateTrainedModelDeploymentRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer numberOfAllocations() {
        return this.numberOfAllocations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numberOfAllocations != null) {
            generator.writeKey("number_of_allocations");
            generator.write(this.numberOfAllocations);
        }
    }

    protected static void setupUpdateTrainedModelDeploymentRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfAllocations, JsonpDeserializer.integerDeserializer(), "number_of_allocations");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateTrainedModelDeploymentRequest> {
        private String modelId;
        @Nullable
        private Integer numberOfAllocations;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder numberOfAllocations(@Nullable Integer value) {
            this.numberOfAllocations = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateTrainedModelDeploymentRequest build() {
            this._checkSingleUse();
            return new UpdateTrainedModelDeploymentRequest(this);
        }
    }
}

