/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RankedDocument
implements JsonpSerializable {
    private final int index;
    private final float score;
    @Nullable
    private final String text;
    public static final JsonpDeserializer<RankedDocument> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankedDocument::setupRankedDocumentDeserializer);

    private RankedDocument(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.score = ApiTypeHelper.requireNonNull(builder.score, this, "score").floatValue();
        this.text = builder.text;
    }

    public static RankedDocument of(Function<Builder, ObjectBuilder<RankedDocument>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int index() {
        return this.index;
    }

    public final float score() {
        return this.score;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("score");
        generator.write(this.score);
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRankedDocumentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.integerDeserializer(), "index");
        op.add(Builder::score, JsonpDeserializer.floatDeserializer(), "score");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RankedDocument> {
        private Integer index;
        private Float score;
        @Nullable
        private String text;

        public final Builder index(int value) {
            this.index = value;
            return this;
        }

        public final Builder score(float value) {
            this.score = Float.valueOf(value);
            return this;
        }

        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankedDocument build() {
            this._checkSingleUse();
            return new RankedDocument(this);
        }
    }
}

