/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TermSuggestOption
implements JsonpSerializable {
    private final String text;
    private final double score;
    private final long freq;
    @Nullable
    private final String highlighted;
    @Nullable
    private final Boolean collateMatch;
    public static final JsonpDeserializer<TermSuggestOption> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermSuggestOption::setupTermSuggestOptionDeserializer);

    private TermSuggestOption(Builder builder) {
        this.text = ApiTypeHelper.requireNonNull(builder.text, this, "text");
        this.score = ApiTypeHelper.requireNonNull(builder.score, this, "score");
        this.freq = ApiTypeHelper.requireNonNull(builder.freq, this, "freq");
        this.highlighted = builder.highlighted;
        this.collateMatch = builder.collateMatch;
    }

    public static TermSuggestOption of(Function<Builder, ObjectBuilder<TermSuggestOption>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String text() {
        return this.text;
    }

    public final double score() {
        return this.score;
    }

    public final long freq() {
        return this.freq;
    }

    @Nullable
    public final String highlighted() {
        return this.highlighted;
    }

    @Nullable
    public final Boolean collateMatch() {
        return this.collateMatch;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("text");
        generator.write(this.text);
        generator.writeKey("score");
        generator.write(this.score);
        generator.writeKey("freq");
        generator.write(this.freq);
        if (this.highlighted != null) {
            generator.writeKey("highlighted");
            generator.write(this.highlighted);
        }
        if (this.collateMatch != null) {
            generator.writeKey("collate_match");
            generator.write(this.collateMatch);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTermSuggestOptionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "score");
        op.add(Builder::freq, JsonpDeserializer.longDeserializer(), "freq");
        op.add(Builder::highlighted, JsonpDeserializer.stringDeserializer(), "highlighted");
        op.add(Builder::collateMatch, JsonpDeserializer.booleanDeserializer(), "collate_match");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TermSuggestOption> {
        private String text;
        private Double score;
        private Long freq;
        @Nullable
        private String highlighted;
        @Nullable
        private Boolean collateMatch;

        public final Builder text(String value) {
            this.text = value;
            return this;
        }

        public final Builder score(double value) {
            this.score = value;
            return this;
        }

        public final Builder freq(long value) {
            this.freq = value;
            return this;
        }

        public final Builder highlighted(@Nullable String value) {
            this.highlighted = value;
            return this;
        }

        public final Builder collateMatch(@Nullable Boolean value) {
            this.collateMatch = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermSuggestOption build() {
            this._checkSingleUse();
            return new TermSuggestOption(this);
        }
    }
}

