/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RuleQuery
extends QueryBase
implements QueryVariant {
    private final Query organic;
    private final String rulesetId;
    private final JsonData matchCriteria;
    public static final JsonpDeserializer<RuleQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuleQuery::setupRuleQueryDeserializer);

    private RuleQuery(Builder builder) {
        super(builder);
        this.organic = ApiTypeHelper.requireNonNull(builder.organic, this, "organic");
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
        this.matchCriteria = ApiTypeHelper.requireNonNull(builder.matchCriteria, this, "matchCriteria");
    }

    public static RuleQuery of(Function<Builder, ObjectBuilder<RuleQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.RuleQuery;
    }

    public final Query organic() {
        return this.organic;
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public final JsonData matchCriteria() {
        return this.matchCriteria;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("organic");
        this.organic.serialize(generator, mapper);
        generator.writeKey("ruleset_id");
        generator.write(this.rulesetId);
        generator.writeKey("match_criteria");
        this.matchCriteria.serialize(generator, mapper);
    }

    protected static void setupRuleQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::organic, Query._DESERIALIZER, "organic");
        op.add(Builder::rulesetId, JsonpDeserializer.stringDeserializer(), "ruleset_id");
        op.add(Builder::matchCriteria, JsonData._DESERIALIZER, "match_criteria");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RuleQuery> {
        private Query organic;
        private String rulesetId;
        private JsonData matchCriteria;

        public final Builder organic(Query value) {
            this.organic = value;
            return this;
        }

        public final Builder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.organic(fn.apply(new Query.Builder()).build());
        }

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        public final Builder matchCriteria(JsonData value) {
            this.matchCriteria = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuleQuery build() {
            this._checkSingleUse();
            return new RuleQuery(this);
        }
    }
}

