/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KeywordProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean eagerGlobalOrdinals;
    @Nullable
    private final Boolean index;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final Script script;
    @Nullable
    private final OnScriptError onScriptError;
    @Nullable
    private final String normalizer;
    @Nullable
    private final Boolean norms;
    @Nullable
    private final String nullValue;
    @Nullable
    private final Boolean splitQueriesOnWhitespace;
    @Nullable
    private final Boolean timeSeriesDimension;
    public static final JsonpDeserializer<KeywordProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordProperty::setupKeywordPropertyDeserializer);

    private KeywordProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.script = builder.script;
        this.onScriptError = builder.onScriptError;
        this.normalizer = builder.normalizer;
        this.norms = builder.norms;
        this.nullValue = builder.nullValue;
        this.splitQueriesOnWhitespace = builder.splitQueriesOnWhitespace;
        this.timeSeriesDimension = builder.timeSeriesDimension;
    }

    public static KeywordProperty of(Function<Builder, ObjectBuilder<KeywordProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Keyword;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Nullable
    public final String normalizer() {
        return this.normalizer;
    }

    @Nullable
    public final Boolean norms() {
        return this.norms;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Boolean splitQueriesOnWhitespace() {
        return this.splitQueriesOnWhitespace;
    }

    @Nullable
    public final Boolean timeSeriesDimension() {
        return this.timeSeriesDimension;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost);
        }
        if (this.eagerGlobalOrdinals != null) {
            generator.writeKey("eager_global_ordinals");
            generator.write(this.eagerGlobalOrdinals);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.write(this.normalizer);
        }
        if (this.norms != null) {
            generator.writeKey("norms");
            generator.write(this.norms);
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
        if (this.splitQueriesOnWhitespace != null) {
            generator.writeKey("split_queries_on_whitespace");
            generator.write(this.splitQueriesOnWhitespace);
        }
        if (this.timeSeriesDimension != null) {
            generator.writeKey("time_series_dimension");
            generator.write(this.timeSeriesDimension);
        }
    }

    protected static void setupKeywordPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::eagerGlobalOrdinals, JsonpDeserializer.booleanDeserializer(), "eager_global_ordinals");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
        op.add(Builder::normalizer, JsonpDeserializer.stringDeserializer(), "normalizer");
        op.add(Builder::norms, JsonpDeserializer.booleanDeserializer(), "norms");
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.add(Builder::splitQueriesOnWhitespace, JsonpDeserializer.booleanDeserializer(), "split_queries_on_whitespace");
        op.add(Builder::timeSeriesDimension, JsonpDeserializer.booleanDeserializer(), "time_series_dimension");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeywordProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean eagerGlobalOrdinals;
        @Nullable
        private Boolean index;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private Script script;
        @Nullable
        private OnScriptError onScriptError;
        @Nullable
        private String normalizer;
        @Nullable
        private Boolean norms;
        @Nullable
        private String nullValue;
        @Nullable
        private Boolean splitQueriesOnWhitespace;
        @Nullable
        private Boolean timeSeriesDimension;

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder eagerGlobalOrdinals(@Nullable Boolean value) {
            this.eagerGlobalOrdinals = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return this;
        }

        public final Builder normalizer(@Nullable String value) {
            this.normalizer = value;
            return this;
        }

        public final Builder norms(@Nullable Boolean value) {
            this.norms = value;
            return this;
        }

        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        public final Builder splitQueriesOnWhitespace(@Nullable Boolean value) {
            this.splitQueriesOnWhitespace = value;
            return this;
        }

        public final Builder timeSeriesDimension(@Nullable Boolean value) {
            this.timeSeriesDimension = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeywordProperty build() {
            this._checkSingleUse();
            return new KeywordProperty(this);
        }
    }
}

