/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DocStats
implements JsonpSerializable {
    private final long count;
    @Nullable
    private final Long deleted;
    public static final JsonpDeserializer<DocStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DocStats::setupDocStatsDeserializer);

    private DocStats(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.deleted = builder.deleted;
    }

    public static DocStats of(Function<Builder, ObjectBuilder<DocStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Long deleted() {
        return this.deleted;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.deleted != null) {
            generator.writeKey("deleted");
            generator.write(this.deleted);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDocStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DocStats> {
        private Long count;
        @Nullable
        private Long deleted;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder deleted(@Nullable Long value) {
            this.deleted = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DocStats build() {
            this._checkSingleUse();
            return new DocStats(this);
        }
    }
}

