/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.logstash.config.ir.compiler.Closure;
import org.logstash.config.ir.compiler.MethodLevelSyntaxElement;
import org.logstash.config.ir.compiler.SyntaxElement;
import org.logstash.config.ir.compiler.ValueSyntaxElement;
import org.logstash.config.ir.compiler.VariableDefinition;

final class SyntaxFactory {
    SyntaxFactory() {
    }

    public static String join(String ... parts) {
        return String.join((CharSequence)"", parts);
    }

    public static MethodLevelSyntaxElement ret(MethodLevelSyntaxElement value) {
        return new ReturnStatement(value);
    }

    public static ValueSyntaxElement value(String value) {
        return new ValueStatement(value);
    }

    public static IdentifierStatement identifier(String name) {
        return new IdentifierStatement(name);
    }

    public static ValueSyntaxElement constant(Class<?> clazz, String name) {
        return new ValueStatement(SyntaxFactory.join(clazz.getName(), ".", name));
    }

    public static MethodLevelSyntaxElement assignment(SyntaxElement target, MethodLevelSyntaxElement value) {
        return new Assignment(target, value);
    }

    public static ValueSyntaxElement cast(Class<?> clazz, ValueSyntaxElement argument) {
        return new TypeCastStatement(clazz, argument);
    }

    public static MethodLevelSyntaxElement and(ValueSyntaxElement left, ValueSyntaxElement right) {
        return () -> SyntaxFactory.join("(", left.generateCode(), "&&", right.generateCode(), ")");
    }

    public static ValueSyntaxElement ternary(ValueSyntaxElement condition, ValueSyntaxElement left, ValueSyntaxElement right) {
        return new TernaryStatement(condition, left, right);
    }

    public static MethodLevelSyntaxElement not(ValueSyntaxElement var) {
        return () -> SyntaxFactory.join("!(", var.generateCode(), ")");
    }

    public static MethodLevelSyntaxElement forLoop(VariableDefinition element, MethodLevelSyntaxElement iterable, Closure body) {
        return () -> SyntaxFactory.join("for (", element.generateCode(), " : ", iterable.generateCode(), ") {\n", body.generateCode(), "\n}");
    }

    public static MethodLevelSyntaxElement ifCondition(MethodLevelSyntaxElement condition, Closure body) {
        return SyntaxFactory.ifCondition(condition, body, Closure.EMPTY);
    }

    public static MethodLevelSyntaxElement ifCondition(MethodLevelSyntaxElement condition, Closure left, Closure right) {
        return () -> SyntaxFactory.join("if(", condition.generateCode(), ") {\n", left.generateCode(), "\n}", right.empty() ? "" : SyntaxFactory.join(" else {\n", right.generateCode(), "\n}"));
    }

    private static final class ReturnStatement
    implements MethodLevelSyntaxElement {
        private final MethodLevelSyntaxElement value;

        private ReturnStatement(MethodLevelSyntaxElement value) {
            this.value = value;
        }

        @Override
        public String generateCode() {
            return SyntaxFactory.join("return ", this.value.generateCode());
        }
    }

    private static final class ValueStatement
    implements ValueSyntaxElement {
        private final String value;

        private ValueStatement(String value) {
            this.value = value;
        }

        @Override
        public String generateCode() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ValueStatement)) {
                return false;
            }
            return this.value.equals(((ValueStatement)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class IdentifierStatement
    implements ValueSyntaxElement {
        private final String value;

        private IdentifierStatement(String value) {
            this.value = value;
        }

        @Override
        public String generateCode() {
            return this.value;
        }
    }

    private static final class Assignment
    implements MethodLevelSyntaxElement {
        private final SyntaxElement field;
        private final MethodLevelSyntaxElement value;

        private Assignment(SyntaxElement field, MethodLevelSyntaxElement value) {
            this.field = field;
            this.value = value;
        }

        @Override
        public String generateCode() {
            return SyntaxFactory.join(this.field.generateCode(), "=", this.value.generateCode());
        }
    }

    private static final class TypeCastStatement
    implements ValueSyntaxElement {
        private final Class<?> clazz;
        private final ValueSyntaxElement argument;

        private TypeCastStatement(Class<?> clazz, ValueSyntaxElement argument) {
            this.clazz = clazz;
            this.argument = argument;
        }

        @Override
        public String generateCode() {
            return SyntaxFactory.join("((", this.clazz.getName(), ")", this.argument.generateCode(), ")");
        }
    }

    private static final class TernaryStatement
    implements ValueSyntaxElement {
        private final ValueSyntaxElement left;
        private final ValueSyntaxElement right;
        private final ValueSyntaxElement condition;

        private TernaryStatement(ValueSyntaxElement condition, ValueSyntaxElement left, ValueSyntaxElement right) {
            this.condition = condition;
            this.left = left;
            this.right = right;
        }

        @Override
        public String generateCode() {
            return SyntaxFactory.join("(", this.condition.generateCode(), " ? ", this.left.generateCode(), " : ", this.right.generateCode(), ")");
        }
    }

    static final class MethodCallReturnValue
    implements ValueSyntaxElement {
        private final MethodLevelSyntaxElement instance;
        private final String method;
        private final Collection<MethodLevelSyntaxElement> args;

        MethodCallReturnValue(MethodLevelSyntaxElement instance, String method, MethodLevelSyntaxElement ... args) {
            this.instance = instance;
            this.args = Arrays.asList(args);
            this.method = method;
        }

        @Override
        public String generateCode() {
            return SyntaxFactory.join(this.instance.generateCode(), ".", this.method, "(", String.join((CharSequence)",", this.args.stream().map(SyntaxElement::generateCode).collect(Collectors.toList())), ")");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodCallReturnValue)) {
                return false;
            }
            MethodCallReturnValue that = (MethodCallReturnValue)other;
            return this.instance.equals(that.instance) && this.method.equals(that.method) && this.args.size() == that.args.size() && this.args.containsAll(that.args);
        }

        public int hashCode() {
            return Objects.hash(this.instance, this.method, this.args);
        }
    }
}

