/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.SqlException;

class ClobOutputStream
extends OutputStream {
    private ClientClob clob_;
    private long offset_;

    ClobOutputStream(ClientClob clob, long offset) throws SqlException {
        this.clob_ = clob;
        this.offset_ = offset;
        if (this.offset_ - 1L > this.clob_.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] newByte = new byte[]{(byte)b};
        this.writeBytes(newByte);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] newByte = new byte[len];
        System.arraycopy(b, off, newByte, 0, len);
        this.writeBytes(newByte);
    }

    private void writeBytes(byte[] b) throws IOException {
        String str = new String(b, "ISO-8859-1");
        this.clob_.reInitForNonLocator(this.clob_.string_.substring(0, (int)this.offset_ - 1).concat(str));
        this.offset_ += (long)b.length;
    }
}

