/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableInstanceGetter;
import org.apache.derby.iapi.services.io.RegisteredFormatIds;
import org.apache.derby.iapi.services.loader.ClassInfo;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.impl.services.monitor.ProtocolKey;
import org.apache.derby.impl.services.monitor.ServiceBootContext;
import org.apache.derby.impl.services.monitor.StorageFactoryService;
import org.apache.derby.impl.services.monitor.TopService;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.shared.common.error.ErrorStringBuilder;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.BundleFinder;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.InfoStreams;
import org.apache.derby.shared.common.stream.PrintWriterGetHeader;

abstract class BaseMonitor
implements ModuleFactory,
BundleFinder {
    private final HashMap<String, PersistentService> serviceProviders = new HashMap();
    private static final String LINE = "----------------------------------------------------------------";
    private List<List<Class<?>>> implementationSets;
    private final Vector<TopService> services = new Vector(0, 1);
    Properties bootProperties;
    Properties applicationProperties;
    boolean inShutdown;
    private InfoStreams systemStreams;
    private ContextService contextService;
    private UUIDFactory uuidFactory;
    private TimerFactory timerFactory;
    boolean reportOn;
    private PrintWriter logging;
    ThreadGroup daemonGroup;
    private InstanceGetter[] rc2;
    private static final String SERVICE = "derby.service.";
    private static final HashMap<String, String> storageFactories = new HashMap();
    private PrintWriter tmpWriter;
    private AccessibleByteArrayOutputStream tmpArray;
    private boolean dumpedTempWriter;

    BaseMonitor() {
        this.services.add(new TopService(this));
    }

    @Override
    public InfoStreams getSystemStreams() {
        return this.systemStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutdown() {
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            if (this.inShutdown) {
                return;
            }
            this.inShutdown = true;
        }
        Monitor.getStream().println(LINE);
        Monitor.getStream().println(MessageService.getTextMessage((String)"J003", (Object[])new Object[]{new Date().toString()}));
        if (this.reportOn) {
            this.report("Shutdown request");
        }
        this.contextService.notifyAllActiveThreads(null);
        while (true) {
            TopService ts;
            BaseMonitor baseMonitor2 = this;
            synchronized (baseMonitor2) {
                int position = this.services.size() - 1;
                if (position == 0) {
                    // MONITOREXIT @DISABLED, blocks:[4, 7, 8] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                    Monitor.getStream().println(LINE);
                    this.services.get(0).shutdown();
                    BaseMonitor.stopContextService();
                    return;
                }
                ts = this.services.get(position);
            }
            ContextManager cm = this.contextService.newContextManager();
            try {
                cm.popContext();
                this.contextService.setCurrentContextManager(cm);
                this.shutdown(ts.getService());
                continue;
            }
            finally {
                this.contextService.resetCurrentContextManager(cm);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(Object serviceModule) {
        if (serviceModule == null) {
            return;
        }
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return;
        }
        boolean removeService = true;
        try {
            removeService = ts.shutdown();
        }
        finally {
            BaseMonitor baseMonitor = this;
            synchronized (baseMonitor) {
                if (removeService) {
                    boolean found = this.services.remove(ts);
                    SanityManager.ASSERT((boolean)found, (String)("service was not found " + serviceModule));
                }
            }
        }
    }

    protected final void runWithState(Properties properties, PrintWriter log) {
        this.bootProperties = properties;
        this.logging = log;
        if (!this.initialize(false)) {
            this.dumpTempWriter(true);
            return;
        }
        if (BaseMonitor.setMonitor(this)) {
            return;
        }
        MessageService.setFinder((BundleFinder)this);
        this.reportOn = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.monitor.verbose"));
        this.applicationProperties = this.readApplicationProperties();
        Properties systemProperties = null;
        try {
            systemProperties = System.getProperties();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Vector<Class<?>> bootImplementations = this.getImplementations(this.bootProperties, false);
        Vector<Class<?>> systemImplementations = null;
        Vector<Class<?>> applicationImplementations = null;
        systemImplementations = this.getImplementations(systemProperties, false);
        applicationImplementations = this.getImplementations(this.applicationProperties, false);
        Vector<Class<?>> defaultImplementations = this.getDefaultImplementations();
        int implementationCount = 0;
        if (bootImplementations != null) {
            ++implementationCount;
        }
        if (systemImplementations != null) {
            ++implementationCount;
        }
        if (applicationImplementations != null) {
            ++implementationCount;
        }
        if (defaultImplementations != null) {
            ++implementationCount;
        }
        this.implementationSets = new ArrayList(implementationCount);
        if (bootImplementations != null) {
            this.implementationSets.add(bootImplementations);
        }
        if (systemImplementations != null) {
            this.implementationSets.add(systemImplementations);
        }
        if (applicationImplementations != null) {
            this.implementationSets.add(applicationImplementations);
        }
        if (defaultImplementations != null) {
            this.implementationSets.add(defaultImplementations);
        }
        if (this.applicationProperties != null) {
            this.addDebugFlags(this.applicationProperties.getProperty(Monitor.DEBUG_FALSE), false);
            this.addDebugFlags(this.applicationProperties.getProperty(Monitor.DEBUG_TRUE), true);
        }
        this.addDebugFlags(PropertyUtil.getSystemProperty(Monitor.DEBUG_FALSE), false);
        this.addDebugFlags(PropertyUtil.getSystemProperty(Monitor.DEBUG_TRUE), true);
        try {
            this.systemStreams = (InfoStreams)Monitor.startSystemModule("org.apache.derby.shared.common.stream.InfoStreams");
            SanityManager.SET_DEBUG_STREAM((PrintWriter)this.systemStreams.stream().getPrintWriter());
            this.contextService = new ContextService();
            this.uuidFactory = (UUIDFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.uuid.UUIDFactory");
            this.timerFactory = (TimerFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.timer.TimerFactory");
            Monitor.startSystemModule("org.apache.derby.iapi.services.jmx.ManagementService");
        }
        catch (StandardException se) {
            this.reportException(se);
            this.dumpTempWriter(true);
            return;
        }
        catch (AccessControlException e) {
            this.dumpTempWriter(true);
            throw e;
        }
        this.dumpTempWriter(false);
        if (this.reportOn) {
            this.dumpProperties("-- Boot Properties --", this.bootProperties);
            this.dumpProperties("-- System Properties --", systemProperties);
            this.dumpProperties("-- Application Properties --", this.applicationProperties);
        }
        this.determineSupportedServiceProviders();
        boolean bootAll = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.system.bootAll"));
        this.startServices(this.bootProperties, bootAll);
        this.startServices(systemProperties, bootAll);
        this.startServices(this.applicationProperties, bootAll);
        if (bootAll) {
            this.bootPersistentServices();
        }
    }

    @Override
    public String getCanonicalServiceName(String userSpecifiedName) throws StandardException {
        if (userSpecifiedName == null) {
            return null;
        }
        PersistentService correspondingService = this.findProviderForCreate(userSpecifiedName);
        if (correspondingService == null) {
            return null;
        }
        return correspondingService.getCanonicalServiceName(userSpecifiedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findService(String factoryInterface, String serviceName) {
        ProtocolKey key;
        if (serviceName == null) {
            return null;
        }
        try {
            key = ProtocolKey.create(factoryInterface, serviceName);
        }
        catch (StandardException se) {
            return null;
        }
        TopService myts = null;
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            for (int i = 1; i < this.services.size(); ++i) {
                TopService ts = this.services.get(i);
                if (!ts.isPotentialService(key)) continue;
                myts = ts;
                break;
            }
        }
        if (myts != null && myts.isActiveService(key)) {
            return myts.getService();
        }
        return null;
    }

    @Override
    public Locale getLocale(Object serviceModule) {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.serviceLocale;
    }

    @Override
    public Locale getLocaleFromString(String localeDescription) throws StandardException {
        return BaseMonitor.staticGetLocaleFromString(localeDescription);
    }

    @Override
    public String getServiceName(Object serviceModule) {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.getServiceType().getUserServiceName(ts.getKey().getIdentifier());
    }

    @Override
    public Locale setLocale(Object serviceModule, String userDefinedLocale) throws StandardException {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        PersistentService provider = ts.getServiceType();
        if (provider == null) {
            return null;
        }
        String serviceName = ts.getKey().getIdentifier();
        Properties properties = provider.getServiceProperties(serviceName, null);
        properties = new UpdateServiceProperties(provider, serviceName, properties, true);
        return this.setLocale(properties, userDefinedLocale);
    }

    @Override
    public Locale setLocale(Properties serviceProperties, String userDefinedLocale) throws StandardException {
        Locale locale = BaseMonitor.staticGetLocaleFromString(userDefinedLocale);
        serviceProperties.put("derby.serviceLocale", locale.toString());
        return locale;
    }

    @Override
    public PersistentService getServiceType(Object serviceModule) {
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.getServiceType();
    }

    @Override
    public Object startModule(boolean create, Object serviceModule, String factoryInterface, String identifier, Properties properties) throws StandardException {
        ProtocolKey key = ProtocolKey.create(factoryInterface, identifier);
        TopService ts = this.findTopService(serviceModule);
        Object instance = ts.bootModule(create, serviceModule, key, properties);
        if (instance == null) {
            throw Monitor.missingImplementation(factoryInterface);
        }
        return instance;
    }

    private synchronized TopService findTopService(Object serviceModule) {
        if (serviceModule == null) {
            return this.services.get(0);
        }
        for (int i = 1; i < this.services.size(); ++i) {
            TopService ts = this.services.get(i);
            if (!ts.inService(serviceModule)) continue;
            return ts;
        }
        return null;
    }

    @Override
    public Object findModule(Object serviceModule, String factoryInterface, String identifier) {
        ProtocolKey key;
        try {
            key = ProtocolKey.create(factoryInterface, identifier);
        }
        catch (StandardException se) {
            return null;
        }
        TopService ts = this.findTopService(serviceModule);
        if (ts == null) {
            return null;
        }
        return ts.findModule(key, true, null);
    }

    @Override
    public InstanceGetter classFromIdentifier(int fmtId) throws StandardException {
        String className;
        InstanceGetter[] iga;
        int off;
        try {
            InstanceGetter ig;
            off = fmtId - 0;
            iga = this.rc2;
            if (iga == null) {
                iga = this.rc2 = new InstanceGetter[RegisteredFormatIds.countTwoByteIDs()];
            }
            if ((ig = iga[off]) != null) {
                return ig;
            }
            className = RegisteredFormatIds.classNameForTwoByteID(off);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            className = null;
            iga = null;
            off = 0;
        }
        if (className != null) {
            Throwable t;
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (FormatableInstanceGetter.class.isAssignableFrom(clazz)) {
                    FormatableInstanceGetter tfig = (FormatableInstanceGetter)constructor.newInstance(new Object[0]);
                    tfig.setFormatId(fmtId);
                    iga[off] = tfig;
                    return iga[off];
                }
                iga[off] = new ClassInfo(clazz);
                return iga[off];
            }
            catch (ClassNotFoundException cnfe) {
                t = cnfe;
            }
            catch (IllegalAccessException iae) {
                t = iae;
            }
            catch (InstantiationException ie) {
                t = ie;
            }
            catch (NoSuchMethodException nsme) {
                t = nsme;
            }
            catch (InvocationTargetException ite) {
                t = ite;
            }
            catch (LinkageError le) {
                t = le;
            }
            throw StandardException.newException((String)"XBM0V.S", (Throwable)t, (Object[])new Object[]{FormatIdUtil.formatIdToString(fmtId), className});
        }
        throw StandardException.newException((String)"XBM0U.S", (Object[])new Object[]{FormatIdUtil.formatIdToString(fmtId)});
    }

    @Override
    public Object newInstanceFromIdentifier(int identifier) throws StandardException {
        Throwable t;
        InstanceGetter ci = this.classFromIdentifier(identifier);
        try {
            Object result = ci.getNewInstance();
            return result;
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        catch (NoSuchMethodException iae) {
            t = iae;
        }
        catch (InvocationTargetException ite) {
            t = ite;
        }
        catch (LinkageError le) {
            t = le;
        }
        throw StandardException.newException((String)"XBM0W.S", (Throwable)t, (Object[])new Object[]{identifier, "XX"});
    }

    protected Object loadInstance(Class<?> factoryInterface, Properties properties) {
        List<Class<?>> set;
        Object instance = null;
        Vector<Class<?>> localImplementations = this.getImplementations(properties, false);
        if (localImplementations != null) {
            instance = this.loadInstance(localImplementations, factoryInterface, properties);
        }
        Iterator<List<Class<?>>> iterator = this.implementationSets.iterator();
        while (iterator.hasNext() && (instance = this.loadInstance(set = iterator.next(), factoryInterface, properties)) == null) {
        }
        return instance;
    }

    private Object loadInstance(List<Class<?>> implementations, Class<?> factoryInterface, Properties properties) {
        int index = 0;
        while ((index = BaseMonitor.findImplementation(implementations, index, factoryInterface)) >= 0) {
            Object instance = this.newInstance(implementations.get(index));
            if (BaseMonitor.canSupport(instance, properties)) {
                return instance;
            }
            ++index;
        }
        return null;
    }

    private static int findImplementation(List<Class<?>> implementations, int startIndex, Class<?> factoryInterface) {
        for (int i = startIndex; i < implementations.size(); ++i) {
            Class<?> factoryClass = implementations.get(i);
            if (!factoryInterface.isAssignableFrom(factoryClass)) continue;
            return i;
        }
        return -1;
    }

    private Object newInstance(Class<?> classObject) {
        try {
            Constructor<?> constructor = classObject.getDeclaredConstructor(new Class[0]);
            Object module = constructor.newInstance(new Object[0]);
            try {
                Method getWarn = classObject.getMethod("getWarnings", new Class[0]);
                String warnings = (String)getWarn.invoke(module, new Object[0]);
                if (warnings != null) {
                    this.report(warnings);
                }
            }
            catch (NoSuchMethodException getWarn) {
            }
            catch (InvocationTargetException e) {
                SanityManager.NOTREACHED();
                this.report(e.toString());
            }
            return module;
        }
        catch (InstantiationException e) {
            this.report(classObject.getName() + " " + e.toString());
        }
        catch (IllegalAccessException e) {
            this.report(classObject.getName() + " " + e.toString());
        }
        catch (NoSuchMethodException e) {
            this.report(classObject.getName() + " " + e.toString());
        }
        catch (InvocationTargetException e) {
            this.report(classObject.getName() + " " + e.getCause().toString());
        }
        catch (LinkageError le) {
            this.report(classObject.getName() + " " + le.toString());
            this.reportException(le);
        }
        return null;
    }

    @Override
    public Properties getApplicationProperties() {
        return this.applicationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getServiceList(String protocol) {
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            TopService ts;
            int count = 0;
            for (int i = 1; i < this.services.size(); ++i) {
                ts = this.services.get(i);
                if (!ts.isActiveService() || !ts.getKey().getFactoryInterface().getName().equals(protocol)) continue;
                ++count;
            }
            String[] list = new String[count];
            if (count != 0) {
                int j = 0;
                for (int i = 1; i < this.services.size(); ++i) {
                    ts = this.services.get(i);
                    if (!ts.isActiveService() || !ts.getKey().getFactoryInterface().getName().equals(protocol)) continue;
                    list[j++] = ts.getServiceType().getUserServiceName(ts.getKey().getIdentifier());
                    if (j == count) break;
                }
            }
            return list;
        }
    }

    void dumpProperties(String title, Properties props) {
        this.report(title);
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.report(key + "=" + props.getProperty(key));
            }
        }
        this.report("-- end --");
    }

    protected void report(String message) {
        PrintWriter tpw = this.getTempWriter();
        if (tpw != null) {
            tpw.println(message);
        }
        if (this.systemStreams != null) {
            this.systemStreams.stream().printlnWithHeader(message);
        }
    }

    protected void reportException(Throwable t) {
        PrintWriterGetHeader pwgh = null;
        if (this.systemStreams != null) {
            pwgh = this.systemStreams.stream().getHeader();
        }
        ErrorStringBuilder esb = new ErrorStringBuilder(pwgh);
        esb.appendln(t.getMessage());
        esb.stackTrace(t);
        this.report(esb.get().toString());
    }

    private void addDebugFlags(String flags, boolean set) {
        if (flags == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(flags, ",");
        while (st.hasMoreTokens()) {
            String flag = st.nextToken();
            if (set) {
                SanityManager.DEBUG_SET((String)flag);
                continue;
            }
            SanityManager.DEBUG_CLEAR((String)flag);
        }
    }

    @Override
    public void startServices(Properties properties, boolean bootAll) {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(SERVICE)) continue;
            String name = key.substring(SERVICE.length());
            String protocolOrType = properties.getProperty(key);
            try {
                if (protocolOrType.equals("serviceDirectory")) {
                    if (!bootAll) continue;
                    this.findProviderAndStartService(name, properties, true);
                    continue;
                }
                this.bootService(null, protocolOrType, name, null, false);
            }
            catch (StandardException se) {
                if (protocolOrType.equals("serviceDirectory")) continue;
                this.reportException(se);
            }
        }
    }

    @Override
    public final boolean startPersistentService(String name, Properties properties) throws StandardException {
        return this.findProviderAndStartService(name, properties, false);
    }

    @Override
    public Object createPersistentService(String factoryInterface, String name, Properties properties) throws StandardException {
        PersistentService provider = this.findProviderForCreate(name);
        if (provider == null) {
            throw StandardException.newException((String)"XBM0K.D", (Object[])new Object[]{name});
        }
        return this.bootService(provider, factoryInterface, name, properties, true);
    }

    @Override
    public void removePersistentService(String name) throws StandardException {
        String serviceName;
        PersistentService provider = null;
        provider = this.findProviderForCreate(name);
        boolean removed = provider.removeServiceRoot(serviceName = provider.getCanonicalServiceName(name));
        if (!removed) {
            throw StandardException.newException((String)"XBM0I.D", (Object[])new Object[]{serviceName});
        }
    }

    @Override
    public Object startNonPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        return this.bootService(null, factoryInterface, serviceName, properties, false);
    }

    private Vector<Class<?>> getImplementations(Properties moduleList, boolean actualModuleList) {
        if (moduleList == null) {
            return null;
        }
        Vector implementations = actualModuleList ? new Vector(moduleList.size()) : new Vector(0, 1);
        int theJDKId = JVMInfo.JDK_ID;
        int[] envModuleCount = new int[theJDKId + 1];
        Enumeration<?> e = moduleList.propertyNames();
        block12: while (e.hasMoreElements()) {
            String tag;
            String key = (String)e.nextElement();
            if (key.startsWith("derby.module.")) {
                tag = key.substring("derby.module.".length());
            } else {
                if (!key.startsWith("derby.subSubProtocol.")) continue;
                tag = key.substring("derby.module.".length());
            }
            String envKey = "derby.env.jdk.".concat(tag);
            String envJDK = moduleList.getProperty(envKey);
            int envJDKId = 0;
            if (envJDK != null && (envJDKId = Integer.parseInt(envJDK.trim())) > theJDKId) continue;
            envKey = "derby.env.classes.".concat(tag);
            String envClasses = moduleList.getProperty(envKey);
            if (envClasses != null) {
                StringTokenizer st = new StringTokenizer(envClasses, ",");
                while (st.hasMoreTokens()) {
                    try {
                        Class.forName(st.nextToken().trim());
                    }
                    catch (ClassNotFoundException cnfe) {
                        continue block12;
                    }
                    catch (LinkageError le) {
                        continue block12;
                    }
                }
            }
            String className = moduleList.getProperty(key);
            if (this.reportOn) {
                this.report("Accessing module " + className + " to run initializers at boot time");
            }
            try {
                Class<?> possibleModule = Class.forName(className);
                if (this.getPersistentServiceImplementation(possibleModule)) continue;
                if (StorageFactory.class.isAssignableFrom(possibleModule)) {
                    storageFactories.put(tag, className);
                    continue;
                }
                if (envJDKId != 0) {
                    int offset = 0;
                    for (int eji = theJDKId; eji > envJDKId; --eji) {
                        offset += envModuleCount[eji];
                    }
                    implementations.add(offset, possibleModule);
                    int n = envJDKId;
                    envModuleCount[n] = envModuleCount[n] + 1;
                } else {
                    implementations.add(possibleModule);
                }
                Class[] csParams = new Class[]{new Properties().getClass()};
                try {
                    possibleModule.getMethod("canSupport", csParams);
                    if (!ModuleSupportable.class.isAssignableFrom(possibleModule)) {
                        SanityManager.THROWASSERT((String)("Module does not implement ModuleSupportable but has canSupport() - " + className));
                    }
                }
                catch (NoSuchMethodException eji) {
                    // empty catch block
                }
                boolean eitherMethod = false;
                Class[] bootParams = new Class[]{Boolean.TYPE, new Properties().getClass()};
                try {
                    possibleModule.getMethod("boot", bootParams);
                    eitherMethod = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                Class[] stopParams = new Class[]{};
                try {
                    possibleModule.getMethod("stop", stopParams);
                    eitherMethod = true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (!eitherMethod || ModuleControl.class.isAssignableFrom(possibleModule)) continue;
                SanityManager.THROWASSERT((String)("Module does not implement ModuleControl but has its methods - " + className));
            }
            catch (ClassNotFoundException cnfe) {
                this.report("Class " + className + " " + cnfe.toString() + ", module ignored.");
            }
            catch (LinkageError le) {
                this.report("Class " + className + " " + le.toString() + ", module ignored.");
            }
        }
        if (implementations.isEmpty()) {
            return null;
        }
        implementations.trimToSize();
        return implementations;
    }

    private boolean getPersistentServiceImplementation(Class<?> possibleModule) {
        if (!PersistentService.class.isAssignableFrom(possibleModule)) {
            return false;
        }
        PersistentService ps = (PersistentService)this.newInstance(possibleModule);
        if (ps == null) {
            this.report("Class " + possibleModule.getName() + " cannot create instance, module ignored.");
        } else {
            this.serviceProviders.put(ps.getType(), ps);
        }
        return true;
    }

    private Vector<Class<?>> getDefaultImplementations() {
        Properties moduleList = this.getDefaultModuleProperties();
        return this.getImplementations(moduleList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getDefaultModuleProperties() {
        Properties moduleList = new Properties();
        boolean firstList = true;
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Enumeration<URL> e;
            Enumeration<URL> enumeration = e = cl == null ? ClassLoader.getSystemResources("org/apache/derby/modules.properties") : cl.getResources("org/apache/derby/modules.properties");
            while (e.hasMoreElements()) {
                URL modulesPropertiesURL = e.nextElement();
                InputStream is = null;
                try {
                    is = modulesPropertiesURL.openStream();
                    if (firstList) {
                        moduleList.load(is);
                        firstList = false;
                        continue;
                    }
                    Properties otherList = new Properties();
                    otherList.load(is);
                    Enumeration<Object> newKeys = otherList.keys();
                    while (newKeys.hasMoreElements()) {
                        String key = (String)newKeys.nextElement();
                        if (moduleList.containsKey(key)) {
                            this.report("Ignored duplicate property " + key + " in " + modulesPropertiesURL.toString());
                            continue;
                        }
                        moduleList.setProperty(key, otherList.getProperty(key));
                    }
                }
                catch (IOException ioe) {
                    this.report("Can't load implementation list " + modulesPropertiesURL.toString() + ": " + ioe.toString());
                }
                finally {
                    try {
                        if (is == null) continue;
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ioe) {
            this.report("Can't load implementation list: " + ioe.toString());
        }
        if (firstList) {
            this.report("Default implementation list not found");
        }
        return moduleList;
    }

    protected static Properties removeRuntimeProperties(Properties properties) {
        Properties subset = new Properties();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("derby.__rt.")) continue;
            subset.put(key, properties.get(key));
        }
        return subset;
    }

    abstract InputStream applicationPropertiesStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readApplicationProperties() {
        Properties properties;
        InputStream is = null;
        try {
            is = this.applicationPropertiesStream();
            if (is == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties properties3 = new Properties();
            org.apache.derby.iapi.util.PropertyUtil.loadWithTrimmedValues(new BufferedInputStream(is), properties3);
            properties = properties3;
        }
        catch (SecurityException se) {
            Properties properties4 = null;
            return properties4;
        }
        catch (IOException ioe) {
            this.report(ioe.toString() + " (derby.properties)");
            this.reportException(ioe);
            Properties properties5 = null;
            return properties5;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private void determineSupportedServiceProviders() {
        Iterator<PersistentService> i = this.serviceProviders.values().iterator();
        while (i.hasNext()) {
            PersistentService provider = i.next();
            if (BaseMonitor.canSupport(provider, null)) continue;
            i.remove();
        }
    }

    private void bootPersistentServices() {
        ProviderEnumeration e = new ProviderEnumeration(this.applicationProperties);
        while (e.hasMoreElements()) {
            PersistentService provider = (PersistentService)e.nextElement();
            this.bootProviderServices(provider);
        }
    }

    protected void bootProviderServices(PersistentService provider) {
        if (this.reportOn) {
            this.report("Booting persistent services for provider: " + provider.getType());
        }
        Enumeration e = provider.getBootTimeServices();
        while (e != null && e.hasMoreElements()) {
            Properties serviceProperties;
            String serviceName = (String)e.nextElement();
            try {
                serviceProperties = provider.getServiceProperties(serviceName, null);
            }
            catch (StandardException mse) {
                this.report("Failed to load service properties, name: " + serviceName + ", type = " + provider.getType());
                this.reportException(mse);
                continue;
            }
            if (Boolean.valueOf(serviceProperties.getProperty("derby.database.noAutoBoot")).booleanValue()) continue;
            try {
                this.startProviderService(provider, serviceName, serviceProperties);
            }
            catch (StandardException mse) {
                this.report("Service failed to boot, name: " + serviceName + ", type = " + provider.getType());
                this.reportException(mse);
            }
        }
    }

    private boolean findProviderAndStartService(String name, Properties properties, boolean bootTime) throws StandardException {
        PersistentService actualProvider = null;
        Properties serviceProperties = null;
        String serviceName = null;
        int colon = name.indexOf(58);
        if (colon != -1 && (actualProvider = this.findProviderFromName(name, colon)) != null) {
            serviceName = actualProvider.getCanonicalServiceName(name);
            if (serviceName == null) {
                return true;
            }
            serviceProperties = actualProvider.getServiceProperties(serviceName, properties);
            if (serviceProperties == null) {
                return true;
            }
            if (bootTime && Boolean.valueOf(serviceProperties.getProperty("derby.database.noAutoBoot")).booleanValue()) {
                return true;
            }
            this.startProviderService(actualProvider, serviceName, serviceProperties);
            return true;
        }
        StandardException savedMse = null;
        ProviderEnumeration e = new ProviderEnumeration(properties);
        while (e.hasMoreElements()) {
            PersistentService provider = (PersistentService)e.nextElement();
            String sn = provider.getCanonicalServiceName(name);
            if (sn == null) continue;
            Properties p = null;
            try {
                p = provider.getServiceProperties(sn, properties);
                if (p == null) {
                    continue;
                }
            }
            catch (StandardException mse) {
                savedMse = mse;
            }
            if (actualProvider == null) {
                actualProvider = provider;
                serviceName = sn;
                serviceProperties = p;
                continue;
            }
            throw StandardException.newException((String)"XBM0T.D", (Object[])new Object[]{name});
        }
        if (actualProvider == null) {
            return colon == -1;
        }
        if (savedMse != null) {
            throw savedMse;
        }
        if (bootTime && Boolean.valueOf(serviceProperties.getProperty("derby.database.noAutoBoot")).booleanValue()) {
            return true;
        }
        this.startProviderService(actualProvider, serviceName, serviceProperties);
        return true;
    }

    protected PersistentService findProviderForCreate(String name) throws StandardException {
        return this.findProviderFromName(name, name.indexOf(58));
    }

    private PersistentService findProviderFromName(String name, int colon) throws StandardException {
        if (colon == 0) {
            return null;
        }
        String serviceType = colon < 2 ? "directory" : name.substring(0, colon);
        return this.getServiceProvider(serviceType);
    }

    @Override
    public PersistentService getServiceProvider(String subSubProtocol) throws StandardException {
        PersistentService ps;
        if (subSubProtocol == null) {
            return null;
        }
        if (this.serviceProviders != null && (ps = this.serviceProviders.get(subSubProtocol)) != null) {
            return ps;
        }
        return this.getPersistentService(subSubProtocol);
    }

    private PersistentService getPersistentService(String subSubProtocol) throws StandardException {
        String className = this.getStorageFactoryClassName(subSubProtocol);
        return this.getPersistentService(className, subSubProtocol);
    }

    private PersistentService getPersistentService(String className, String subSubProtocol) throws StandardException {
        if (className == null) {
            return null;
        }
        Class<?> storageFactoryClass = null;
        try {
            storageFactoryClass = Class.forName(className);
        }
        catch (Throwable e) {
            throw StandardException.newException((String)"XBM08.D", (Throwable)e, (Object[])new Object[]{subSubProtocol, className});
        }
        return new StorageFactoryService(subSubProtocol, storageFactoryClass);
    }

    private String getStorageFactoryClassName(String subSubProtocol) {
        String propertyName = "derby.subSubProtocol." + subSubProtocol;
        String className = PropertyUtil.getSystemProperty(propertyName);
        if (className != null) {
            return className;
        }
        return storageFactories.get(subSubProtocol);
    }

    protected void startProviderService(PersistentService provider, String serviceName, Properties serviceProperties) throws StandardException {
        String protocol = serviceProperties.getProperty("derby.serviceProtocol");
        if (protocol == null) {
            throw StandardException.newException((String)"XCY03.S", (Object[])new Object[]{"derby.serviceProtocol"});
        }
        this.bootService(provider, protocol, serviceName, serviceProperties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object bootService(PersistentService provider, String factoryInterface, String serviceName, Properties properties, boolean create) throws StandardException {
        Object instance;
        ContextManager previousCM;
        if (provider != null) {
            serviceName = provider.getCanonicalServiceName(serviceName);
        }
        ProtocolKey serviceKey = ProtocolKey.create(factoryInterface, serviceName);
        if (this.reportOn) {
            this.report("Booting service " + serviceKey + " create = " + create);
        }
        ContextManager cm = previousCM = this.contextService.getCurrentContextManager();
        TopService ts = null;
        Context sb = null;
        try {
            Properties serviceProperties;
            UpdateServiceProperties usProperties;
            boolean inRestore;
            String serverLocaleDescription;
            BaseMonitor baseMonitor = this;
            // MONITORENTER : baseMonitor
            if (this.inShutdown) {
                throw StandardException.newException((String)"XJ015.M", (Object[])new Object[0]);
            }
            for (int i = 1; i < this.services.size(); ++i) {
                TopService ts2 = this.services.get(i);
                if (!ts2.isPotentialService(serviceKey)) continue;
                Object var15_20 = null;
                // MONITOREXIT : baseMonitor
                return var15_20;
            }
            Locale serviceLocale = null;
            if (create) {
                properties = new Properties(properties);
                serviceLocale = BaseMonitor.setLocale(properties);
                properties.put("derby.serviceProtocol", factoryInterface);
                serviceName = provider.createServiceRoot(serviceName, Boolean.valueOf(properties.getProperty("derby.__deleteOnCreate")));
                serviceKey = ProtocolKey.create(factoryInterface, serviceName);
            } else if (properties != null && (serverLocaleDescription = properties.getProperty("derby.serviceLocale")) != null) {
                serviceLocale = BaseMonitor.staticGetLocaleFromString(serverLocaleDescription);
            }
            ts = new TopService(this, serviceKey, provider, serviceLocale);
            this.services.add(ts);
            // MONITOREXIT : baseMonitor
            if (provider != null) {
                SanityManager.ASSERT((boolean)provider.getCanonicalServiceName(serviceName).equals(serviceName), (String)("mismatched canonical names " + provider.getCanonicalServiceName(serviceName) + " != " + serviceName));
                SanityManager.ASSERT((boolean)serviceName.equals(serviceKey.getIdentifier()), (String)("mismatched names " + serviceName + " != " + serviceKey.getIdentifier()));
            }
            if (properties != null) {
                properties.put("derby.__rt.serviceDirectory", serviceName);
                properties.put("derby.__rt.serviceType", provider.getType());
            }
            if (this.reportOn) {
                this.dumpProperties("Service Properties: " + serviceKey.toString(), properties);
            }
            if (previousCM == null) {
                cm = this.contextService.newContextManager();
                this.contextService.setCurrentContextManager(cm);
            }
            sb = new ServiceBootContext(cm);
            boolean bl = properties != null ? properties.getProperty("derby.__rt.inRestore") != null : (inRestore = false);
            if (provider != null && properties != null) {
                usProperties = new UpdateServiceProperties(provider, serviceName, properties, !create && !inRestore);
                serviceProperties = usProperties;
            } else {
                usProperties = null;
                serviceProperties = properties;
            }
            instance = ts.bootModule(create, null, serviceKey, serviceProperties);
            if (create) {
                provider.createDataWarningFile(usProperties.getStorageFactory());
            }
            if (create || inRestore) {
                provider.saveServiceProperties(serviceName, usProperties.getStorageFactory(), BaseMonitor.removeRuntimeProperties(properties), false);
                usProperties.setServiceBooted();
            }
            if (cm != previousCM) {
                cm.cleanupOnError(StandardException.closeException(), false);
            }
        }
        catch (Throwable t) {
            Throwable nested;
            StandardException se = t instanceof StandardException && ((StandardException)t).getSeverity() == 45000 ? (StandardException)t : Monitor.exceptionStartingModule(t);
            if (cm != previousCM) {
                cm.cleanupOnError(se, false);
            }
            if (ts != null) {
                boolean deleteOnError;
                ts.shutdown();
                BaseMonitor inRestore = this;
                // MONITORENTER : inRestore
                this.services.remove(ts);
                // MONITOREXIT : inRestore
                boolean bl = properties != null ? properties.getProperty("derby.__rt.deleteRootOnError") != null : (deleteOnError = false);
                if (create || deleteOnError) {
                    provider.removeServiceRoot(serviceName);
                }
            }
            if (!((nested = se.getCause()) instanceof ThreadDeath)) throw se;
            throw (ThreadDeath)nested;
        }
        finally {
            if (previousCM == cm && sb != null) {
                sb.popMe();
            }
            if (previousCM == null) {
                this.contextService.resetCurrentContextManager(cm);
            }
        }
        ts.setTopModule(instance);
        Thread.yield();
        return instance;
    }

    @Override
    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    @Override
    public TimerFactory getTimerFactory() {
        return this.timerFactory;
    }

    private PrintWriter getTempWriter() {
        if (this.tmpWriter == null && !this.dumpedTempWriter) {
            this.tmpArray = new AccessibleByteArrayOutputStream();
            this.tmpWriter = new PrintWriter(this.tmpArray);
        }
        return this.tmpWriter;
    }

    private void dumpTempWriter(boolean bothPlaces) {
        if (this.tmpWriter == null) {
            return;
        }
        this.tmpWriter.flush();
        BufferedReader lnr = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.tmpArray.getInternalByteArray())));
        try {
            String s;
            while ((s = lnr.readLine()) != null) {
                if (this.systemStreams != null) {
                    this.systemStreams.stream().printlnWithHeader(s);
                }
                if (this.systemStreams != null && !bothPlaces) continue;
                this.logging.println(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.systemStreams == null || bothPlaces) {
            this.logging.flush();
        }
        this.tmpWriter = null;
        this.tmpArray = null;
        this.dumpedTempWriter = true;
        this.logging = null;
    }

    static boolean canSupport(Object instance, Properties properties) {
        return !(instance instanceof ModuleSupportable) || ((ModuleSupportable)instance).canSupport(properties);
    }

    static void boot(Object module, boolean create, Properties properties) throws StandardException {
        if (module instanceof ModuleControl) {
            ((ModuleControl)module).boot(create, properties);
        }
    }

    private static Locale staticGetLocaleFromString(String localeDescription) throws StandardException {
        String country;
        boolean isOk;
        int len = localeDescription.length();
        boolean bl = isOk = len == 2 || len == 5 || len > 6;
        if (isOk && len != 2) {
            boolean bl2 = isOk = localeDescription.charAt(2) == '_';
        }
        if (isOk && len > 5) {
            boolean bl3 = isOk = localeDescription.charAt(5) == '_';
        }
        if (!isOk) {
            throw StandardException.newException((String)"XBM0X.D", (Object[])new Object[]{localeDescription});
        }
        String language = localeDescription.substring(0, 2);
        String string = country = len == 2 ? "" : localeDescription.substring(3, 5);
        if (len < 6) {
            return new Locale(language, country);
        }
        String variant = len > 6 ? localeDescription.substring(6, len) : null;
        return new Locale(language, country, variant);
    }

    private static Locale setLocale(Properties properties) throws StandardException {
        String userDefinedLocale = properties.getProperty("territory");
        Locale locale = userDefinedLocale == null ? Locale.getDefault() : BaseMonitor.staticGetLocaleFromString(userDefinedLocale);
        properties.put("derby.serviceLocale", locale.toString());
        return locale;
    }

    public ResourceBundle getBundle(String messageId) {
        ContextManager cm;
        try {
            cm = BaseMonitor.getContextService().getCurrentContextManager();
        }
        catch (ShutdownException se) {
            cm = null;
        }
        if (cm != null) {
            return MessageService.getBundleForLocale((Locale)cm.getMessageLocale(), (String)messageId);
        }
        return null;
    }

    @Override
    public Thread getDaemonThread(Runnable task, String name, boolean setMinPriority) {
        Thread t = new Thread(this.daemonGroup, task, "derby.".concat(name));
        t.setDaemon(true);
        if (setMinPriority) {
            t.setPriority(1);
        }
        return t;
    }

    @Override
    public final boolean isDaemonThread(Thread thread) {
        return thread.getThreadGroup() == this.daemonGroup;
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static void stopContextService() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ContextService.stop();
                Monitor.clearMonitor();
                return null;
            }
        });
    }

    private static boolean setMonitor(final BaseMonitor baseMonitor) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return !Monitor.setMonitor(baseMonitor);
            }
        });
    }

    abstract boolean initialize(boolean var1);

    static {
        storageFactories.put("directory", "org.apache.derby.impl.io.DirStorageFactory");
        storageFactories.put("classpath", "org.apache.derby.impl.io.CPStorageFactory");
        storageFactories.put("jar", "org.apache.derby.impl.io.JarStorageFactory");
        storageFactories.put("http", "org.apache.derby.impl.io.URLStorageFactory");
        storageFactories.put("https", "org.apache.derby.impl.io.URLStorageFactory");
        storageFactories.put("memory", "org.apache.derby.impl.io.VFMemoryStorageFactory");
    }

    class ProviderEnumeration
    implements Enumeration<PersistentService> {
        private Enumeration<String> serviceProvidersKeys;
        private Properties startParams;
        private Enumeration paramEnumeration;
        private boolean enumeratedDirectoryProvider;
        private PersistentService storageFactoryPersistentService;

        ProviderEnumeration(Properties startParams) {
            this.serviceProvidersKeys = BaseMonitor.this.serviceProviders == null ? null : Collections.enumeration(BaseMonitor.this.serviceProviders.keySet());
            this.startParams = startParams;
            if (startParams != null) {
                this.paramEnumeration = startParams.keys();
            }
        }

        @Override
        public PersistentService nextElement() throws NoSuchElementException {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return (PersistentService)BaseMonitor.this.serviceProviders.get(this.serviceProvidersKeys.nextElement());
            }
            this.getNextStorageFactory();
            PersistentService ret = this.storageFactoryPersistentService;
            this.storageFactoryPersistentService = null;
            return ret;
        }

        private void getNextStorageFactory() {
            if (this.storageFactoryPersistentService != null) {
                return;
            }
            if (this.paramEnumeration != null) {
                while (this.paramEnumeration.hasMoreElements()) {
                    String prop = (String)this.paramEnumeration.nextElement();
                    if (!prop.startsWith("derby.subSubProtocol.")) continue;
                    try {
                        String storageFactoryClassName = (String)this.startParams.get(prop);
                        if (storageFactoryClassName == null) continue;
                        this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService((String)this.startParams.get(prop), prop.substring("derby.subSubProtocol.".length()));
                        if (this.storageFactoryPersistentService == null) continue;
                        return;
                    }
                    catch (StandardException standardException) {
                    }
                }
            }
            if (!this.enumeratedDirectoryProvider) {
                try {
                    this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService(BaseMonitor.this.getStorageFactoryClassName("directory"), "directory");
                }
                catch (StandardException se) {
                    this.storageFactoryPersistentService = null;
                }
                this.enumeratedDirectoryProvider = true;
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return true;
            }
            this.getNextStorageFactory();
            return this.storageFactoryPersistentService != null;
        }
    }
}

