/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

public class ValidateTransformAction
extends ActionType<Response> {
    public static final ValidateTransformAction INSTANCE = new ValidateTransformAction();
    public static final String NAME = "cluster:admin/transform/validate";

    private ValidateTransformAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, String> destIndexMappings;

        public Response(Map<String, String> destIndexMappings) {
            this.destIndexMappings = destIndexMappings;
        }

        public Response(StreamInput in) throws IOException {
            this.destIndexMappings = in.readMap(StreamInput::readString);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.destIndexMappings, StreamOutput::writeString);
        }

        public Map<String, String> getDestIndexMappings() {
            return this.destIndexMappings;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Response that = (Response)obj;
            return Objects.equals(this.destIndexMappings, that.destIndexMappings);
        }

        public int hashCode() {
            return Objects.hash(this.destIndexMappings);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TransformConfig config;
        private final boolean deferValidation;

        public Request(TransformConfig config, boolean deferValidation, TimeValue timeout) {
            super(timeout);
            this.config = config;
            this.deferValidation = deferValidation;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new TransformConfig(in);
            this.deferValidation = in.readBoolean();
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            validationException = this.config.validate(validationException);
            validationException = SourceDestValidator.validateRequest(validationException, this.config.getDestination() != null ? this.config.getDestination().getIndex() : null);
            return validationException;
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public boolean isDeferValidation() {
            return this.deferValidation;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
            out.writeBoolean(this.deferValidation);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Request that = (Request)obj;
            return Objects.equals(this.config, that.config) && this.deferValidation == that.deferValidation && this.timeout().equals(that.timeout());
        }

        public int hashCode() {
            return Objects.hash(this.timeout(), this.config, this.deferValidation);
        }
    }
}

