/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.security.authc.DomainConfig;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;

public class RealmSettings {
    private static final String DOMAIN_SETTING_PREFIX = "xpack.security.authc.domains.";
    public static final Setting.AffixSetting<List<String>> DOMAIN_TO_REALM_ASSOC_SETTING = Setting.affixKeySetting("xpack.security.authc.domains.", "realms", key -> Setting.stringListSetting(key, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> DOMAIN_UID_LITERAL_USERNAME_SETTING = Setting.affixKeySetting("xpack.security.authc.domains.", "uid_generation.literal_username", key -> Setting.boolSetting(key, false, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    private static final Pattern VALID_FIXED_SUFFIX = Pattern.compile("^[a-zA-Z][a-zA-Z0-9]{0,9}$");
    public static final Setting.AffixSetting<String> DOMAIN_UID_SUFFIX_SETTING = Setting.affixKeySetting("xpack.security.authc.domains.", "uid_generation.suffix", key -> Setting.simpleString(key, (String v) -> {
        if (!VALID_FIXED_SUFFIX.matcher((CharSequence)v).matches()) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Fixed-string suffix must begin with a letter and followed by either letters or digits andthe total length must be between 1 and 10 characters (inclusive).");
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final String RESERVED_REALM_AND_DOMAIN_NAME_PREFIX = "_";
    public static final String PREFIX = "xpack.security.authc.realms.";
    public static final Function<String, Setting.AffixSetting<Boolean>> ENABLED_SETTING = RealmSettings.affixSetting("enabled", key -> Setting.boolSetting(key, true, Setting.Property.NodeScope));
    public static final Function<String, Setting.AffixSetting<Integer>> ORDER_SETTING = RealmSettings.affixSetting("order", key -> Setting.intSetting(key, Integer.MAX_VALUE, Setting.Property.NodeScope));

    public static String realmSettingPrefix(String type) {
        return PREFIX + type + ".";
    }

    public static String realmSettingPrefix(RealmConfig.RealmIdentifier identifier) {
        return RealmSettings.realmSettingPrefix(identifier.getType()) + identifier.getName() + ".";
    }

    public static String realmSslPrefix(RealmConfig.RealmIdentifier identifier) {
        return RealmSettings.realmSettingPrefix(identifier) + "ssl.";
    }

    public static Setting.AffixSetting<String> simpleString(String realmType, String suffix, Setting.Property ... properties) {
        return Setting.affixKeySetting(RealmSettings.realmSettingPrefix(realmType), suffix, key -> Setting.simpleString(key, properties), new Setting.AffixSettingDependency[0]);
    }

    public static Setting.AffixSetting<SecureString> secureString(String realmType, String suffix) {
        return Setting.affixKeySetting(RealmSettings.realmSettingPrefix(realmType), suffix, key -> SecureSetting.secureString(key, null, new Setting.Property[0]), new Setting.AffixSettingDependency[0]);
    }

    public static <T> Function<String, Setting.AffixSetting<T>> affixSetting(String suffix, Function<String, Setting<T>> delegateFactory) {
        return realmType -> Setting.affixKeySetting(RealmSettings.realmSettingPrefix(realmType), suffix, delegateFactory, new Setting.AffixSettingDependency[0]);
    }

    public static Map<RealmConfig.RealmIdentifier, Settings> getRealmSettings(Settings globalSettings) {
        Settings settingsByType = globalSettings.getByPrefix(PREFIX);
        return settingsByType.names().stream().flatMap(type -> {
            Settings settingsByName = settingsByType.getAsSettings((String)type);
            return settingsByName.names().stream().map(name -> {
                RealmConfig.RealmIdentifier id = new RealmConfig.RealmIdentifier((String)type, (String)name);
                Settings realmSettings = settingsByName.getAsSettings((String)name);
                RealmSettings.verifyRealmSettings(id, realmSettings);
                return new Tuple<RealmConfig.RealmIdentifier, Settings>(id, realmSettings);
            });
        }).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
    }

    public static Map<String, DomainConfig> computeRealmNameToDomainConfigAssociation(Settings globalSettings) {
        boolean bl;
        Settings domainSettings = globalSettings.getByPrefix(DOMAIN_SETTING_PREFIX);
        HashMap<String, Set> realmToDomainsMap = new HashMap<String, Set>();
        for (String domainName : domainSettings.names()) {
            if (domainName.startsWith(RESERVED_REALM_AND_DOMAIN_NAME_PREFIX)) {
                throw new IllegalArgumentException("Security domain name must not start with \"_\"");
            }
            Setting<List<String>> domainRealmsSetting = DOMAIN_TO_REALM_ASSOC_SETTING.getConcreteSettingForNamespace(domainName);
            if (!domainRealmsSetting.exists(globalSettings)) {
                throw new IllegalArgumentException("[" + domainRealmsSetting.getKey() + "] must exist for security domain configuration");
            }
            Set<String> set = Set.copyOf((Collection)domainRealmsSetting.get(globalSettings));
            boolean literalUsername = DOMAIN_UID_LITERAL_USERNAME_SETTING.getConcreteSettingForNamespace(domainName).get(globalSettings);
            Setting<String> suffixSetting = DOMAIN_UID_SUFFIX_SETTING.getConcreteSettingForNamespace(domainName);
            Iterator<RealmConfig.RealmIdentifier> suffix = suffixSetting.exists(globalSettings) ? suffixSetting.get(globalSettings) : null;
            DomainConfig domainConfig = new DomainConfig(domainName, set, literalUsername, (String)((Object)suffix));
            for (String realmName : set) {
                realmToDomainsMap.computeIfAbsent(realmName, k -> new TreeSet()).add(domainConfig);
            }
        }
        StringBuilder realmToMultipleDomainsErrorMessageBuilder = new StringBuilder("Realms can be associated to at most one domain, but");
        boolean realmToMultipleDomains = false;
        for (Map.Entry entry : realmToDomainsMap.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            if (realmToMultipleDomains) {
                realmToMultipleDomainsErrorMessageBuilder.append(" and");
            }
            realmToMultipleDomainsErrorMessageBuilder.append(" realm [").append((String)entry.getKey()).append("] is associated to domains ").append(((Set)entry.getValue()).stream().map(DomainConfig::name).sorted().toList());
            realmToMultipleDomains = true;
        }
        if (realmToMultipleDomains) {
            throw new IllegalArgumentException(realmToMultipleDomainsErrorMessageBuilder.toString());
        }
        Set<RealmConfig.RealmIdentifier> allRealmIdentifiers = RealmSettings.getRealmSettings(globalSettings).keySet();
        boolean bl2 = false;
        boolean nativeRealmConfigured = false;
        HashSet unknownRealms = new HashSet(realmToDomainsMap.keySet());
        for (RealmConfig.RealmIdentifier identifier : allRealmIdentifiers) {
            unknownRealms.remove(identifier.getName());
            if (identifier.getType().equals("file")) {
                bl = true;
            }
            if (!identifier.getType().equals("native")) continue;
            nativeRealmConfigured = true;
        }
        if (!bl) {
            unknownRealms.remove("default_file");
        }
        if (!nativeRealmConfigured) {
            unknownRealms.remove("default_native");
        }
        if (!unknownRealms.isEmpty()) {
            StringBuilder undefinedRealmsErrorMessageBuilder = new StringBuilder("Undefined realms ").append(unknownRealms).append(" cannot be assigned to domains");
            throw new IllegalArgumentException(undefinedRealmsErrorMessageBuilder.toString());
        }
        return realmToDomainsMap.entrySet().stream().map(e -> Map.entry((String)e.getKey(), (DomainConfig)((Set)e.getValue()).stream().findAny().get())).collect(Collectors.toUnmodifiableMap(e -> (String)e.getKey(), e -> (DomainConfig)e.getValue()));
    }

    private static void verifyRealmSettings(RealmConfig.RealmIdentifier identifier, Settings realmSettings) {
        Settings nonSecureSettings = Settings.builder().put(realmSettings, false).build();
        if (nonSecureSettings.isEmpty()) {
            String prefix = RealmSettings.realmSettingPrefix(identifier);
            throw new SettingsException("found settings for the realm [{}] (with type [{}]) in the secure settings (elasticsearch.keystore), but this realm does not have any settings in elasticsearch.yml. Please remove these settings from the keystore, or update their names to match one of the realms that are defined in elasticsearch.yml - [{}]", identifier.getName(), identifier.getType(), realmSettings.keySet().stream().map(k -> prefix + k).collect(Collectors.joining(",")));
        }
    }

    public static String getFullSettingKey(String realmName, Setting.AffixSetting<?> setting) {
        return setting.getConcreteSettingForNamespace(realmName).getKey();
    }

    public static String getFullSettingKey(RealmConfig realm, Setting.AffixSetting<?> setting) {
        return setting.getConcreteSettingForNamespace(realm.name()).getKey();
    }

    public static <T> String getFullSettingKey(RealmConfig.RealmIdentifier realmId, Function<String, Setting.AffixSetting<T>> setting) {
        return RealmSettings.getFullSettingKey(realmId.getName(), setting.apply(realmId.getType()));
    }

    public static <T> String getFullSettingKey(RealmConfig realm, Function<String, Setting.AffixSetting<T>> setting) {
        return RealmSettings.getFullSettingKey(realm.identifier, setting);
    }

    public static List<Setting.AffixSetting<?>> getStandardSettings(String realmType) {
        return Arrays.asList(ENABLED_SETTING.apply(realmType), ORDER_SETTING.apply(realmType));
    }

    private RealmSettings() {
    }
}

