/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.settings;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class UpdateSecuritySettingsAction
extends ActionType<AcknowledgedResponse> {
    public static final UpdateSecuritySettingsAction INSTANCE = new UpdateSecuritySettingsAction();
    public static final String NAME = "cluster:admin/xpack/security/settings/update";
    public static final String MAIN_INDEX_NAME = "security";
    public static final String TOKENS_INDEX_NAME = "security-tokens";
    public static final String PROFILES_INDEX_NAME = "security-profile";
    public static final Set<String> ALLOWED_SETTING_KEYS = Set.of("index.number_of_replicas", "index.auto_expand_replicas");

    public UpdateSecuritySettingsAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final Map<String, Object> mainIndexSettings;
        private final Map<String, Object> tokensIndexSettings;
        private final Map<String, Object> profilesIndexSettings;
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("update_security_settings_request", false, a -> new Request((Map)a[0], (Map)a[1], (Map)a[2]));

        public Request(Map<String, Object> mainIndexSettings, Map<String, Object> tokensIndexSettings, Map<String, Object> profilesIndexSettings) {
            this.mainIndexSettings = Objects.requireNonNullElse(mainIndexSettings, Collections.emptyMap());
            this.tokensIndexSettings = Objects.requireNonNullElse(tokensIndexSettings, Collections.emptyMap());
            this.profilesIndexSettings = Objects.requireNonNullElse(profilesIndexSettings, Collections.emptyMap());
        }

        public Request(StreamInput in) throws IOException {
            this.mainIndexSettings = in.readGenericMap();
            this.tokensIndexSettings = in.readGenericMap();
            this.profilesIndexSettings = in.readGenericMap();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericMap(this.mainIndexSettings);
            out.writeGenericMap(this.tokensIndexSettings);
            out.writeGenericMap(this.profilesIndexSettings);
        }

        public static Request parse(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Map<String, Object> mainIndexSettings() {
            return this.mainIndexSettings;
        }

        public Map<String, Object> tokensIndexSettings() {
            return this.tokensIndexSettings;
        }

        public Map<String, Object> profilesIndexSettings() {
            return this.profilesIndexSettings;
        }

        @Override
        public ActionRequestValidationException validate() {
            if (this.mainIndexSettings.isEmpty() && this.tokensIndexSettings.isEmpty() && this.profilesIndexSettings.isEmpty()) {
                return ValidateActions.addValidationError("No settings given to update", null);
            }
            ActionRequestValidationException validationException = Request.validateIndexSettings(this.mainIndexSettings, UpdateSecuritySettingsAction.MAIN_INDEX_NAME, null);
            validationException = Request.validateIndexSettings(this.tokensIndexSettings, UpdateSecuritySettingsAction.TOKENS_INDEX_NAME, validationException);
            validationException = Request.validateIndexSettings(this.profilesIndexSettings, UpdateSecuritySettingsAction.PROFILES_INDEX_NAME, validationException);
            return validationException;
        }

        private static ActionRequestValidationException validateIndexSettings(Map<String, Object> indexSettings, String indexName, ActionRequestValidationException existingExceptions) {
            Set<String> forbiddenSettings = Sets.difference(indexSettings.keySet(), ALLOWED_SETTING_KEYS);
            if (forbiddenSettings.size() > 0) {
                return ValidateActions.addValidationError("illegal settings for index [" + indexName + "]: " + forbiddenSettings + ", these settings may not be configured. Only the following settings may be configured for that index: " + ALLOWED_SETTING_KEYS, existingExceptions);
            }
            return existingExceptions;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.MAIN_INDEX_NAME, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.TOKENS_INDEX_NAME, new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField(UpdateSecuritySettingsAction.PROFILES_INDEX_NAME, new String[0]));
        }
    }
}

