/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class CreateApiKeyResponse
extends ActionResponse
implements ToXContentObject {
    static final ConstructingObjectParser<CreateApiKeyResponse, Void> PARSER = new ConstructingObjectParser("create_api_key_response", args -> new CreateApiKeyResponse((String)args[0], (String)args[1], new SecureString((String)args[2]), args[3] == null ? null : Instant.ofEpochMilli((Long)args[3])));
    private final String name;
    private final String id;
    private final SecureString key;
    private final Instant expiration;

    public CreateApiKeyResponse(String name, String id, SecureString key, Instant expiration) {
        this.name = name;
        this.id = id;
        this.key = key;
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
    }

    public CreateApiKeyResponse(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.id = in.readString();
        this.key = in.readSecureString();
        this.expiration = in.readOptionalInstant();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public SecureString getKey() {
        return this.key;
    }

    @Nullable
    public Instant getExpiration() {
        return this.expiration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expiration == null ? 0 : this.expiration.hashCode());
        result = 31 * result + Objects.hash(this.id, this.name, this.key);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateApiKeyResponse other = (CreateApiKeyResponse)obj;
        if (this.expiration == null && other.expiration != null) {
            return false;
        }
        return Objects.equals(this.expiration, other.expiration) && Objects.equals(this.id, other.id) && Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.id);
        byte[] bytes = null;
        try {
            bytes = CharArrays.toUtf8Bytes(this.key.getChars());
            out.writeByteArray(bytes);
        }
        finally {
            if (bytes != null) {
                Arrays.fill(bytes, (byte)0);
            }
        }
        out.writeOptionalInstant(this.expiration);
    }

    public static CreateApiKeyResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("id", this.id).field("name", this.name);
        if (this.expiration != null) {
            builder.field("expiration", this.expiration.toEpochMilli());
        }
        byte[] charBytes = CharArrays.toUtf8Bytes(this.key.getChars());
        try {
            builder.field("api_key").utf8Value(charBytes, 0, charBytes.length);
        }
        finally {
            Arrays.fill(charBytes, (byte)0);
        }
        builder.field("encoded", Base64.getEncoder().encodeToString((this.id + ":" + this.key).getBytes(StandardCharsets.UTF_8)));
        return builder.endObject();
    }

    public String toString() {
        return "CreateApiKeyResponse [name=" + this.name + ", id=" + this.id + ", expiration=" + this.expiration + "]";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("api_key", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("encoded", new String[0]));
    }
}

