/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public interface InferenceConfig
extends NamedXContentObject,
VersionedNamedWriteable {
    public static final String DEFAULT_TOP_CLASSES_RESULTS_FIELD = "top_classes";
    public static final String DEFAULT_RESULTS_FIELD = "predicted_value";
    public static final ParseField RESULTS_FIELD = new ParseField("results_field", new String[0]);

    public boolean isTargetTypeSupported(TargetType var1);

    public InferenceConfig apply(InferenceConfigUpdate var1);

    @Override
    default public TransportVersion getMinimalSupportedVersion() {
        return this.getMinimalSupportedTransportVersion();
    }

    public MlConfigVersion getMinimalSupportedMlConfigVersion();

    public TransportVersion getMinimalSupportedTransportVersion();

    default public boolean requestingImportance() {
        return false;
    }

    public String getResultsField();

    public boolean isAllocateOnly();

    default public boolean supportsIngestPipeline() {
        return true;
    }

    default public boolean supportsPipelineAggregation() {
        return true;
    }

    default public boolean supportsSearchRescorer() {
        return false;
    }

    default public ElasticsearchStatusException incompatibleUpdateException(String updateName) {
        throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a inference request of type [{}]", this.getName(), updateName);
    }
}

