/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsSource;
import org.elasticsearch.xpack.core.ml.dataframe.explain.FieldSelection;
import org.elasticsearch.xpack.core.ml.dataframe.explain.MemoryEstimation;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class ExplainDataFrameAnalyticsAction
extends ActionType<Response> {
    public static final ExplainDataFrameAnalyticsAction INSTANCE = new ExplainDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/explain";

    private ExplainDataFrameAnalyticsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField TYPE = new ParseField("explain_data_frame_analytics_response", new String[0]);
        public static final ParseField FIELD_SELECTION = new ParseField("field_selection", new String[0]);
        public static final ParseField MEMORY_ESTIMATION = new ParseField("memory_estimation", new String[0]);
        static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), args -> new Response((List)args[0], (MemoryEstimation)args[1]));
        private final List<FieldSelection> fieldSelection;
        private final MemoryEstimation memoryEstimation;

        public Response(List<FieldSelection> fieldSelection, MemoryEstimation memoryEstimation) {
            this.fieldSelection = Objects.requireNonNull(fieldSelection);
            this.memoryEstimation = Objects.requireNonNull(memoryEstimation);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.fieldSelection = in.readCollectionAsList(FieldSelection::new);
            this.memoryEstimation = new MemoryEstimation(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.fieldSelection);
            this.memoryEstimation.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(FIELD_SELECTION.getPreferredName(), (Iterable<?>)this.fieldSelection);
            builder.field(MEMORY_ESTIMATION.getPreferredName(), this.memoryEstimation);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Response that = (Response)other;
            return Objects.equals(this.fieldSelection, that.fieldSelection) && Objects.equals(this.memoryEstimation, that.memoryEstimation);
        }

        public int hashCode() {
            return Objects.hash(this.fieldSelection, this.memoryEstimation);
        }

        public MemoryEstimation getMemoryEstimation() {
            return this.memoryEstimation;
        }

        public List<FieldSelection> getFieldSelection() {
            return this.fieldSelection;
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), FieldSelection.PARSER, FIELD_SELECTION);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), MemoryEstimation.PARSER, MEMORY_ESTIMATION);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private final DataFrameAnalyticsConfig config;

        public static Request parseRequest(XContentParser parser) {
            DataFrameAnalyticsConfig.Builder configBuilder = DataFrameAnalyticsConfig.STRICT_PARSER.apply(parser, null);
            DataFrameAnalyticsConfig config = configBuilder.buildForExplain();
            return new Request(config);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new DataFrameAnalyticsConfig(in);
        }

        public Request(DataFrameAnalyticsConfig config) {
            this.config = config;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public DataFrameAnalyticsConfig getConfig() {
            return this.config;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException error = null;
            error = Request.checkConfigIdIsValid(this.config, error);
            error = SourceDestValidator.validateRequest(error, this.config.getDest().getIndex());
            error = Request.checkNoIncludedAnalyzedFieldsAreExcludedBySourceFiltering(this.config, error);
            return error;
        }

        private static ActionRequestValidationException checkConfigIdIsValid(DataFrameAnalyticsConfig analyticsConfig, ActionRequestValidationException error) {
            if (!MlStrings.isValidId(analyticsConfig.getId())) {
                error = ValidateActions.addValidationError(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", DataFrameAnalyticsConfig.ID, analyticsConfig.getId()), error);
            }
            if (!MlStrings.hasValidLengthForId(analyticsConfig.getId())) {
                error = ValidateActions.addValidationError(Messages.getMessage("Invalid {0}; ''{1}'' cannot contain more than {2} characters.", DataFrameAnalyticsConfig.ID, analyticsConfig.getId(), 64), error);
            }
            return error;
        }

        private static ActionRequestValidationException checkNoIncludedAnalyzedFieldsAreExcludedBySourceFiltering(DataFrameAnalyticsConfig analyticsConfig, ActionRequestValidationException error) {
            if (analyticsConfig.getAnalyzedFields() == null) {
                return error;
            }
            for (String analyzedInclude : analyticsConfig.getAnalyzedFields().includes()) {
                if (!analyticsConfig.getSource().isFieldExcluded(analyzedInclude)) continue;
                return ValidateActions.addValidationError("field [" + analyzedInclude + "] is included in [" + DataFrameAnalyticsConfig.ANALYZED_FIELDS.getPreferredName() + "] but not in [" + DataFrameAnalyticsConfig.SOURCE.getPreferredName() + "." + DataFrameAnalyticsSource._SOURCE.getPreferredName() + "]", error);
            }
            return error;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.config.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.config, request.config);
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format("explain_data_frame_analytics[%s]", this.config.getId()), parentTaskId, headers);
        }
    }
}

