/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DeleteTrainedModelAssignmentAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteTrainedModelAssignmentAction INSTANCE = new DeleteTrainedModelAssignmentAction();
    public static final String NAME = "cluster:internal/xpack/ml/model_allocation/delete";

    private DeleteTrainedModelAssignmentAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final String modelId;

        public Request(String modelId) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, "model_id");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
        }

        public String getModelId() {
            return this.modelId;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.modelId, request.modelId);
        }

        public int hashCode() {
            return Objects.hash(this.modelId);
        }
    }
}

