/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class PutInferenceModelAction
extends ActionType<Response> {
    public static final PutInferenceModelAction INSTANCE = new PutInferenceModelAction();
    public static final String NAME = "cluster:admin/xpack/inference/put";

    public PutInferenceModelAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final ModelConfigurations model;

        public Response(ModelConfigurations model) {
            this.model = model;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.model = new ModelConfigurations(in);
        }

        public ModelConfigurations getModel() {
            return this.model;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.model.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.model.toFilteredXContent(builder, params);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.model, response.model);
        }

        public int hashCode() {
            return Objects.hash(this.model);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TaskType taskType;
        private final String inferenceEntityId;
        private final BytesReference content;
        private final XContentType contentType;

        public Request(TaskType taskType, String inferenceEntityId, BytesReference content, XContentType contentType) {
            this.taskType = taskType;
            this.inferenceEntityId = inferenceEntityId;
            this.content = content;
            this.contentType = contentType;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEntityId = in.readString();
            this.taskType = TaskType.fromStream(in);
            this.content = in.readBytesReference();
            this.contentType = in.readEnum(XContentType.class);
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        public BytesReference getContent() {
            return this.content;
        }

        public XContentType getContentType() {
            return this.contentType;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEntityId);
            this.taskType.writeTo(out);
            out.writeBytesReference(this.content);
            XContentHelper.writeTo(out, this.contentType);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (!MlStrings.isValidId(this.inferenceEntityId)) {
                validationException.addValidationError(Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", "inference_id", this.inferenceEntityId));
            }
            if (!validationException.validationErrors().isEmpty()) {
                return validationException;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.taskType == request.taskType && Objects.equals(this.inferenceEntityId, request.inferenceEntityId) && Objects.equals(this.content, request.content) && this.contentType == request.contentType;
        }

        public int hashCode() {
            return Objects.hash(this.taskType, this.inferenceEntityId, this.content, this.contentType);
        }
    }
}

