/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;

public class PutLifecycleRequest
extends AcknowledgedRequest<PutLifecycleRequest>
implements ToXContentObject {
    public static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
    private static final ConstructingObjectParser<PutLifecycleRequest, String> PARSER = new ConstructingObjectParser("put_lifecycle_request", a -> new PutLifecycleRequest((LifecyclePolicy)a[0]));
    private LifecyclePolicy policy;

    public PutLifecycleRequest(LifecyclePolicy policy) {
        this.policy = policy;
    }

    public PutLifecycleRequest(StreamInput in) throws IOException {
        super(in);
        this.policy = new LifecyclePolicy(in);
    }

    public PutLifecycleRequest() {
    }

    public LifecyclePolicy getPolicy() {
        return this.policy;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException err = null;
        try {
            this.policy.validate();
        }
        catch (IllegalArgumentException iae) {
            err = ValidateActions.addValidationError(iae.getMessage(), null);
        }
        String phaseTimingErr = TimeseriesLifecycleType.validateMonotonicallyIncreasingPhaseTimings(this.policy.getPhases().values());
        if (Strings.hasText(phaseTimingErr)) {
            err = new ActionRequestValidationException();
            err.addValidationError(phaseTimingErr);
        }
        return err;
    }

    public static PutLifecycleRequest parseRequest(String name, XContentParser parser) {
        return PARSER.apply(parser, name);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY_FIELD.getPreferredName(), this.policy);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.policy.writeTo(out);
    }

    public int hashCode() {
        return Objects.hash(this.policy);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PutLifecycleRequest other = (PutLifecycleRequest)obj;
        return Objects.equals(this.policy, other.policy);
    }

    @Override
    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), LifecyclePolicy::parse, POLICY_FIELD);
    }
}

