/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.EmptyInfo;

public class WaitForRolloverReadyStep
extends AsyncWaitStep {
    private static final Logger logger = LogManager.getLogger(WaitForRolloverReadyStep.class);
    public static final String NAME = "check-rollover-ready";
    public static final long MAX_PRIMARY_SHARD_DOCS = 200000000L;
    private final RolloverConditions conditions;

    public WaitForRolloverReadyStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, ByteSizeValue maxSize, ByteSizeValue maxPrimaryShardSize, TimeValue maxAge, Long maxDocs, Long maxPrimaryShardDocs, ByteSizeValue minSize, ByteSizeValue minPrimaryShardSize, TimeValue minAge, Long minDocs, Long minPrimaryShardDocs) {
        super(key, nextStepKey, client);
        this.conditions = RolloverConditions.newBuilder().addMaxIndexSizeCondition(maxSize).addMaxPrimaryShardSizeCondition(maxPrimaryShardSize).addMaxIndexAgeCondition(maxAge).addMaxIndexDocsCondition(maxDocs).addMaxPrimaryShardDocsCondition(maxPrimaryShardDocs).addMinIndexSizeCondition(minSize).addMinPrimaryShardSizeCondition(minPrimaryShardSize).addMinIndexAgeCondition(minAge).addMinIndexDocsCondition(minDocs).addMinPrimaryShardDocsCondition(minPrimaryShardDocs).build();
    }

    public WaitForRolloverReadyStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, RolloverConditions conditions) {
        super(key, nextStepKey, client);
        this.conditions = conditions;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void evaluateCondition(Metadata metadata, Index index, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        String rolloverTarget;
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(index.getName());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null) {
            assert (dataStream.getWriteIndex() != null) : "datastream " + dataStream.getName() + " has no write index";
            if (!dataStream.getWriteIndex().equals(index)) {
                logger.warn("index [{}] is not the write index for data stream [{}]. skipping rollover for policy [{}]", (Object)index.getName(), (Object)dataStream.getName(), (Object)metadata.index(index).getLifecyclePolicyName());
                listener.onResponse(true, EmptyInfo.INSTANCE);
                return;
            }
            rolloverTarget = dataStream.getName();
        } else {
            boolean indexingComplete;
            IndexMetadata indexMetadata = metadata.index(index);
            String rolloverAlias = RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetadata.getSettings());
            if (Strings.isNullOrEmpty(rolloverAlias)) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "setting [%s] for index [%s] is empty or not defined", "index.lifecycle.rollover_alias", index.getName())));
                return;
            }
            if (indexMetadata.getRolloverInfos().get(rolloverAlias) != null) {
                logger.info("index [{}] was already rolled over for alias [{}], not attempting to roll over again", (Object)index.getName(), (Object)rolloverAlias);
                listener.onResponse(true, EmptyInfo.INSTANCE);
                return;
            }
            boolean aliasPointsToThisIndex = indexMetadata.getAliases().containsKey(rolloverAlias);
            Boolean isWriteIndex = null;
            if (aliasPointsToThisIndex) {
                isWriteIndex = indexMetadata.getAliases().get(rolloverAlias).writeIndex();
            }
            if (indexingComplete = LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                logger.trace(index + " has lifecycle complete set, skipping check-rollover-ready");
                if (aliasPointsToThisIndex && Boolean.TRUE.equals(isWriteIndex)) {
                    listener.onFailure(new IllegalStateException(String.format(Locale.ROOT, "index [%s] has [%s] set to [true], but is still the write index for alias [%s]", index.getName(), "index.lifecycle.indexing_complete", rolloverAlias)));
                    return;
                }
                listener.onResponse(true, EmptyInfo.INSTANCE);
                return;
            }
            if (!aliasPointsToThisIndex) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "%s [%s] does not point to index [%s]", "index.lifecycle.rollover_alias", rolloverAlias, index.getName())));
                return;
            }
            if (Boolean.FALSE.equals(isWriteIndex)) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not the write index for alias [%s]", index.getName(), rolloverAlias)));
                return;
            }
            rolloverTarget = rolloverAlias;
        }
        boolean rolloverOnlyIfHasDocuments = LifecycleSettings.LIFECYCLE_ROLLOVER_ONLY_IF_HAS_DOCUMENTS_SETTING.get(metadata.settings());
        RolloverRequest rolloverRequest = this.createRolloverRequest(rolloverTarget, masterTimeout, rolloverOnlyIfHasDocuments);
        this.getClient().admin().indices().rolloverIndex(rolloverRequest, ActionListener.wrap(response -> {
            Map<String, Boolean> conditionStatus = response.getConditionStatus();
            boolean conditionsMet = rolloverRequest.getConditions().areConditionsMet(conditionStatus);
            if (conditionsMet) {
                logger.info("index [{}] is ready for rollover, conditions: [{}]", (Object)index.getName(), conditionStatus);
            } else {
                logger.debug("index [{}] is not ready for rollover, conditions: [{}]", (Object)index.getName(), conditionStatus);
            }
            listener.onResponse(conditionsMet, EmptyInfo.INSTANCE);
        }, listener::onFailure));
    }

    RolloverRequest createRolloverRequest(String rolloverTarget, TimeValue masterTimeout, boolean rolloverOnlyIfHasDocuments) {
        RolloverRequest rolloverRequest = (RolloverRequest)new RolloverRequest(rolloverTarget, null).masterNodeTimeout(masterTimeout);
        rolloverRequest.dryRun(true);
        rolloverRequest.setConditions(WaitForRolloverReadyStep.applyDefaultConditions(this.conditions, rolloverOnlyIfHasDocuments));
        return rolloverRequest;
    }

    public static RolloverConditions applyDefaultConditions(RolloverConditions conditions, boolean rolloverOnlyIfHasDocuments) {
        RolloverConditions.Builder builder = RolloverConditions.newBuilder(conditions);
        if (rolloverOnlyIfHasDocuments && conditions.getMinDocs() == null && conditions.getMinPrimaryShardDocs() == null) {
            builder.addMinIndexDocsCondition(1L);
        }
        long currentMaxPrimaryShardDocs = conditions.getMaxPrimaryShardDocs() != null ? conditions.getMaxPrimaryShardDocs() : Long.MAX_VALUE;
        builder.addMaxPrimaryShardDocsCondition(Math.min(currentMaxPrimaryShardDocs, 200000000L));
        return builder.build();
    }

    public RolloverConditions getConditions() {
        return this.conditions;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.conditions);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaitForRolloverReadyStep other = (WaitForRolloverReadyStep)obj;
        return super.equals(obj) && Objects.equals(this.conditions, other.conditions);
    }
}

