/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.ShrinkIndexNameSupplier;
import org.elasticsearch.xpack.core.ilm.Step;

public class ShrinkStep
extends AsyncActionStep {
    public static final String NAME = "shrink";
    private static final Logger logger = LogManager.getLogger(ShrinkStep.class);
    private Integer numberOfShards;
    private ByteSizeValue maxPrimaryShardSize;

    public ShrinkStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, Integer numberOfShards, ByteSizeValue maxPrimaryShardSize) {
        super(key, nextStepKey, client);
        this.numberOfShards = numberOfShards;
        this.maxPrimaryShardSize = maxPrimaryShardSize;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    public ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (lifecycleState.lifecycleDate() == null) {
            throw new IllegalStateException("source index [" + indexMetadata.getIndex().getName() + "] is missing lifecycle date");
        }
        String shrunkenIndexName = ShrinkIndexNameSupplier.getShrinkIndexName(indexMetadata.getIndex().getName(), lifecycleState);
        if (currentState.metadata().index(shrunkenIndexName) != null) {
            logger.warn("skipping [{}] step for index [{}] as part of policy [{}] as the shrunk index [{}] already exists", (Object)NAME, (Object)indexMetadata.getIndex().getName(), (Object)indexMetadata.getLifecyclePolicyName(), (Object)shrunkenIndexName);
            listener.onResponse(null);
            return;
        }
        String policyName = indexMetadata.getLifecyclePolicyName();
        Settings.Builder builder = Settings.builder();
        builder.put("index.number_of_replicas", indexMetadata.getNumberOfReplicas()).put("index.lifecycle.name", policyName).put(IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "_id", (String)null);
        if (this.numberOfShards != null) {
            builder.put("index.number_of_shards", this.numberOfShards);
        }
        Settings relevantTargetSettings = builder.build();
        ResizeRequest resizeRequest = (ResizeRequest)new ResizeRequest(shrunkenIndexName, indexMetadata.getIndex().getName()).masterNodeTimeout(TimeValue.MAX_VALUE);
        resizeRequest.setMaxPrimaryShardSize(this.maxPrimaryShardSize);
        resizeRequest.getTargetIndexRequest().settings(relevantTargetSettings);
        this.getClient().admin().indices().resizeIndex(resizeRequest, listener.delegateFailureAndWrap((l, response) -> l.onResponse(null)));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numberOfShards, this.maxPrimaryShardSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShrinkStep other = (ShrinkStep)obj;
        return super.equals(obj) && Objects.equals(this.numberOfShards, other.numberOfShards) && Objects.equals(this.maxPrimaryShardSize, other.maxPrimaryShardSize);
    }
}

