/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datatiers;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.datatiers.DataTiersFeatureSetUsage;
import org.elasticsearch.xpack.core.datatiers.NodeDataTiersUsage;
import org.elasticsearch.xpack.core.datatiers.NodesDataTiersUsageTransportAction;

public class DataTiersUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;
    private final FeatureService featureService;

    @Inject
    public DataTiersUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, FeatureService featureService) {
        super(XPackUsageFeatureAction.DATA_TIERS.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.client = client;
        this.featureService = featureService;
    }

    @Override
    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        if (this.featureService.clusterHasFeature(state, NodesDataTiersUsageTransportAction.LOCALLY_PRECALCULATED_STATS_FEATURE)) {
            new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task).admin().cluster().execute(NodesDataTiersUsageTransportAction.TYPE, new NodesDataTiersUsageTransportAction.NodesRequest(), listener.delegateFailureAndWrap((delegate, response) -> delegate.onResponse(new XPackUsageFeatureResponse(new DataTiersFeatureSetUsage(DataTiersUsageTransportAction.aggregateStats(response.getNodes(), DataTiersUsageTransportAction.getIndicesGroupedByTier(state, response.getNodes())))))));
        } else {
            new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task).admin().cluster().prepareNodesStats(new String[0]).setIndices(new CommonStatsFlags(CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.Store)).execute(listener.delegateFailureAndWrap((delegate, nodesStatsResponse) -> {
                List<NodeDataTiersUsage> response = nodesStatsResponse.getNodes().stream().map(nodeStats -> new NodeDataTiersUsage(nodeStats.getNode(), DataTiersUsageTransportAction.precalculateLocalStatsFromNodeStats(nodeStats, state))).toList();
                delegate.onResponse(new XPackUsageFeatureResponse(new DataTiersFeatureSetUsage(DataTiersUsageTransportAction.aggregateStats(response, DataTiersUsageTransportAction.getIndicesGroupedByTier(state, response)))));
            }));
        }
    }

    static Map<String, Set<String>> getIndicesGroupedByTier(ClusterState state, List<NodeDataTiersUsage> nodes) {
        Set indices = nodes.stream().map(nodeResponse -> state.getRoutingNodes().node(nodeResponse.getNode().getId())).filter(Objects::nonNull).flatMap(node -> StreamSupport.stream(node.spliterator(), false)).map(ShardRouting::getIndexName).collect(Collectors.toSet());
        HashMap<String, Set<String>> indicesByTierPreference = new HashMap<String, Set<String>>();
        for (String indexName : indices) {
            List<String> tierPreference;
            IndexMetadata indexMetadata = state.metadata().index(indexName);
            if (indexMetadata == null || (tierPreference = indexMetadata.getTierPreference()).isEmpty()) continue;
            indicesByTierPreference.computeIfAbsent(tierPreference.get(0), ignored -> new HashSet()).add(indexName);
        }
        return indicesByTierPreference;
    }

    static Map<String, DataTiersFeatureSetUsage.TierSpecificStats> aggregateStats(List<NodeDataTiersUsage> nodeDataTiersUsages, Map<String, Set<String>> tierPreference) {
        HashMap<String, TierStatsAccumulator> statsAccumulators = new HashMap<String, TierStatsAccumulator>();
        for (String tier : tierPreference.keySet()) {
            statsAccumulators.put(tier, new TierStatsAccumulator());
            ((TierStatsAccumulator)statsAccumulators.get((Object)tier)).indexNames.addAll((Collection<String>)tierPreference.get(tier));
        }
        for (NodeDataTiersUsage nodeDataTiersUsage : nodeDataTiersUsages) {
            DataTiersUsageTransportAction.aggregateDataTierNodeCounts(nodeDataTiersUsage, statsAccumulators);
            DataTiersUsageTransportAction.aggregateDataTierIndexStats(nodeDataTiersUsage, statsAccumulators);
        }
        HashMap<String, DataTiersFeatureSetUsage.TierSpecificStats> results = new HashMap<String, DataTiersFeatureSetUsage.TierSpecificStats>();
        for (Map.Entry entry : statsAccumulators.entrySet()) {
            results.put((String)entry.getKey(), DataTiersUsageTransportAction.aggregateFinalTierStats((TierStatsAccumulator)entry.getValue()));
        }
        return results;
    }

    private static void aggregateDataTierNodeCounts(NodeDataTiersUsage nodeStats, Map<String, TierStatsAccumulator> tiersStats) {
        nodeStats.getNode().getRoles().stream().map(DiscoveryNodeRole::roleName).filter(DataTier::validTierName).forEach(tier -> ++tiersStats.computeIfAbsent(tier, (Function<String, TierStatsAccumulator>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$aggregateDataTierNodeCounts$6(java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/xpack/core/datatiers/DataTiersUsageTransportAction$TierStatsAccumulator;)()).nodeCount);
    }

    private static void aggregateDataTierIndexStats(NodeDataTiersUsage nodeDataTiersUsage, Map<String, TierStatsAccumulator> accumulators) {
        for (Map.Entry<String, NodeDataTiersUsage.UsageStats> entry : nodeDataTiersUsage.getUsageStatsByTier().entrySet()) {
            String tier = entry.getKey();
            NodeDataTiersUsage.UsageStats usage = entry.getValue();
            if (!DataTier.validTierName(tier)) continue;
            TierStatsAccumulator accumulator = accumulators.computeIfAbsent(tier, k -> new TierStatsAccumulator());
            accumulator.docCount += usage.getDocCount();
            accumulator.totalByteCount += usage.getTotalSize();
            accumulator.totalShardCount += usage.getTotalShardCount();
            for (Long primaryShardSize : usage.getPrimaryShardSizes()) {
                ++accumulator.primaryShardCount;
                accumulator.primaryByteCount += primaryShardSize.longValue();
                accumulator.valueSketch.add(primaryShardSize.longValue());
            }
        }
    }

    private static DataTiersFeatureSetUsage.TierSpecificStats aggregateFinalTierStats(TierStatsAccumulator accumulator) {
        long primaryShardSizeMedian = (long)accumulator.valueSketch.quantile(0.5);
        long primaryShardSizeMAD = DataTiersUsageTransportAction.computeMedianAbsoluteDeviation(accumulator.valueSketch);
        return new DataTiersFeatureSetUsage.TierSpecificStats(accumulator.nodeCount, accumulator.indexNames.size(), accumulator.totalShardCount, accumulator.primaryShardCount, accumulator.docCount, accumulator.totalByteCount, accumulator.primaryByteCount, primaryShardSizeMedian, primaryShardSizeMAD);
    }

    static long computeMedianAbsoluteDeviation(TDigestState valuesSketch) {
        if (valuesSketch.size() == 0L) {
            return 0L;
        }
        double approximateMedian = valuesSketch.quantile(0.5);
        TDigestState approximatedDeviationsSketch = TDigestState.createUsingParamsFrom(valuesSketch);
        valuesSketch.centroids().forEach(centroid -> {
            double deviation = Math.abs(approximateMedian - centroid.mean());
            approximatedDeviationsSketch.add(deviation, centroid.count());
        });
        return (long)approximatedDeviationsSketch.quantile(0.5);
    }

    private static Map<String, NodeDataTiersUsage.UsageStats> precalculateLocalStatsFromNodeStats(NodeStats nodeStats, ClusterState state) {
        RoutingNode routingNode = state.getRoutingNodes().node(nodeStats.getNode().getId());
        if (routingNode == null) {
            return Map.of();
        }
        return NodesDataTiersUsageTransportAction.aggregateStats(routingNode, state.metadata(), nodeStats.getIndices());
    }

    private static /* synthetic */ TierStatsAccumulator lambda$aggregateDataTierNodeCounts$6(String k) {
        return new TierStatsAccumulator();
    }

    private static class TierStatsAccumulator {
        int nodeCount = 0;
        Set<String> indexNames = new HashSet<String>();
        int totalShardCount = 0;
        long totalByteCount = 0L;
        long docCount = 0L;
        int primaryShardCount = 0;
        long primaryByteCount = 0L;
        final TDigestState valueSketch = TDigestState.create(1000.0);

        private TierStatsAccumulator() {
        }
    }
}

