/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;

public class FollowInfoAction
extends ActionType<Response> {
    public static final String NAME = "cluster:monitor/ccr/follow_info";
    public static final FollowInfoAction INSTANCE = new FollowInfoAction();

    private FollowInfoAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        public static final ParseField FOLLOWER_INDICES_FIELD = new ParseField("follower_indices", new String[0]);
        private final List<FollowerInfo> followInfos;

        public Response(List<FollowerInfo> followInfos) {
            this.followInfos = followInfos;
        }

        public List<FollowerInfo> getFollowInfos() {
            return this.followInfos;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.followInfos = in.readCollectionAsList(FollowerInfo::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.followInfos);
        }

        public Iterator<ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat(Iterators.single((builder, params) -> builder.startObject().startArray(FOLLOWER_INDICES_FIELD.getPreferredName())), this.followInfos.iterator(), Iterators.single((builder, params) -> builder.endArray().endObject()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.followInfos, response.followInfos);
        }

        public int hashCode() {
            return Objects.hash(this.followInfos);
        }

        public String toString() {
            return Strings.toString(this);
        }

        public static enum Status {
            ACTIVE("active"),
            PAUSED("paused");

            private final String name;

            private Status(String name) {
                this.name = name;
            }

            public static Status fromString(String value) {
                return switch (value) {
                    case "active" -> ACTIVE;
                    case "paused" -> PAUSED;
                    default -> throw new IllegalArgumentException("unexpected status value [" + value + "]");
                };
            }
        }

        public static class FollowerInfo
        implements Writeable,
        ToXContentObject {
            public static final ParseField FOLLOWER_INDEX_FIELD = new ParseField("follower_index", new String[0]);
            public static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
            public static final ParseField LEADER_INDEX_FIELD = new ParseField("leader_index", new String[0]);
            public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
            public static final ParseField PARAMETERS_FIELD = new ParseField("parameters", new String[0]);
            private final String followerIndex;
            private final String remoteCluster;
            private final String leaderIndex;
            private final Status status;
            private final FollowParameters parameters;

            public FollowerInfo(String followerIndex, String remoteCluster, String leaderIndex, Status status, FollowParameters parameters) {
                this.followerIndex = followerIndex;
                this.remoteCluster = remoteCluster;
                this.leaderIndex = leaderIndex;
                this.status = status;
                this.parameters = parameters;
            }

            public String getFollowerIndex() {
                return this.followerIndex;
            }

            public String getRemoteCluster() {
                return this.remoteCluster;
            }

            public String getLeaderIndex() {
                return this.leaderIndex;
            }

            public Status getStatus() {
                return this.status;
            }

            public FollowParameters getParameters() {
                return this.parameters;
            }

            FollowerInfo(StreamInput in) throws IOException {
                this.followerIndex = in.readString();
                this.remoteCluster = in.readString();
                this.leaderIndex = in.readString();
                this.status = Status.fromString(in.readString());
                this.parameters = in.readOptionalWriteable(FollowParameters::new);
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.followerIndex);
                out.writeString(this.remoteCluster);
                out.writeString(this.leaderIndex);
                out.writeString(this.status.name);
                out.writeOptionalWriteable(this.parameters);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(FOLLOWER_INDEX_FIELD.getPreferredName(), this.followerIndex);
                builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
                builder.field(LEADER_INDEX_FIELD.getPreferredName(), this.leaderIndex);
                builder.field(STATUS_FIELD.getPreferredName(), this.status.name);
                if (this.parameters != null) {
                    builder.startObject(PARAMETERS_FIELD.getPreferredName());
                    this.parameters.toXContentFragment(builder);
                    builder.endObject();
                }
                builder.endObject();
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                FollowerInfo that = (FollowerInfo)o;
                return Objects.equals(this.followerIndex, that.followerIndex) && Objects.equals(this.remoteCluster, that.remoteCluster) && Objects.equals(this.leaderIndex, that.leaderIndex) && this.status == that.status && Objects.equals(this.parameters, that.parameters);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.followerIndex, this.remoteCluster, this.leaderIndex, this.status, this.parameters});
            }

            public String toString() {
                return Strings.toString(this);
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private String[] followerIndices;

        public Request() {
        }

        public String[] getFollowerIndices() {
            return this.followerIndices;
        }

        public void setFollowerIndices(String ... followerIndices) {
            this.followerIndices = followerIndices;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.followerIndices = in.readOptionalStringArray();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.followerIndices);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.followerIndices, request.followerIndices);
        }

        public int hashCode() {
            return Arrays.hashCode(this.followerIndices);
        }
    }
}

