/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RemoteClusterServerInfo
implements ReportingService.Info {
    private final BoundTransportAddress address;

    public RemoteClusterServerInfo(StreamInput in) throws IOException {
        this(new BoundTransportAddress(in));
    }

    public RemoteClusterServerInfo(BoundTransportAddress address) {
        this.address = address;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("remote_cluster_server");
        builder.array("bound_address", this.address.boundAddresses());
        TransportAddress publishAddress = this.address.publishAddress();
        Object publishAddressString = publishAddress.toString();
        String hostString = publishAddress.address().getHostString();
        if (!InetAddresses.isInetAddress(hostString)) {
            publishAddressString = hostString + "/" + publishAddress;
        }
        builder.field("publish_address", (String)publishAddressString);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
    }

    public BoundTransportAddress getAddress() {
        return this.address;
    }
}

