/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.retriever;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.SuggestingErrorOnUnknown;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.FilterXContentParserWrapper;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;

public abstract class RetrieverBuilder
implements ToXContent {
    public static final NodeFeature RETRIEVERS_SUPPORTED = new NodeFeature("retrievers_supported");
    public static final ParseField PRE_FILTER_FIELD = new ParseField("filter", new String[0]);
    protected List<QueryBuilder> preFilterQueryBuilders = new ArrayList<QueryBuilder>();

    protected static void declareBaseParserFields(String name, AbstractObjectParser<? extends RetrieverBuilder, RetrieverParserContext> parser) {
        parser.declareObjectArray((r, v) -> {
            r.preFilterQueryBuilders = v;
        }, (p, c) -> {
            QueryBuilder preFilterQueryBuilder = AbstractQueryBuilder.parseTopLevelQuery(p, c::trackQueryUsage);
            c.trackSectionUsage(name + ":" + PRE_FILTER_FIELD.getPreferredName());
            return preFilterQueryBuilder;
        }, PRE_FILTER_FIELD);
    }

    public static RetrieverBuilder parseTopLevelRetrieverBuilder(XContentParser parser, RetrieverParserContext context) throws IOException {
        parser = new FilterXContentParserWrapper(parser){
            int nestedDepth = 0;

            @Override
            public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
                if (categoryClass.equals(RetrieverBuilder.class)) {
                    ++this.nestedDepth;
                    if (this.nestedDepth > 2) {
                        throw new IllegalArgumentException("the nested depth of the [" + name + "] retriever exceeds the maximum nested depth [2] for retrievers");
                    }
                }
                T namedObject = this.getXContentRegistry().parseNamedObject(categoryClass, name, this, context);
                if (categoryClass.equals(RetrieverBuilder.class)) {
                    --this.nestedDepth;
                }
                return namedObject;
            }
        };
        return RetrieverBuilder.parseInnerRetrieverBuilder(parser, context);
    }

    protected static RetrieverBuilder parseInnerRetrieverBuilder(XContentParser parser, RetrieverParserContext context) throws IOException {
        RetrieverBuilder retrieverBuilder;
        Objects.requireNonNull(context);
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "retriever malformed, must start with [" + XContentParser.Token.START_OBJECT + "]", new Object[0]);
        }
        if (parser.nextToken() == XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "retriever malformed, empty clause found", new Object[0]);
        }
        if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "retriever malformed, no field after [" + XContentParser.Token.START_OBJECT + "]", new Object[0]);
        }
        String retrieverName = parser.currentName();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + retrieverName + "] retriever malformed, no [" + XContentParser.Token.START_OBJECT + "] after retriever name", new Object[0]);
        }
        try {
            retrieverBuilder = parser.namedObject(RetrieverBuilder.class, retrieverName, context);
        }
        catch (NamedObjectNotFoundException nonfe) {
            String message = String.format(Locale.ROOT, "unknown retriever [%s]%s", retrieverName, SuggestingErrorOnUnknown.suggest(retrieverName, nonfe.getCandidates()));
            throw new ParsingException(new XContentLocation(nonfe.getLineNumber(), nonfe.getColumnNumber()), message, nonfe, new Object[0]);
        }
        context.trackSectionUsage(retrieverName);
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + retrieverName + "] malformed retriever, expected [" + XContentParser.Token.END_OBJECT + "] but found [" + parser.currentToken() + "]", new Object[0]);
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + retrieverName + "] malformed retriever, expected [" + XContentParser.Token.END_OBJECT + "] but found [" + parser.currentToken() + "]", new Object[0]);
        }
        return retrieverBuilder;
    }

    public List<QueryBuilder> getPreFilterQueryBuilders() {
        return this.preFilterQueryBuilders;
    }

    public abstract void extractToSearchSourceBuilder(SearchSourceBuilder var1, boolean var2);

    public abstract String getName();

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.preFilterQueryBuilders.isEmpty()) {
            builder.field(PRE_FILTER_FIELD.getPreferredName(), (Iterable<?>)this.preFilterQueryBuilders);
        }
        this.doToXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doToXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public boolean isFragment() {
        return false;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieverBuilder that = (RetrieverBuilder)o;
        return Objects.equals(this.preFilterQueryBuilders, that.preFilterQueryBuilders) && this.doEquals(o);
    }

    protected abstract boolean doEquals(Object var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.preFilterQueryBuilders, this.doHashCode());
    }

    protected abstract int doHashCode();

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

