/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.query.CollectorResult;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SearchProfileDfsPhaseResult
implements Writeable,
ToXContentObject {
    private final ProfileResult dfsShardResult;
    private final List<QueryProfileShardResult> queryProfileShardResult;
    public static final ParseField STATISTICS = new ParseField("statistics", new String[0]);
    public static final ParseField KNN = new ParseField("knn", new String[0]);

    @ParserConstructor
    public SearchProfileDfsPhaseResult(@Nullable ProfileResult dfsShardResult, @Nullable List<QueryProfileShardResult> queryProfileShardResult) {
        this.dfsShardResult = dfsShardResult;
        this.queryProfileShardResult = queryProfileShardResult;
    }

    public SearchProfileDfsPhaseResult(StreamInput in) throws IOException {
        QueryProfileShardResult singleResult;
        this.dfsShardResult = in.readOptionalWriteable(ProfileResult::new);
        this.queryProfileShardResult = in.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0) ? in.readOptionalCollectionAsList(QueryProfileShardResult::new) : ((singleResult = in.readOptionalWriteable(QueryProfileShardResult::new)) != null ? List.of(singleResult) : null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.dfsShardResult);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
            out.writeOptionalCollection(this.queryProfileShardResult);
        } else {
            out.writeOptionalWriteable(this.combineQueryProfileShardResults());
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.dfsShardResult != null) {
            builder.field(STATISTICS.getPreferredName());
            this.dfsShardResult.toXContent(builder, params);
        }
        if (this.queryProfileShardResult != null) {
            builder.startArray(KNN.getPreferredName());
            for (QueryProfileShardResult qpsr : this.queryProfileShardResult) {
                qpsr.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchProfileDfsPhaseResult that = (SearchProfileDfsPhaseResult)o;
        return Objects.equals(this.dfsShardResult, that.dfsShardResult) && Objects.equals(this.queryProfileShardResult, that.queryProfileShardResult);
    }

    public int hashCode() {
        return Objects.hash(this.dfsShardResult, this.queryProfileShardResult);
    }

    public String toString() {
        return "SearchProfileDfsPhaseResult{dfsShardResult=" + this.dfsShardResult + ", queryProfileShardResult=" + this.queryProfileShardResult + "}";
    }

    public ProfileResult getDfsShardResult() {
        return this.dfsShardResult;
    }

    public List<QueryProfileShardResult> getQueryProfileShardResult() {
        return this.queryProfileShardResult;
    }

    QueryProfileShardResult combineQueryProfileShardResults() {
        if (this.queryProfileShardResult == null) {
            return null;
        }
        ArrayList<CollectorResult> subCollectorResults = new ArrayList<CollectorResult>(this.queryProfileShardResult.size());
        long totalRewriteTime = 0L;
        long totalCollectionTime = 0L;
        ArrayList<ProfileResult> profileResults = new ArrayList<ProfileResult>();
        for (QueryProfileShardResult queryProfiler : this.queryProfileShardResult) {
            totalRewriteTime += queryProfiler.getRewriteTime();
            profileResults.addAll(queryProfiler.getQueryResults());
            subCollectorResults.add(queryProfiler.getCollectorResult());
            totalCollectionTime += queryProfiler.getCollectorResult().getTime();
        }
        return new QueryProfileShardResult(profileResults, totalRewriteTime, new CollectorResult("KnnQueryCollector", "search_multi", totalCollectionTime, subCollectorResults), null);
    }
}

