/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.InternalStats;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalExtendedStats
extends InternalStats
implements ExtendedStats {
    static final Set<String> METRIC_NAMES = Collections.unmodifiableSet(Stream.of(Metrics.values()).map(Enum::name).collect(Collectors.toSet()));
    private final double sumOfSqrs;
    private final double sigma;

    public InternalExtendedStats(String name, long count, double sum, double min, double max, double sumOfSqrs, double sigma, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, count, sum, min, max, formatter, metadata);
        this.sumOfSqrs = sumOfSqrs;
        this.sigma = sigma;
    }

    public InternalExtendedStats(StreamInput in) throws IOException {
        super(in);
        this.sumOfSqrs = in.readDouble();
        this.sigma = in.readDouble();
    }

    @Override
    protected void writeOtherStatsTo(StreamOutput out) throws IOException {
        out.writeDouble(this.sumOfSqrs);
        out.writeDouble(this.sigma);
    }

    @Override
    public String getWriteableName() {
        return "extended_stats";
    }

    static InternalExtendedStats empty(String name, double sigma, DocValueFormat format, Map<String, Object> metadata) {
        return new InternalExtendedStats(name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, sigma, format, metadata);
    }

    @Override
    public double value(String name) {
        if ("sum_of_squares".equals(name)) {
            return this.sumOfSqrs;
        }
        if ("variance".equals(name)) {
            return this.getVariance();
        }
        if ("variance_population".equals(name)) {
            return this.getVariancePopulation();
        }
        if ("variance_sampling".equals(name)) {
            return this.getVarianceSampling();
        }
        if ("std_deviation".equals(name)) {
            return this.getStdDeviation();
        }
        if ("std_deviation_population".equals(name)) {
            return this.getStdDeviationPopulation();
        }
        if ("std_deviation_sampling".equals(name)) {
            return this.getStdDeviationSampling();
        }
        if ("std_upper".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER);
        }
        if ("std_lower".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER);
        }
        if ("std_upper_population".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_POPULATION);
        }
        if ("std_lower_population".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_POPULATION);
        }
        if ("std_upper_sampling".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_SAMPLING);
        }
        if ("std_lower_sampling".equals(name)) {
            return this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_SAMPLING);
        }
        return super.value(name);
    }

    @Override
    public Iterable<String> valueNames() {
        return METRIC_NAMES;
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSqrs;
    }

    @Override
    public double getVariance() {
        return this.getVariancePopulation();
    }

    @Override
    public double getVariancePopulation() {
        double variance = (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)this.count;
        return variance < 0.0 ? 0.0 : variance;
    }

    @Override
    public double getVarianceSampling() {
        double variance = (this.sumOfSqrs - this.sum * this.sum / (double)this.count) / (double)(this.count - 1L);
        return variance < 0.0 ? 0.0 : variance;
    }

    @Override
    public double getStdDeviation() {
        return this.getStdDeviationPopulation();
    }

    @Override
    public double getStdDeviationPopulation() {
        return Math.sqrt(this.getVariancePopulation());
    }

    @Override
    public double getStdDeviationSampling() {
        return Math.sqrt(this.getVarianceSampling());
    }

    @Override
    public double getStdDeviationBound(ExtendedStats.Bounds bound) {
        return switch (bound) {
            default -> throw new IncompatibleClassChangeError();
            case ExtendedStats.Bounds.UPPER, ExtendedStats.Bounds.UPPER_POPULATION -> this.getAvg() + this.getStdDeviationPopulation() * this.sigma;
            case ExtendedStats.Bounds.UPPER_SAMPLING -> this.getAvg() + this.getStdDeviationSampling() * this.sigma;
            case ExtendedStats.Bounds.LOWER, ExtendedStats.Bounds.LOWER_POPULATION -> this.getAvg() - this.getStdDeviationPopulation() * this.sigma;
            case ExtendedStats.Bounds.LOWER_SAMPLING -> this.getAvg() - this.getStdDeviationSampling() * this.sigma;
        };
    }

    @Override
    public String getSumOfSquaresAsString() {
        return this.valueAsString(Metrics.sum_of_squares.name());
    }

    @Override
    public String getVarianceAsString() {
        return this.valueAsString(Metrics.variance.name());
    }

    @Override
    public String getVariancePopulationAsString() {
        return this.valueAsString(Metrics.variance_population.name());
    }

    @Override
    public String getVarianceSamplingAsString() {
        return this.valueAsString(Metrics.variance_sampling.name());
    }

    @Override
    public String getStdDeviationAsString() {
        return this.valueAsString(Metrics.std_deviation.name());
    }

    @Override
    public String getStdDeviationPopulationAsString() {
        return this.valueAsString(Metrics.std_deviation_population.name());
    }

    @Override
    public String getStdDeviationSamplingAsString() {
        return this.valueAsString(Metrics.std_deviation_sampling.name());
    }

    @Override
    public String getStdDeviationBoundAsString(ExtendedStats.Bounds bound) {
        return switch (bound) {
            default -> throw new IncompatibleClassChangeError();
            case ExtendedStats.Bounds.UPPER -> this.valueAsString(Metrics.std_upper.name());
            case ExtendedStats.Bounds.LOWER -> this.valueAsString(Metrics.std_lower.name());
            case ExtendedStats.Bounds.UPPER_POPULATION -> this.valueAsString(Metrics.std_upper_population.name());
            case ExtendedStats.Bounds.LOWER_POPULATION -> this.valueAsString(Metrics.std_lower_population.name());
            case ExtendedStats.Bounds.UPPER_SAMPLING -> this.valueAsString(Metrics.std_upper_sampling.name());
            case ExtendedStats.Bounds.LOWER_SAMPLING -> this.valueAsString(Metrics.std_lower_sampling.name());
        };
    }

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        final AggregatorReducer statsReducer = InternalStats.getReducer(this.name, this.format, this.getMetadata());
        return new AggregatorReducer(){
            double sumOfSqrs = 0.0;
            double compensationOfSqrs = 0.0;

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalExtendedStats stats = (InternalExtendedStats)aggregation;
                if (stats.sigma != InternalExtendedStats.this.sigma) {
                    throw new IllegalStateException("Cannot reduce other stats aggregations that have a different sigma");
                }
                double value = stats.getSumOfSquares();
                if (!Double.isFinite(value)) {
                    this.sumOfSqrs += value;
                } else if (Double.isFinite(this.sumOfSqrs)) {
                    double correctedOfSqrs = value - this.compensationOfSqrs;
                    double newSumOfSqrs = this.sumOfSqrs + correctedOfSqrs;
                    this.compensationOfSqrs = newSumOfSqrs - this.sumOfSqrs - correctedOfSqrs;
                    this.sumOfSqrs = newSumOfSqrs;
                }
                statsReducer.accept(aggregation);
            }

            @Override
            public InternalAggregation get() {
                InternalStats stats = (InternalStats)statsReducer.get();
                return new InternalExtendedStats(InternalExtendedStats.this.name, stats.getCount(), stats.getSum(), stats.getMin(), stats.getMax(), this.sumOfSqrs, InternalExtendedStats.this.sigma, InternalExtendedStats.this.format, InternalExtendedStats.this.getMetadata());
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalExtendedStats(this.name, samplingContext.scaleUp(this.count), samplingContext.scaleUp(this.sum), this.min, this.max, samplingContext.scaleUp(this.sumOfSqrs), this.sigma, this.format, this.getMetadata());
    }

    @Override
    protected XContentBuilder otherStatsToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.count != 0L) {
            builder.field("sum_of_squares", this.sumOfSqrs);
            builder.field("variance", this.getVariance());
            builder.field("variance_population", this.getVariancePopulation());
            builder.field("variance_sampling", this.getVarianceSampling());
            builder.field("std_deviation", this.getStdDeviation());
            builder.field("std_deviation_population", this.getStdDeviationPopulation());
            builder.field("std_deviation_sampling", this.getStdDeviationSampling());
            builder.startObject("std_deviation_bounds");
            builder.field("upper", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER));
            builder.field("lower", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER));
            builder.field("upper_population", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_POPULATION));
            builder.field("lower_population", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_POPULATION));
            builder.field("upper_sampling", this.getStdDeviationBound(ExtendedStats.Bounds.UPPER_SAMPLING));
            builder.field("lower_sampling", this.getStdDeviationBound(ExtendedStats.Bounds.LOWER_SAMPLING));
            builder.endObject();
            if (this.format != DocValueFormat.RAW) {
                builder.field("sum_of_squares_as_string", this.format.format(this.sumOfSqrs));
                builder.field("variance_as_string", this.format.format(this.getVariance()));
                builder.field("variance_population_as_string", this.format.format(this.getVariancePopulation()));
                builder.field("variance_sampling_as_string", this.format.format(this.getVarianceSampling()));
                builder.field("std_deviation_as_string", this.getStdDeviationAsString());
                builder.field("std_deviation_population_as_string", this.getStdDeviationPopulationAsString());
                builder.field("std_deviation_sampling_as_string", this.getStdDeviationSamplingAsString());
                builder.startObject("std_deviation_bounds_as_string");
                builder.field("upper", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER));
                builder.field("lower", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER));
                builder.field("upper_population", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER_POPULATION));
                builder.field("lower_population", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER_POPULATION));
                builder.field("upper_sampling", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.UPPER_SAMPLING));
                builder.field("lower_sampling", this.getStdDeviationBoundAsString(ExtendedStats.Bounds.LOWER_SAMPLING));
                builder.endObject();
            }
        } else {
            builder.nullField("sum_of_squares");
            builder.nullField("variance");
            builder.nullField("variance_population");
            builder.nullField("variance_sampling");
            builder.nullField("std_deviation");
            builder.nullField("std_deviation_population");
            builder.nullField("std_deviation_sampling");
            builder.startObject("std_deviation_bounds");
            builder.nullField("upper");
            builder.nullField("lower");
            builder.nullField("upper_population");
            builder.nullField("lower_population");
            builder.nullField("upper_sampling");
            builder.nullField("lower_sampling");
            builder.endObject();
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sumOfSqrs, this.sigma);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalExtendedStats other = (InternalExtendedStats)obj;
        return Double.compare(this.sumOfSqrs, other.sumOfSqrs) == 0 && Double.compare(this.sigma, other.sigma) == 0;
    }

    static enum Metrics {
        count,
        sum,
        min,
        max,
        avg,
        sum_of_squares,
        variance,
        variance_population,
        variance_sampling,
        std_deviation,
        std_deviation_population,
        std_deviation_sampling,
        std_upper,
        std_lower,
        std_upper_population,
        std_lower_population,
        std_upper_sampling,
        std_lower_sampling;


        public static Metrics resolve(String name) {
            return Metrics.valueOf(name);
        }

        public static boolean hasMetric(String name) {
            try {
                Metrics.resolve(name);
                return true;
            }
            catch (IllegalArgumentException iae) {
                return false;
            }
        }
    }

    static class Fields {
        public static final String SUM_OF_SQRS = "sum_of_squares";
        public static final String SUM_OF_SQRS_AS_STRING = "sum_of_squares_as_string";
        public static final String VARIANCE = "variance";
        public static final String VARIANCE_AS_STRING = "variance_as_string";
        public static final String VARIANCE_POPULATION = "variance_population";
        public static final String VARIANCE_POPULATION_AS_STRING = "variance_population_as_string";
        public static final String VARIANCE_SAMPLING = "variance_sampling";
        public static final String VARIANCE_SAMPLING_AS_STRING = "variance_sampling_as_string";
        public static final String STD_DEVIATION = "std_deviation";
        public static final String STD_DEVIATION_AS_STRING = "std_deviation_as_string";
        public static final String STD_DEVIATION_POPULATION = "std_deviation_population";
        public static final String STD_DEVIATION_POPULATION_AS_STRING = "std_deviation_population_as_string";
        public static final String STD_DEVIATION_SAMPLING = "std_deviation_sampling";
        public static final String STD_DEVIATION_SAMPLING_AS_STRING = "std_deviation_sampling_as_string";
        public static final String STD_DEVIATION_BOUNDS = "std_deviation_bounds";
        public static final String STD_DEVIATION_BOUNDS_AS_STRING = "std_deviation_bounds_as_string";
        public static final String UPPER = "upper";
        public static final String LOWER = "lower";
        public static final String UPPER_POPULATION = "upper_population";
        public static final String LOWER_POPULATION = "lower_population";
        public static final String UPPER_SAMPLING = "upper_sampling";
        public static final String LOWER_SAMPLING = "lower_sampling";

        Fields() {
        }
    }
}

