/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.DelayedBucket;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.TopBucketBuilder;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractInternalTerms<A extends AbstractInternalTerms<A, B>, B extends AbstractTermsBucket<B>>
extends InternalMultiBucketAggregation<A, B> {
    public AbstractInternalTerms(String name, Map<String, Object> metadata) {
        super(name, metadata);
    }

    protected AbstractInternalTerms(StreamInput in) throws IOException {
        super(in);
    }

    protected abstract A create(String var1, List<B> var2, BucketOrder var3, long var4, long var6);

    protected abstract int getShardSize();

    protected abstract BucketOrder getReduceOrder();

    protected abstract BucketOrder getOrder();

    protected abstract long getSumOfOtherDocCounts();

    protected abstract Long getDocCountError();

    protected abstract void setDocCountError(long var1);

    protected abstract long getMinDocCount();

    protected abstract int getRequiredSize();

    protected abstract B createBucket(long var1, InternalAggregations var3, long var4, B var6);

    private B reduceBucket(List<B> buckets, AggregationReduceContext context) {
        assert (!buckets.isEmpty());
        long docCount = 0L;
        long docCountError = 0L;
        for (AbstractTermsBucket bucket : buckets) {
            docCount += bucket.getDocCount();
            if (docCountError == -1L) continue;
            if (!bucket.getShowDocCountError() || bucket.getDocCountError() == -1L) {
                docCountError = -1L;
                continue;
            }
            docCountError += bucket.getDocCountError();
        }
        InternalMultiBucketAggregation.BucketAggregationList<B> aggregations = new InternalMultiBucketAggregation.BucketAggregationList<B>(buckets);
        InternalAggregations aggs = InternalAggregations.reduce(aggregations, context);
        return (B)this.createBucket(docCount, aggs, docCountError, (AbstractTermsBucket)buckets.get(0));
    }

    private long getDocCountError(A terms) {
        int size = ((InternalMultiBucketAggregation)terms).getBuckets().size();
        if (size == 0 || size < ((AbstractInternalTerms)terms).getShardSize() || InternalOrder.isKeyOrder(((AbstractInternalTerms)terms).getOrder())) {
            return 0L;
        }
        if (InternalOrder.isCountDesc(((AbstractInternalTerms)terms).getOrder())) {
            if (((AbstractInternalTerms)terms).getDocCountError() != null) {
                return ((AbstractInternalTerms)terms).getDocCountError();
            }
            return ((InternalMultiBucketAggregation)terms).getBuckets().stream().mapToLong(MultiBucketsAggregation.Bucket::getDocCount).min().getAsLong();
        }
        return -1L;
    }

    private BucketOrder reduceBuckets(List<List<B>> bucketsList, BucketOrder thisReduceOrder, AggregationReduceContext reduceContext, Consumer<DelayedBucket<B>> sink) {
        if (InternalOrder.isKeyOrder(thisReduceOrder)) {
            thisReduceOrder = InternalOrder.key(InternalOrder.isKeyAsc(thisReduceOrder));
            this.reduceMergeSort(bucketsList, thisReduceOrder, reduceContext, sink);
        } else {
            this.reduceLegacy(bucketsList, reduceContext, sink);
        }
        return thisReduceOrder;
    }

    private void reduceMergeSort(List<List<B>> bucketsList, BucketOrder thisReduceOrder, AggregationReduceContext reduceContext, Consumer<DelayedBucket<B>> sink) {
        assert (InternalOrder.isKeyOrder(thisReduceOrder));
        final Comparator<MultiBucketsAggregation.Bucket> cmp = thisReduceOrder.comparator();
        PriorityQueue pq = new PriorityQueue<IteratorAndCurrent<B>>(bucketsList.size()){

            @Override
            protected boolean lessThan(IteratorAndCurrent<B> a, IteratorAndCurrent<B> b) {
                return cmp.compare(a.current(), b.current()) < 0;
            }
        };
        for (List<B> buckets : bucketsList) {
            pq.add(new IteratorAndCurrent<B>(buckets.iterator()));
        }
        ArrayList<AbstractTermsBucket> sameTermBuckets = new ArrayList<AbstractTermsBucket>();
        AbstractTermsBucket lastBucket = null;
        while (pq.size() > 0) {
            IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
            assert (lastBucket == null || cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0);
            if (lastBucket != null && cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) != 0) {
                sink.accept(new DelayedBucket<AbstractTermsBucket>(this::reduceBucket, reduceContext, sameTermBuckets));
                sameTermBuckets = new ArrayList();
            }
            lastBucket = (AbstractTermsBucket)top.current();
            sameTermBuckets.add((AbstractTermsBucket)top.current());
            if (top.hasNext()) {
                top.next();
                assert (cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0) : "shards must return data sorted by key";
                pq.updateTop();
                continue;
            }
            pq.pop();
        }
        if (!sameTermBuckets.isEmpty()) {
            sink.accept(new DelayedBucket<AbstractTermsBucket>(this::reduceBucket, reduceContext, sameTermBuckets));
        }
    }

    private void reduceLegacy(List<List<B>> bucketsList, AggregationReduceContext reduceContext, Consumer<DelayedBucket<B>> sink) {
        HashMap<Object, List> bucketMap = new HashMap<Object, List>();
        for (List<B> buckets : bucketsList) {
            for (AbstractTermsBucket bucket : buckets) {
                bucketMap.computeIfAbsent(bucket.getKey(), k -> new ArrayList()).add(bucket);
            }
        }
        for (List<Object> sameTermBuckets : bucketMap.values()) {
            sink.accept(new DelayedBucket<Object>(this::reduceBucket, reduceContext, sameTermBuckets));
        }
    }

    public final AggregatorReducer termsAggregationReducer(AggregationReduceContext reduceContext, int size) {
        return new TermsAggregationReducer(reduceContext, size);
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this.create(this.name, this.getBuckets().stream().map(b -> this.createBucket(samplingContext.scaleUp(b.getDocCount()), InternalAggregations.finalizeSampling(b.getAggregations(), samplingContext), b.getShowDocCountError() ? samplingContext.scaleUp(b.getDocCountError()) : 0L, b)).toList(), this.getOrder(), samplingContext.scaleUp(this.getDocCountError()), samplingContext.scaleUp(this.getSumOfOtherDocCounts()));
    }

    protected static XContentBuilder doXContentCommon(XContentBuilder builder, ToXContent.Params params, Long docCountError, long otherDocCount, List<? extends AbstractTermsBucket<?>> buckets) throws IOException {
        builder.field(InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), docCountError);
        builder.field(InternalTerms.SUM_OF_OTHER_DOC_COUNTS.getPreferredName(), otherDocCount);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (AbstractTermsBucket<?> bucket : buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static abstract class AbstractTermsBucket<B extends AbstractTermsBucket<B>>
    extends InternalMultiBucketAggregation.InternalBucket
    implements KeyComparable<B> {
        protected abstract void updateDocCountError(long var1);

        protected abstract void setDocCountError(long var1);

        protected abstract boolean getShowDocCountError();

        protected abstract long getDocCountError();
    }

    private class TermsAggregationReducer
    implements AggregatorReducer {
        private final List<List<B>> bucketsList;
        private final AggregationReduceContext reduceContext;
        private final int size;
        private long sumDocCountError = 0L;
        private final long[] otherDocCount = new long[]{0L};
        private A referenceTerms = null;
        private BucketOrder thisReduceOrder = null;

        private TermsAggregationReducer(AggregationReduceContext reduceContext, int size) {
            this.bucketsList = new ArrayList(size);
            this.reduceContext = reduceContext;
            this.size = size;
        }

        @Override
        public void accept(InternalAggregation aggregation) {
            if (!aggregation.canLeadReduction()) {
                return;
            }
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (this.referenceTerms == null) {
                this.referenceTerms = terms;
            } else if (!this.referenceTerms.getClass().equals(terms.getClass())) {
                throw AggregationErrors.reduceTypeMismatch(((InternalAggregation)this.referenceTerms).getName(), Optional.empty());
            }
            if (this.thisReduceOrder == null) {
                this.thisReduceOrder = terms.getReduceOrder();
            } else if (this.thisReduceOrder != AbstractInternalTerms.this.getOrder() && !this.thisReduceOrder.equals(terms.getReduceOrder())) {
                this.thisReduceOrder = AbstractInternalTerms.this.getOrder();
            }
            this.otherDocCount[0] = this.otherDocCount[0] + terms.getSumOfOtherDocCounts();
            long thisAggDocCountError = AbstractInternalTerms.this.getDocCountError(terms);
            if (this.sumDocCountError != -1L) {
                this.sumDocCountError = thisAggDocCountError == -1L ? -1L : (this.sumDocCountError += thisAggDocCountError);
            }
            AbstractInternalTerms.this.setDocCountError(thisAggDocCountError);
            for (AbstractTermsBucket bucket : terms.getBuckets()) {
                bucket.updateDocCountError(-thisAggDocCountError);
            }
            if (!terms.getBuckets().isEmpty()) {
                this.bucketsList.add(terms.getBuckets());
            }
        }

        @Override
        public InternalAggregation get() {
            BucketOrder thisReduceOrder;
            List<Object> result;
            if (InternalOrder.isKeyOrder(AbstractInternalTerms.this.getOrder()) && AbstractInternalTerms.this.getMinDocCount() <= 1L) {
                result = new ArrayList();
                thisReduceOrder = AbstractInternalTerms.this.reduceBuckets(this.bucketsList, this.getThisReduceOrder(), this.reduceContext, bucket -> {
                    if (result.size() < AbstractInternalTerms.this.getRequiredSize()) {
                        result.add((AbstractTermsBucket)bucket.reduced());
                    } else {
                        this.otherDocCount[0] = this.otherDocCount[0] + bucket.getDocCount();
                    }
                });
            } else if (this.reduceContext.isFinalReduce()) {
                TopBucketBuilder top = TopBucketBuilder.build(AbstractInternalTerms.this.getRequiredSize(), AbstractInternalTerms.this.getOrder(), removed -> {
                    this.otherDocCount[0] = this.otherDocCount[0] + removed.getDocCount();
                });
                thisReduceOrder = AbstractInternalTerms.this.reduceBuckets(this.bucketsList, this.getThisReduceOrder(), this.reduceContext, bucket -> {
                    if (bucket.getDocCount() >= AbstractInternalTerms.this.getMinDocCount()) {
                        top.add(bucket);
                    }
                });
                result = top.build();
            } else {
                result = new ArrayList();
                thisReduceOrder = AbstractInternalTerms.this.reduceBuckets(this.bucketsList, this.getThisReduceOrder(), this.reduceContext, bucket -> result.add((AbstractTermsBucket)bucket.reduced()));
            }
            for (AbstractTermsBucket r : result) {
                if (this.sumDocCountError == -1L) {
                    r.setDocCountError(-1L);
                    continue;
                }
                r.updateDocCountError(this.sumDocCountError);
            }
            long docCountError = this.sumDocCountError == -1L ? -1L : (this.size == 1 ? 0L : this.sumDocCountError);
            return AbstractInternalTerms.this.create(AbstractInternalTerms.this.name, result, this.reduceContext.isFinalReduce() ? AbstractInternalTerms.this.getOrder() : thisReduceOrder, docCountError, this.otherDocCount[0]);
        }

        private BucketOrder getThisReduceOrder() {
            return this.thisReduceOrder == null ? AbstractInternalTerms.this.getOrder() : this.thisReduceOrder;
        }
    }
}

