/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.DoubleUnaryOperator;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AdaptingAggregator;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.FilterByFilterAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public abstract class RangeAggregator
extends BucketsAggregator {
    public static final double DOCS_PER_RANGE_TO_USE_FILTERS = 5000.0;
    public static final long MAX_ACCURATE_BOUND = 0x20000000000000L;
    public static final ParseField RANGES_FIELD = new ParseField("ranges", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    static final DoubleUnaryOperator IDENTITY = DoubleUnaryOperator.identity();
    private int singletonRanges;
    private int nonsingletonRanges;
    protected final ValuesSource valuesSource;
    private final DocValueFormat format;
    protected final Range[] ranges;
    private final boolean keyed;
    private final InternalRange.Factory rangeFactory;
    private final double averageDocsPerRange;

    public static Aggregator build(String name, AggregatorFactories factories, ValuesSourceConfig valuesSourceConfig, InternalRange.Factory<?, ?> rangeFactory, Range[] ranges, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        double averageDocsPerRange = (double)context.searcher().getIndexReader().maxDoc() / (double)ranges.length;
        FromFilters<?> adapted = RangeAggregator.adaptIntoFiltersOrNull(name, factories, valuesSourceConfig, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
        if (adapted != null) {
            return adapted;
        }
        return RangeAggregator.buildWithoutAttemptedToAdaptToFilters(name, factories, (ValuesSource.Numeric)valuesSourceConfig.getValuesSource(), valuesSourceConfig.format(), rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
    }

    public static FromFilters<?> adaptIntoFiltersOrNull(String name, final AggregatorFactories factories, final ValuesSourceConfig valuesSourceConfig, final InternalRange.Factory<?, ?> rangeFactory, final Range[] ranges, final double averageDocsPerRange, final boolean keyed, AggregationContext context, final Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (!valuesSourceConfig.alignesWithSearchIndex()) {
            return null;
        }
        if (averageDocsPerRange < 5000.0) {
            return null;
        }
        if (valuesSourceConfig.fieldType() instanceof DateFieldMapper.DateFieldType && ((DateFieldMapper.DateFieldType)valuesSourceConfig.fieldType()).resolution() == DateFieldMapper.Resolution.NANOSECONDS) {
            return null;
        }
        if (!context.enableRewriteToFilterByFilter()) {
            return null;
        }
        boolean wholeNumbersOnly = false == ((ValuesSource.Numeric)valuesSourceConfig.getValuesSource()).isFloatingPoint();
        FilterByFilterAggregator.AdapterBuilder filterByFilterBuilder = new FilterByFilterAggregator.AdapterBuilder<FromFilters<?>>(name, false, false, null, context, parent, cardinality, metadata){

            @Override
            protected FromFilters<?> adapt(CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> delegate) throws IOException {
                return new FromFilters(parent, factories, delegate, valuesSourceConfig.format(), ranges, keyed, rangeFactory, averageDocsPerRange);
            }
        };
        for (int i = 0; i < ranges.length; ++i) {
            if (wholeNumbersOnly && ranges[i].from != Double.NEGATIVE_INFINITY && Math.abs(ranges[i].from) > 9.007199254740992E15) {
                return null;
            }
            if (wholeNumbersOnly && ranges[i].to != Double.POSITIVE_INFINITY && Math.abs(ranges[i].to) > 9.007199254740992E15) {
                return null;
            }
            DocValueFormat format = valuesSourceConfig.fieldType().docValueFormat(null, null);
            RangeQueryBuilder builder = new RangeQueryBuilder(valuesSourceConfig.fieldType().name());
            builder.from(ranges[i].from == Double.NEGATIVE_INFINITY ? null : format.format(ranges[i].from)).includeLower(true);
            builder.to(ranges[i].to == Double.POSITIVE_INFINITY ? null : format.format(ranges[i].to)).includeUpper(false);
            filterByFilterBuilder.add(Integer.toString(i), context.buildQuery(builder));
        }
        return (FromFilters)filterByFilterBuilder.build();
    }

    public static Aggregator buildWithoutAttemptedToAdaptToFilters(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, InternalRange.Factory<?, ?> rangeFactory, Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (RangeAggregator.hasOverlap(ranges)) {
            return new Overlap(name, factories, valuesSource, format, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
        }
        return new NoOverlap(name, factories, valuesSource, format, (InternalRange.Factory)rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
    }

    public RangeAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, InternalRange.Factory rangeFactory, Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality.multiply(ranges.length), metadata);
        assert (valuesSource != null);
        this.valuesSource = valuesSource;
        this.format = format;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.ranges = ranges;
        this.averageDocsPerRange = averageDocsPerRange;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    protected long subBucketOrdinal(long owningBucketOrdinal, int rangeOrd) {
        return owningBucketOrdinal * (long)this.ranges.length + (long)rangeOrd;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForFixedBucketCount(owningBucketOrds, this.ranges.length, (offsetInOwningOrd, docCount, subAggregationResults) -> {
            Range range = this.ranges[offsetInOwningOrd];
            return this.rangeFactory.createBucket(range.key, range.originalFrom, range.originalTo, docCount, subAggregationResults, this.keyed, this.format);
        }, buckets -> this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList buckets = new ArrayList(this.ranges.length);
        for (Range range : this.ranges) {
            Object bucket = this.rangeFactory.createBucket(range.key, range.originalFrom, range.originalTo, 0L, subAggs, this.keyed, this.format);
            buckets.add(bucket);
        }
        return this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.metadata());
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("ranges", this.ranges.length);
        add.accept("average_docs_per_range", this.averageDocsPerRange);
        add.accept("singletons", this.singletonRanges);
        add.accept("non-singletons", this.nonsingletonRanges);
    }

    public static boolean hasOverlap(Range[] ranges) {
        double lastEnd = ranges[0].to;
        for (int i = 1; i < ranges.length; ++i) {
            if (ranges[i].from < lastEnd) {
                return true;
            }
            lastEnd = ranges[i].to;
        }
        return false;
    }

    public static class Range
    implements Writeable,
    ToXContentObject {
        public static final ParseField KEY_FIELD = new ParseField("key", new String[0]);
        public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
        public static final ParseField TO_FIELD = new ParseField("to", new String[0]);
        protected final String key;
        protected final double from;
        protected final Double originalFrom;
        protected final String fromAsStr;
        protected final double to;
        protected final Double originalTo;
        protected final String toAsStr;
        public static final ConstructingObjectParser<Range, Void> PARSER = new ConstructingObjectParser("range", arg -> {
            String key = (String)arg[0];
            Object from = arg[1];
            Object to = arg[2];
            Double fromDouble = from instanceof Number ? Double.valueOf(((Number)from).doubleValue()) : null;
            Double toDouble = to instanceof Number ? Double.valueOf(((Number)to).doubleValue()) : null;
            String fromStr = from instanceof String ? (String)from : null;
            String toStr = to instanceof String ? (String)to : null;
            return new Range(key, fromDouble, fromStr, toDouble, toStr);
        });

        public Range(String key, Double from, String fromAsStr, Double to, String toAsStr, DoubleUnaryOperator fixPrecision) {
            this.key = key;
            this.from = from == null ? Double.NEGATIVE_INFINITY : fixPrecision.applyAsDouble(from);
            this.originalFrom = from == null ? Double.NEGATIVE_INFINITY : from;
            this.fromAsStr = fromAsStr;
            this.to = to == null ? Double.POSITIVE_INFINITY : fixPrecision.applyAsDouble(to);
            this.originalTo = to == null ? Double.POSITIVE_INFINITY : to;
            this.toAsStr = toAsStr;
        }

        public Range(String key, Double from, String fromAsStr, Double to, String toAsStr) {
            this(key, from, fromAsStr, to, toAsStr, IDENTITY);
        }

        public Range(String key, Double from, Double to) {
            this(key, from, null, to, null);
        }

        public Range(String key, String from, String to) {
            this(key, null, from, null, to);
        }

        public Range(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.fromAsStr = in.readOptionalString();
            this.toAsStr = in.readOptionalString();
            this.from = in.readDouble();
            this.to = in.readDouble();
            this.originalFrom = in.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0) ? in.readOptionalDouble() : Double.valueOf(this.from);
            this.originalTo = in.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0) ? in.readOptionalDouble() : Double.valueOf(this.to);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeOptionalString(this.fromAsStr);
            out.writeOptionalString(this.toAsStr);
            out.writeDouble(this.from);
            out.writeDouble(this.to);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_17_0)) {
                out.writeOptionalDouble(this.originalFrom);
                out.writeOptionalDouble(this.originalTo);
            }
        }

        public double getFrom() {
            return this.originalFrom;
        }

        public double getTo() {
            return this.originalTo;
        }

        public String getFromAsString() {
            return this.fromAsStr;
        }

        public String getToAsString() {
            return this.toAsStr;
        }

        public String getKey() {
            return this.key;
        }

        public boolean matches(double value) {
            return value >= this.from && value < this.to;
        }

        public String toString() {
            return "[" + this.from + " to " + this.to + ")";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.key != null) {
                builder.field(KEY_FIELD.getPreferredName(), this.key);
            }
            if (Double.isFinite(this.originalFrom)) {
                builder.field(FROM_FIELD.getPreferredName(), this.originalFrom);
            }
            if (Double.isFinite(this.originalTo)) {
                builder.field(TO_FIELD.getPreferredName(), this.originalTo);
            }
            if (this.fromAsStr != null) {
                builder.field(FROM_FIELD.getPreferredName(), this.fromAsStr);
            }
            if (this.toAsStr != null) {
                builder.field(TO_FIELD.getPreferredName(), this.toAsStr);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.from, this.fromAsStr, this.to, this.toAsStr);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.from, other.from) && Objects.equals(this.fromAsStr, other.fromAsStr) && Objects.equals(this.to, other.to) && Objects.equals(this.toAsStr, other.toAsStr);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), KEY_FIELD, ObjectParser.ValueType.DOUBLE);
            ContextParser<Void, Object> fromToParser = (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return p.text();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.doubleValue();
                }
                return null;
            };
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), fromToParser, FROM_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), fromToParser, TO_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
        }
    }

    static class FromFilters<B extends InternalRange.Bucket>
    extends AdaptingAggregator {
        private final DocValueFormat format;
        private final Range[] ranges;
        private final boolean keyed;
        private final InternalRange.Factory<B, ?> rangeFactory;
        private final double averageDocsPerRange;

        FromFilters(Aggregator parent, AggregatorFactories subAggregators, CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> delegate, DocValueFormat format, Range[] ranges, boolean keyed, InternalRange.Factory<B, ?> rangeFactory, double averageDocsPerRange) throws IOException {
            super(parent, subAggregators, delegate);
            this.format = format;
            this.ranges = ranges;
            this.keyed = keyed;
            this.rangeFactory = rangeFactory;
            this.averageDocsPerRange = averageDocsPerRange;
        }

        @Override
        protected InternalAggregation adapt(InternalAggregation delegateResult) {
            InternalFilters filters = (InternalFilters)delegateResult;
            if (filters.getBuckets().size() != this.ranges.length) {
                throw new IllegalStateException("bad number of filters [" + filters.getBuckets().size() + "] expecting [" + this.ranges.length + "]");
            }
            ArrayList<B> buckets = new ArrayList<B>(filters.getBuckets().size());
            for (int i = 0; i < this.ranges.length; ++i) {
                Range r = this.ranges[i];
                InternalFilters.InternalBucket b = filters.getBuckets().get(i);
                buckets.add(this.rangeFactory.createBucket(r.getKey(), r.originalFrom, r.originalTo, b.getDocCount(), b.getAggregations(), this.keyed, this.format));
            }
            return this.rangeFactory.create(this.name(), buckets, this.format, this.keyed, filters.getMetadata());
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("ranges", this.ranges.length);
            add.accept("average_docs_per_range", this.averageDocsPerRange);
        }
    }

    private static class Overlap
    extends NumericRangeAggregator {
        private final double[] maxTo;
        private final BucketCollector collector;

        Overlap(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, InternalRange.Factory<?, ?> rangeFactory, Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, valuesSource, format, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
            this.maxTo = new double[ranges.length];
            this.maxTo[0] = ranges[0].to;
            for (int i = 1; i < ranges.length; ++i) {
                this.maxTo[i] = Math.max(ranges[i].to, this.maxTo[i - 1]);
            }
            if (parent == null) {
                this.grow(ranges.length);
                this.collector = this::collectExistingBucket;
            } else {
                this.collector = this::collectBucket;
            }
        }

        @Override
        protected int collect(LeafBucketCollector sub, int doc, double value, long owningBucketOrdinal, int lowBound) throws IOException {
            int lo = lowBound;
            int hi = this.ranges.length - 1;
            int mid = lo + hi >>> 1;
            while (lo <= hi) {
                if (value < this.ranges[mid].from) {
                    hi = mid - 1;
                } else {
                    if (!(value >= this.maxTo[mid])) break;
                    lo = mid + 1;
                }
                mid = lo + hi >>> 1;
            }
            if (lo > hi) {
                return lo;
            }
            int startLo = lo;
            int startHi = mid;
            while (startLo <= startHi) {
                int startMid = startLo + startHi >>> 1;
                if (value >= this.maxTo[startMid]) {
                    startLo = startMid + 1;
                    continue;
                }
                startHi = startMid - 1;
            }
            int endLo = mid;
            int endHi = hi;
            while (endLo <= endHi) {
                int endMid = endLo + endHi >>> 1;
                if (value < this.ranges[endMid].from) {
                    endHi = endMid - 1;
                    continue;
                }
                endLo = endMid + 1;
            }
            assert (startLo == lowBound || value >= this.maxTo[startLo - 1]);
            assert (endHi == this.ranges.length - 1 || value < this.ranges[endHi + 1].from);
            for (int i = startLo; i <= endHi; ++i) {
                if (!this.ranges[i].matches(value)) continue;
                this.collector.accept(sub, doc, this.subBucketOrdinal(owningBucketOrdinal, i));
            }
            return endHi + 1;
        }
    }

    static class NoOverlap
    extends NumericRangeAggregator {
        private final BucketCollector collector;

        NoOverlap(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, InternalRange.Factory rangeFactory, Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, valuesSource, format, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
            if (parent == null) {
                this.grow(ranges.length);
                this.collector = this::collectExistingBucket;
            } else {
                this.collector = this::collectBucket;
            }
        }

        @Override
        protected int collect(LeafBucketCollector sub, int doc, double value, long owningBucketOrdinal, int lowBound) throws IOException {
            int lo = lowBound;
            int hi = this.ranges.length - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                if (value < this.ranges[mid].from) {
                    hi = mid - 1;
                    continue;
                }
                if (value >= this.ranges[mid].to) {
                    lo = mid + 1;
                    continue;
                }
                this.collector.accept(sub, doc, this.subBucketOrdinal(owningBucketOrdinal, mid));
                return mid + 1;
            }
            return lo;
        }
    }

    @FunctionalInterface
    private static interface BucketCollector {
        public void accept(LeafBucketCollector var1, int var2, long var3) throws IOException;
    }

    private static abstract class NumericRangeAggregator
    extends RangeAggregator {
        NumericRangeAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, InternalRange.Factory<?, ?> rangeFactory, Range[] ranges, double averageDocsPerRange, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
            super(name, factories, valuesSource, format, rangeFactory, ranges, averageDocsPerRange, keyed, context, parent, cardinality, metadata);
        }

        @Override
        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
            final SortedNumericDoubleValues values = ((ValuesSource.Numeric)this.valuesSource).doubleValues(aggCtx.getLeafReaderContext());
            final NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
            if (singleton != null) {
                ++this.singletonRanges;
                return new LeafBucketCollectorBase(sub, values){

                    @Override
                    public void collect(int doc, long bucket) throws IOException {
                        if (singleton.advanceExact(doc)) {
                            this.collect(sub, doc, singleton.doubleValue(), bucket, 0);
                        }
                    }
                };
            }
            ++this.nonsingletonRanges;
            return new LeafBucketCollectorBase(sub, values){

                @Override
                public void collect(int doc, long bucket) throws IOException {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        int lo = 0;
                        for (int i = 0; i < valuesCount; ++i) {
                            double value = values.nextValue();
                            lo = this.collect(sub, doc, value, bucket, lo);
                        }
                    }
                }
            };
        }

        protected abstract int collect(LeafBucketCollector var1, int var2, double var3, long var5, int var7) throws IOException;
    }

    public static class Unmapped<R extends Range>
    extends NonCollectingAggregator {
        private final R[] ranges;
        private final boolean keyed;
        private final InternalRange.Factory factory;
        private final DocValueFormat format;

        public Unmapped(String name, AggregatorFactories factories, R[] ranges, boolean keyed, DocValueFormat format, AggregationContext context, Aggregator parent, InternalRange.Factory factory, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
            this.ranges = ranges;
            this.keyed = keyed;
            this.format = format;
            this.factory = factory;
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            InternalAggregations subAggs = this.buildEmptySubAggregations();
            ArrayList buckets = new ArrayList(this.ranges.length);
            for (R range : this.ranges) {
                buckets.add(this.factory.createBucket(((Range)range).key, ((Range)range).originalFrom, ((Range)range).originalTo, 0L, subAggs, this.keyed, this.format));
            }
            return this.factory.create(this.name, buckets, this.format, this.keyed, this.metadata());
        }
    }
}

