/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.comparators.LongComparator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RoaringDocIdSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.lucene.queries.SearchAfterSortedDocQuery;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.GlobalOrdinalValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.InternalComposite;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.RoundingValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.histogram.SizedBucketAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.searchafter.SearchAfterBuilder;
import org.elasticsearch.search.sort.SortAndFormats;

public final class CompositeAggregator
extends BucketsAggregator
implements SizedBucketAggregator {
    private static final Logger logger = LogManager.getLogger(CompositeAggregator.class);
    private final int size;
    private final List<String> sourceNames;
    private final int[] reverseMuls;
    private final MissingOrder[] missingOrders;
    private final List<DocValueFormat> formats;
    private final CompositeKey rawAfterKey;
    private final CompositeValuesSourceConfig[] sourceConfigs;
    private final SingleDimensionValuesSource<?>[] sources;
    private final CompositeValuesCollectorQueue queue;
    private final DateHistogramValuesSource[] innerSizedBucketAggregators;
    private final List<Entry> entries = new ArrayList<Entry>();
    private AggregationExecutionContext currentAggCtx;
    private RoaringDocIdSet.Builder docIdSetBuilder;
    private BucketCollector deferredCollectors;
    private boolean earlyTerminated;

    CompositeAggregator(String name, AggregatorFactories factories, AggregationContext aggCtx, Aggregator parent, Map<String, Object> metadata, int size, CompositeValuesSourceConfig[] sourceConfigs, CompositeKey rawAfterKey) throws IOException {
        super(name, factories, aggCtx, parent, CardinalityUpperBound.MANY, metadata);
        this.size = size;
        this.sourceNames = Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::name).toList();
        this.reverseMuls = Arrays.stream(sourceConfigs).mapToInt(CompositeValuesSourceConfig::reverseMul).toArray();
        this.missingOrders = (MissingOrder[])Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::missingOrder).toArray(MissingOrder[]::new);
        this.formats = Arrays.stream(sourceConfigs).map(CompositeValuesSourceConfig::format).toList();
        this.sources = new SingleDimensionValuesSource[sourceConfigs.length];
        int bucketLimit = aggCtx.maxBuckets();
        if (size > bucketLimit) {
            logger.warn("Too many buckets (max [{}], count [{}])", new Object[]{bucketLimit, size});
            throw new MultiBucketConsumerService.TooManyBucketsException("Trying to create too many buckets. Must be less than or equal to: [" + bucketLimit + "] but was [" + size + "]. This limit can be set by changing the [" + MultiBucketConsumerService.MAX_BUCKET_SETTING.getKey() + "] cluster level setting.", bucketLimit);
        }
        this.sourceConfigs = sourceConfigs;
        ArrayList<DateHistogramValuesSource> dateHistogramValuesSources = new ArrayList<DateHistogramValuesSource>();
        for (int i = 0; i < sourceConfigs.length; ++i) {
            this.sources[i] = sourceConfigs[i].createValuesSource(aggCtx.bigArrays(), aggCtx.searcher().getIndexReader(), size, x$0 -> this.addRequestCircuitBreakerBytes(x$0));
            if (!(this.sources[i] instanceof DateHistogramValuesSource)) continue;
            dateHistogramValuesSources.add((DateHistogramValuesSource)this.sources[i]);
        }
        this.innerSizedBucketAggregators = dateHistogramValuesSources.toArray(new DateHistogramValuesSource[0]);
        this.queue = new CompositeValuesCollectorQueue(aggCtx.bigArrays(), this.sources, size, aggCtx.searcher().getIndexReader());
        if (rawAfterKey != null) {
            try {
                this.queue.setAfterKey(rawAfterKey);
            }
            catch (IllegalArgumentException ex) {
                throw new ElasticsearchParseException("Cannot set after key in the composite aggregation [" + name + "] - " + ex.getMessage(), (Throwable)ex, new Object[0]);
            }
        }
        this.rawAfterKey = rawAfterKey;
    }

    @Override
    protected void doClose() {
        try {
            Releasables.close((Releasable)this.queue);
        }
        finally {
            if (this.sources != null) {
                Releasables.close(this.sources);
            }
        }
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.queue.mayDynamicallyPrune()) {
            return super.scoreMode().needsScores() ? ScoreMode.TOP_DOCS_WITH_SCORES : ScoreMode.TOP_DOCS;
        }
        return super.scoreMode();
    }

    @Override
    protected void doPreCollection() throws IOException {
        this.deferredCollectors = MultiBucketCollector.wrap(false, Arrays.asList(this.subAggregators));
        this.collectableSubAggregators = BucketCollector.NO_OP_BUCKET_COLLECTOR;
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.finishLeaf();
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        assert (owningBucketOrds.length == 1 && owningBucketOrds[0] == 0L);
        if (this.deferredCollectors != NO_OP_BUCKET_COLLECTOR) {
            this.runDeferredCollections();
        }
        int num = Math.min(this.size, (int)this.queue.size());
        InternalComposite.InternalBucket[] buckets = new InternalComposite.InternalBucket[num];
        long[] bucketOrdsToCollect = new long[(int)this.queue.size()];
        int i = 0;
        while ((long)i < this.queue.size()) {
            bucketOrdsToCollect[i] = i;
            ++i;
        }
        IntFunction<InternalAggregations> subAggsForBuckets = this.buildSubAggsForBuckets(bucketOrdsToCollect);
        while (this.queue.size() > 0L) {
            int slot = (Integer)this.queue.pop();
            CompositeKey key = this.queue.toCompositeKey(slot);
            InternalAggregations aggs = subAggsForBuckets.apply(slot);
            long docCount = this.queue.getDocCount(slot);
            buckets[(int)this.queue.size()] = new InternalComposite.InternalBucket(this.sourceNames, this.formats, key, this.reverseMuls, this.missingOrders, docCount, aggs);
        }
        CompositeKey lastBucket = num > 0 ? buckets[num - 1].getRawKey() : null;
        return new InternalAggregation[]{new InternalComposite(this.name, this.size, this.sourceNames, this.formats, Arrays.asList(buckets), lastBucket, this.reverseMuls, this.missingOrders, this.earlyTerminated, this.metadata())};
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalComposite(this.name, this.size, this.sourceNames, this.formats, Collections.emptyList(), null, this.reverseMuls, this.missingOrders, false, this.metadata());
    }

    private void finishLeaf() {
        if (this.currentAggCtx != null) {
            RoaringDocIdSet docIdSet = this.docIdSetBuilder.build();
            this.entries.add(new Entry(this.currentAggCtx, docIdSet));
            this.currentAggCtx = null;
            this.docIdSetBuilder = null;
        }
    }

    private static boolean isMaybeMultivalued(LeafReaderContext context, SortField sortField) throws IOException {
        SortField.Type type = IndexSortConfig.getSortFieldType(sortField);
        return switch (type) {
            case SortField.Type.STRING -> {
                SortedSetDocValues v1 = context.reader().getSortedSetDocValues(sortField.getField());
                if (v1 != null && DocValues.unwrapSingleton(v1) == null) {
                    yield true;
                }
                yield false;
            }
            case SortField.Type.DOUBLE, SortField.Type.FLOAT, SortField.Type.LONG, SortField.Type.INT -> {
                SortedNumericDocValues v2 = context.reader().getSortedNumericDocValues(sortField.getField());
                if (v2 != null && DocValues.unwrapSingleton(v2) == null) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private Sort buildIndexSortPrefix(LeafReaderContext context) throws IOException {
        Sort indexSort = context.reader().getMetaData().getSort();
        if (indexSort == null) {
            return null;
        }
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        int end = Math.min(indexSort.getSort().length, this.sourceConfigs.length);
        for (int i = 0; i < end; ++i) {
            CompositeValuesSourceConfig sourceConfig = this.sourceConfigs[i];
            SingleDimensionValuesSource<?> source = this.sources[i];
            SortField indexSortField = indexSort.getSort()[i];
            if (source.fieldType == null || source.missingBucket || !indexSortField.getField().equals(source.fieldType.name()) || CompositeAggregator.isMaybeMultivalued(context, indexSortField) || sourceConfig.hasScript()) break;
            if (indexSortField.getReverse() != (source.reverseMul == -1)) {
                if (i != 0) break;
                return new Sort(indexSortField);
            }
            sortFields.add(indexSortField);
            if (sourceConfig.valuesSource() instanceof RoundingValuesSource) break;
        }
        return sortFields.isEmpty() ? null : new Sort(sortFields.toArray(new SortField[0]));
    }

    private int computeSortPrefixLen(Sort indexSortPrefix) {
        if (indexSortPrefix == null) {
            return 0;
        }
        if (indexSortPrefix.getSort()[0].getReverse() != (this.sources[0].reverseMul == -1)) {
            assert (indexSortPrefix.getSort().length == 1);
            return -1;
        }
        return indexSortPrefix.getSort().length;
    }

    private Sort applySortFieldRounding(Sort sort) {
        SortField[] sortFields = new SortField[sort.getSort().length];
        for (int i = 0; i < sort.getSort().length; ++i) {
            if (this.sourceConfigs[i].valuesSource() instanceof RoundingValuesSource) {
                final LongUnaryOperator round = ((RoundingValuesSource)this.sourceConfigs[i].valuesSource())::round;
                final SortedNumericSortField delegate = (SortedNumericSortField)sort.getSort()[i];
                sortFields[i] = new SortedNumericSortField(delegate.getField(), delegate.getNumericType(), delegate.getReverse()){

                    @Override
                    public boolean equals(Object obj) {
                        return delegate.equals(obj);
                    }

                    @Override
                    public int hashCode() {
                        return delegate.hashCode();
                    }

                    @Override
                    public FieldComparator<?> getComparator(int numHits, Pruning enableSkipping) {
                        return new LongComparator(1, delegate.getField(), (Long)this.missingValue, delegate.getReverse(), Pruning.NONE){

                            @Override
                            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                                return new LongComparator.LongLeafComparator(context){

                                    @Override
                                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                                        final NumericDocValues dvs = SortedNumericSelector.wrap(DocValues.getSortedNumeric(context.reader(), field), delegate.getSelector(), delegate.getNumericType());
                                        return new NumericDocValues(){

                                            @Override
                                            public long longValue() throws IOException {
                                                return round.applyAsLong(dvs.longValue());
                                            }

                                            @Override
                                            public boolean advanceExact(int target) throws IOException {
                                                return dvs.advanceExact(target);
                                            }

                                            @Override
                                            public int docID() {
                                                return dvs.docID();
                                            }

                                            @Override
                                            public int nextDoc() throws IOException {
                                                return dvs.nextDoc();
                                            }

                                            @Override
                                            public int advance(int target) throws IOException {
                                                return dvs.advance(target);
                                            }

                                            @Override
                                            public long cost() {
                                                return dvs.cost();
                                            }
                                        };
                                    }
                                };
                            }
                        };
                    }
                };
                continue;
            }
            sortFields[i] = sort.getSort()[i];
        }
        return new Sort(sortFields);
    }

    private void processLeafFromQuery(LeafReaderContext ctx, Sort indexSortPrefix) throws IOException {
        DocValueFormat[] formats = new DocValueFormat[indexSortPrefix.getSort().length];
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = this.sources[i].format;
        }
        FieldDoc fieldDoc = SearchAfterBuilder.buildFieldDoc(new SortAndFormats(indexSortPrefix, formats), Arrays.copyOfRange(this.rawAfterKey.values(), 0, formats.length), null);
        if (indexSortPrefix.getSort().length < this.sources.length) {
            fieldDoc.doc = -1;
        }
        BooleanQuery newQuery = new BooleanQuery.Builder().add(this.topLevelQuery(), BooleanClause.Occur.MUST).add(new SearchAfterSortedDocQuery(this.applySortFieldRounding(indexSortPrefix), fieldDoc), BooleanClause.Occur.FILTER).build();
        Weight weight = this.searcher().createWeight(this.searcher().rewrite(newQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer scorer = weight.scorer(ctx);
        if (scorer != null) {
            DocIdSetIterator docIt = scorer.iterator();
            LeafBucketCollector inner = this.queue.getLeafCollector(ctx, this.getFirstPassCollector(this.docIdSetBuilder, indexSortPrefix.getSort().length));
            inner.setScorer(scorer);
            Bits liveDocs = ctx.reader().getLiveDocs();
            while (docIt.nextDoc() != Integer.MAX_VALUE) {
                if (liveDocs != null && !liveDocs.get(docIt.docID())) continue;
                inner.collect(docIt.docID());
            }
        }
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        LeafBucketCollector inner;
        SortedDocsProducer sortedDocsProducer;
        this.finishLeaf();
        boolean fillDocIdSet = this.deferredCollectors != NO_OP_BUCKET_COLLECTOR;
        Sort indexSortPrefix = this.buildIndexSortPrefix(aggCtx.getLeafReaderContext());
        int sortPrefixLen = this.computeSortPrefixLen(indexSortPrefix);
        SortedDocsProducer sortedDocsProducer2 = sortedDocsProducer = sortPrefixLen == 0 && this.parent == null ? this.sources[0].createSortedDocsProducerOrNull(aggCtx.getLeafReaderContext().reader(), this.topLevelQuery()) : null;
        if (sortedDocsProducer != null) {
            DocIdSet docIdSet = sortedDocsProducer.processLeaf(this.topLevelQuery(), this.queue, aggCtx.getLeafReaderContext(), fillDocIdSet);
            if (fillDocIdSet) {
                this.entries.add(new Entry(aggCtx, docIdSet));
            }
            this.earlyTerminated = true;
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        if (fillDocIdSet) {
            this.currentAggCtx = aggCtx;
            this.docIdSetBuilder = new RoaringDocIdSet.Builder(aggCtx.getLeafReaderContext().reader().maxDoc());
        }
        if (this.rawAfterKey != null && sortPrefixLen > 0) {
            try {
                this.processLeafFromQuery(aggCtx.getLeafReaderContext(), indexSortPrefix);
            }
            catch (CollectionTerminatedException docIdSet) {
                // empty catch block
            }
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        try {
            inner = this.queue.getLeafCollector(aggCtx.getLeafReaderContext(), this.getFirstPassCollector(this.docIdSetBuilder, sortPrefixLen));
        }
        catch (CollectionTerminatedException e) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long zeroBucket) throws IOException {
                assert (zeroBucket == 0L);
                inner.collect(doc);
            }

            @Override
            public DocIdSetIterator competitiveIterator() throws IOException {
                if (CompositeAggregator.this.queue.mayDynamicallyPrune()) {
                    return inner.competitiveIterator();
                }
                return null;
            }
        };
    }

    private LeafBucketCollector getFirstPassCollector(final RoaringDocIdSet.Builder builder, final int indexSortPrefix) {
        return new LeafBucketCollector(){
            int lastDoc = -1;

            @Override
            public void collect(int doc, long bucket) throws IOException {
                try {
                    int docCount = CompositeAggregator.this.docCountProvider.getDocCount(doc);
                    if (CompositeAggregator.this.queue.addIfCompetitive(indexSortPrefix, docCount) && builder != null && this.lastDoc != doc) {
                        builder.add(doc);
                        this.lastDoc = doc;
                    }
                }
                catch (CollectionTerminatedException exc) {
                    CompositeAggregator.this.earlyTerminated = true;
                    throw exc;
                }
            }
        };
    }

    private void runDeferredCollections() throws IOException {
        boolean needsScores = this.scoreMode().needsScores();
        Weight weight = null;
        if (needsScores) {
            weight = this.searcher().createWeight(this.searcher().rewrite(this.topLevelQuery()), ScoreMode.COMPLETE, 1.0f);
        }
        this.deferredCollectors.preCollection();
        for (Entry entry : this.entries) {
            int docID;
            Scorer scorer;
            DocIdSetIterator docIdSetIterator = entry.docIdSet.iterator();
            if (docIdSetIterator == null) continue;
            LeafBucketCollector subCollector = this.deferredCollectors.getLeafCollector(entry.aggCtx);
            LeafBucketCollector collector = this.queue.getLeafCollector(entry.aggCtx.getLeafReaderContext(), this.getSecondPassCollector(subCollector));
            DocIdSetIterator scorerIt = null;
            if (needsScores && (scorer = weight.scorer(entry.aggCtx.getLeafReaderContext())) != null) {
                scorerIt = scorer.iterator();
                subCollector.setScorer(scorer);
            }
            while ((docID = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                if (needsScores) {
                    assert (scorerIt != null && scorerIt.docID() < docID);
                    scorerIt.advance(docID);
                    assert (scorerIt.docID() == docID);
                }
                collector.collect(docID);
            }
        }
        this.deferredCollectors.postCollection();
    }

    private LeafBucketCollector getSecondPassCollector(final LeafBucketCollector subCollector) {
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long zeroBucket) throws IOException {
                assert (zeroBucket == 0L);
                Integer slot = CompositeAggregator.this.queue.compareCurrent();
                if (slot != null) {
                    subCollector.collect(doc, slot.intValue());
                }
            }
        };
    }

    @Override
    public double bucketSize(long bucket, Rounding.DateTimeUnit unit) {
        if (this.innerSizedBucketAggregators.length != 1) {
            throw AggregationErrors.rateWithoutDateHistogram(this.name());
        }
        return this.innerSizedBucketAggregators[0].bucketSize(bucket, unit);
    }

    @Override
    public double bucketSize(Rounding.DateTimeUnit unit) {
        if (this.innerSizedBucketAggregators.length != 1) {
            throw AggregationErrors.rateWithoutDateHistogram(this.name());
        }
        return this.innerSizedBucketAggregators[0].bucketSize(unit);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        SingleDimensionValuesSource<?> singleDimensionValuesSource = this.sources[0];
        if (singleDimensionValuesSource instanceof GlobalOrdinalValuesSource) {
            GlobalOrdinalValuesSource globalOrdinalValuesSource = (GlobalOrdinalValuesSource)singleDimensionValuesSource;
            globalOrdinalValuesSource.collectDebugInfo(Strings.format("sources.%s", this.sourceConfigs[0].name()), add);
        }
    }

    private record Entry(AggregationExecutionContext aggCtx, DocIdSet docIdSet) {
    }
}

