/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public abstract class Aggregator
extends BucketCollector
implements Releasable {
    public abstract String name();

    public abstract Aggregator parent();

    public abstract Aggregator subAggregator(String var1);

    public final Aggregator resolveSortPathOnValidAgg(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        Aggregator n = this.subAggregator(next.name());
        if (n == null) {
            throw new IllegalArgumentException("The provided aggregation [" + next + "] either does not exist, or is a pipeline aggregation and cannot be used to sort the buckets.");
        }
        if (!path.hasNext()) {
            return n;
        }
        if (next.key() != null) {
            throw new IllegalArgumentException("Key only allowed on last aggregation path element but got [" + next + "]");
        }
        return n.resolveSortPath(path.next(), path);
    }

    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        throw new IllegalArgumentException("Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end. [" + this.name() + "] is not single-bucket.");
    }

    public BucketComparator bucketComparator(String key, SortOrder order) {
        throw new IllegalArgumentException("Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end.");
    }

    public abstract InternalAggregation[] buildAggregations(long[] var1) throws IOException;

    public abstract void releaseAggregations();

    public final InternalAggregation buildTopLevel() throws IOException {
        assert (this.parent() == null);
        return this.buildAggregations(new long[]{0L})[0];
    }

    public abstract InternalAggregation buildEmptyAggregation();

    public void collectDebugInfo(BiConsumer<String, Object> add) {
    }

    public abstract Aggregator[] subAggregators();

    public static enum SubAggCollectionMode implements Writeable
    {
        DEPTH_FIRST(new ParseField("depth_first", new String[0])),
        BREADTH_FIRST(new ParseField("breadth_first", new String[0]));

        public static final ParseField KEY;
        private final ParseField parseField;

        private SubAggCollectionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static SubAggCollectionMode parse(String value, DeprecationHandler deprecationHandler) {
            SubAggCollectionMode[] modes;
            for (SubAggCollectionMode mode : modes = SubAggCollectionMode.values()) {
                if (!mode.parseField.match(value, deprecationHandler)) continue;
                return mode;
            }
            throw new ElasticsearchParseException("no [{}] found for value [{}]", KEY.getPreferredName(), value);
        }

        public static SubAggCollectionMode readFromStream(StreamInput in) throws IOException {
            return in.readEnum(SubAggCollectionMode.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        static {
            KEY = new ParseField("collect_mode", new String[0]);
        }
    }

    @FunctionalInterface
    public static interface BucketComparator {
        public int compare(long var1, long var3);
    }

    @FunctionalInterface
    public static interface Parser {
        public AggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

