/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public final class SearchHits
implements Writeable,
ChunkedToXContent,
RefCounted,
Iterable<SearchHit> {
    public static final SearchHit[] EMPTY = new SearchHit[0];
    public static final SearchHits EMPTY_WITH_TOTAL_HITS = SearchHits.empty(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), 0.0f);
    public static final SearchHits EMPTY_WITHOUT_TOTAL_HITS = SearchHits.empty(null, 0.0f);
    private final SearchHit[] hits;
    private final TotalHits totalHits;
    private final float maxScore;
    @Nullable
    private final SortField[] sortFields;
    @Nullable
    private final String collapseField;
    @Nullable
    private final Object[] collapseValues;
    private final RefCounted refCounted;

    public static SearchHits empty(@Nullable TotalHits totalHits, float maxScore) {
        return new SearchHits(EMPTY, totalHits, maxScore);
    }

    public SearchHits(SearchHit[] hits, @Nullable TotalHits totalHits, float maxScore) {
        this(hits, totalHits, maxScore, null, null, null);
    }

    public SearchHits(SearchHit[] hits, @Nullable TotalHits totalHits, float maxScore, @Nullable SortField[] sortFields, @Nullable String collapseField, @Nullable Object[] collapseValues) {
        this(hits, totalHits, maxScore, sortFields, collapseField, collapseValues, hits.length == 0 ? ALWAYS_REFERENCED : LeakTracker.wrap(new SimpleRefCounted()));
    }

    private SearchHits(SearchHit[] hits, @Nullable TotalHits totalHits, float maxScore, @Nullable SortField[] sortFields, @Nullable String collapseField, @Nullable Object[] collapseValues, RefCounted refCounted) {
        this.hits = hits;
        this.totalHits = totalHits;
        this.maxScore = maxScore;
        this.sortFields = sortFields;
        this.collapseField = collapseField;
        this.collapseValues = collapseValues;
        this.refCounted = refCounted;
    }

    public static SearchHits unpooled(SearchHit[] hits, @Nullable TotalHits totalHits, float maxScore) {
        return SearchHits.unpooled(hits, totalHits, maxScore, null, null, null);
    }

    public static SearchHits unpooled(SearchHit[] hits, @Nullable TotalHits totalHits, float maxScore, @Nullable SortField[] sortFields, @Nullable String collapseField, @Nullable Object[] collapseValues) {
        assert (SearchHits.assertUnpooled(hits));
        return new SearchHits(hits, totalHits, maxScore, sortFields, collapseField, collapseValues, ALWAYS_REFERENCED);
    }

    private static boolean assertUnpooled(SearchHit[] searchHits) {
        for (SearchHit searchHit : searchHits) {
            assert (!searchHit.isPooled()) : "hit was pooled [" + searchHit + "]";
        }
        return true;
    }

    public static SearchHits readFrom(StreamInput in, boolean pooled) throws IOException {
        SearchHit[] hits;
        TotalHits totalHits = in.readBoolean() ? Lucene.readTotalHits(in) : null;
        float maxScore = in.readFloat();
        int size = in.readVInt();
        boolean isPooled = false;
        if (size == 0) {
            hits = EMPTY;
        } else {
            hits = new SearchHit[size];
            for (int i = 0; i < hits.length; ++i) {
                SearchHit hit;
                hits[i] = hit = SearchHit.readFrom(in, pooled);
                isPooled = isPooled || hit.isPooled();
            }
        }
        SortField[] sortFields = in.readOptionalArray(Lucene::readSortField, SortField[]::new);
        String collapseField = in.readOptionalString();
        Object[] collapseValues = in.readOptionalArray(Lucene::readSortValue, Object[]::new);
        if (isPooled) {
            return new SearchHits(hits, totalHits, maxScore, sortFields, collapseField, collapseValues);
        }
        return SearchHits.unpooled(hits, totalHits, maxScore, sortFields, collapseField, collapseValues);
    }

    public boolean isPooled() {
        return this.refCounted != ALWAYS_REFERENCED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.hasReferences());
        boolean hasTotalHits = this.totalHits != null;
        out.writeBoolean(hasTotalHits);
        if (hasTotalHits) {
            Lucene.writeTotalHits(out, this.totalHits);
        }
        out.writeFloat(this.maxScore);
        out.writeArray(this.hits);
        out.writeOptionalArray(Lucene::writeSortField, this.sortFields);
        out.writeOptionalString(this.collapseField);
        out.writeOptionalArray(Lucene::writeSortValue, this.collapseValues);
    }

    @Nullable
    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }

    public SearchHit[] getHits() {
        assert (this.hasReferences());
        return this.hits;
    }

    public SearchHit getAt(int position) {
        assert (this.hasReferences());
        return this.hits[position];
    }

    @Nullable
    public SortField[] getSortFields() {
        return this.sortFields;
    }

    @Nullable
    public String getCollapseField() {
        return this.collapseField;
    }

    @Nullable
    public Object[] getCollapseValues() {
        return this.collapseValues;
    }

    @Override
    public Iterator<SearchHit> iterator() {
        assert (this.hasReferences());
        return Iterators.forArray(this.getHits());
    }

    @Override
    public void incRef() {
        this.refCounted.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        if (this.refCounted.decRef()) {
            this.deallocate();
            return true;
        }
        return false;
    }

    private void deallocate() {
        for (int i = 0; i < this.hits.length; ++i) {
            assert (this.hits[i] != null);
            this.hits[i].decRef();
            this.hits[i] = null;
        }
    }

    @Override
    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }

    public SearchHits asUnpooled() {
        assert (this.hasReferences());
        if (this.refCounted == ALWAYS_REFERENCED) {
            return this;
        }
        SearchHit[] unpooledHits = new SearchHit[this.hits.length];
        for (int i = 0; i < this.hits.length; ++i) {
            unpooledHits[i] = this.hits[i].asUnpooled();
        }
        return SearchHits.unpooled(unpooledHits, this.totalHits, this.maxScore, this.sortFields, this.collapseField, this.collapseValues);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        assert (this.hasReferences());
        return Iterators.concat(Iterators.single((b, p) -> b.startObject("hits")), Iterators.single((b, p) -> {
            boolean totalHitAsInt = params.paramAsBoolean("rest_total_hits_as_int", false);
            if (totalHitAsInt) {
                long total = this.totalHits == null ? -1L : this.totalHits.value;
                b.field("total", total);
            } else if (this.totalHits != null) {
                b.startObject("total");
                b.field("value", this.totalHits.value);
                b.field("relation", this.totalHits.relation == TotalHits.Relation.EQUAL_TO ? "eq" : "gte");
                b.endObject();
            }
            return b;
        }), Iterators.single((b, p) -> {
            if (Float.isNaN(this.maxScore)) {
                b.nullField("max_score");
            } else {
                b.field("max_score", this.maxScore);
            }
            return b;
        }), ChunkedToXContentHelper.array("hits", Iterators.forArray(this.hits)), ChunkedToXContentHelper.endObject());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchHits other = (SearchHits)obj;
        return Objects.equals(this.totalHits, other.totalHits) && Objects.equals(Float.valueOf(this.maxScore), Float.valueOf(other.maxScore)) && Arrays.equals(this.hits, other.hits) && Arrays.equals(this.sortFields, other.sortFields) && Objects.equals(this.collapseField, other.collapseField) && Arrays.equals(this.collapseValues, other.collapseValues);
    }

    public int hashCode() {
        return Objects.hash(this.totalHits, Float.valueOf(this.maxScore), Arrays.hashCode(this.hits), Arrays.hashCode(this.sortFields), this.collapseField, Arrays.hashCode(this.collapseValues));
    }

    public static TotalHits parseTotalHitsFragment(XContentParser parser) throws IOException {
        XContentParser.Token token;
        long value = -1L;
        TotalHits.Relation relation = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("value".equals(currentFieldName)) {
                    value = parser.longValue();
                    continue;
                }
                if (!"relation".equals(currentFieldName)) continue;
                relation = SearchHits.parseRelation(parser.text());
                continue;
            }
            parser.skipChildren();
        }
        return new TotalHits(value, relation);
    }

    private static TotalHits.Relation parseRelation(String relation) {
        if ("gte".equals(relation)) {
            return TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }
        if ("eq".equals(relation)) {
            return TotalHits.Relation.EQUAL_TO;
        }
        throw new IllegalArgumentException("invalid total hits relation: " + relation);
    }

    public static final class Fields {
        public static final String HITS = "hits";
        public static final String TOTAL = "total";
        public static final String MAX_SCORE = "max_score";
    }
}

