/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.script.mustache.CustomMustacheFactory;
import org.elasticsearch.script.mustache.MustacheInvalidParameterException;

public final class MustacheScriptEngine
implements ScriptEngine {
    public static final String DETECT_MISSING_PARAMS_OPTION = "detect_missing_params";
    private static final Logger logger = LogManager.getLogger(MustacheScriptEngine.class);
    public static final String NAME = "mustache";

    public <T> T compile(String templateName, String templateSource, ScriptContext<T> context, Map<String, String> options) {
        if (!context.instanceClazz.equals(TemplateScript.class)) {
            throw new IllegalArgumentException("mustache engine does not know how to handle context [" + context.name + "]");
        }
        CustomMustacheFactory factory = MustacheScriptEngine.createMustacheFactory(options);
        StringReader reader = new StringReader(templateSource);
        try {
            Mustache template = factory.compile(reader, "query-template");
            TemplateScript.Factory compiled = params -> new MustacheExecutableScript(template, params);
            return (T)context.factoryClazz.cast(compiled);
        }
        catch (MustacheException ex) {
            throw new ScriptException(ex.getMessage(), (Throwable)ex, Collections.emptyList(), templateSource, NAME);
        }
    }

    @Override
    public Set<ScriptContext<?>> getSupportedContexts() {
        return Set.of(TemplateScript.CONTEXT, TemplateScript.INGEST_CONTEXT);
    }

    private static CustomMustacheFactory createMustacheFactory(Map<String, String> options) {
        CustomMustacheFactory.Builder builder = CustomMustacheFactory.builder();
        if (options == null || options.isEmpty()) {
            return builder.build();
        }
        if (options.containsKey("content_type")) {
            builder.mediaType(options.get("content_type"));
        }
        if (options.containsKey(DETECT_MISSING_PARAMS_OPTION)) {
            builder.detectMissingParams(Boolean.valueOf(options.get(DETECT_MISSING_PARAMS_OPTION)));
        }
        return builder.build();
    }

    @Override
    public String getType() {
        return NAME;
    }

    private class MustacheExecutableScript
    extends TemplateScript {
        private Mustache template;
        private Map<String, Object> params;

        MustacheExecutableScript(Mustache template, Map<String, Object> params) {
            super(params);
            this.template = template;
            this.params = params;
        }

        @Override
        public String execute() {
            StringWriter writer = new StringWriter();
            try {
                this.template.execute((Writer)writer, this.params);
            }
            catch (Exception e) {
                if (this.shouldLogException(e)) {
                    logger.error(() -> Strings.format("Error running %s", this.template), (Throwable)e);
                }
                throw new GeneralScriptException("Error running " + this.template, e);
            }
            return writer.toString();
        }

        public boolean shouldLogException(Throwable e) {
            return e.getCause() != null && !(e.getCause() instanceof MustacheInvalidParameterException);
        }
    }
}

