/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.script.field.vectors.DenseVector;

public class KnnDenseVector
implements DenseVector {
    protected final float[] docVector;
    private float magnitude;

    public KnnDenseVector(float[] docVector) {
        this.docVector = docVector;
        this.magnitude = Float.NaN;
    }

    public KnnDenseVector(float[] docVector, float magnitude) {
        this.docVector = docVector;
        this.magnitude = magnitude;
    }

    @Override
    public float[] getVector() {
        return Arrays.copyOf(this.docVector, this.docVector.length);
    }

    @Override
    public float getMagnitude() {
        if (Float.isNaN(this.magnitude)) {
            this.magnitude = DenseVector.getMagnitude(this.docVector);
        }
        return this.magnitude;
    }

    @Override
    public int dotProduct(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double dotProduct(float[] queryVector)] instead");
    }

    @Override
    public double dotProduct(float[] queryVector) {
        return VectorUtil.dotProduct(this.docVector, queryVector);
    }

    @Override
    public double dotProduct(List<Number> queryVector) {
        double result = 0.0;
        for (int i = 0; i < this.docVector.length; ++i) {
            result += (double)(this.docVector[i] * queryVector.get(i).floatValue());
        }
        return result;
    }

    @Override
    public int l1Norm(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double l1Norm(float[] queryVector)] instead");
    }

    @Override
    public double l1Norm(float[] queryVector) {
        double result = 0.0;
        for (int i = 0; i < this.docVector.length; ++i) {
            result += (double)Math.abs(this.docVector[i] - queryVector[i]);
        }
        return result;
    }

    @Override
    public double l1Norm(List<Number> queryVector) {
        double result = 0.0;
        for (int i = 0; i < this.docVector.length; ++i) {
            result += (double)Math.abs(this.docVector[i] - queryVector.get(i).floatValue());
        }
        return result;
    }

    @Override
    public double l2Norm(byte[] queryVector) {
        throw new UnsupportedOperationException("use [double l2Norm(float[] queryVector)] instead");
    }

    @Override
    public double l2Norm(float[] queryVector) {
        return Math.sqrt(VectorUtil.squareDistance(this.docVector, queryVector));
    }

    @Override
    public double l2Norm(List<Number> queryVector) {
        double l2norm = 0.0;
        for (int i = 0; i < this.docVector.length; ++i) {
            double diff = this.docVector[i] - queryVector.get(i).floatValue();
            l2norm += diff * diff;
        }
        return Math.sqrt(l2norm);
    }

    @Override
    public double cosineSimilarity(byte[] queryVector, float qvMagnitude) {
        throw new UnsupportedOperationException("use [double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector)] instead");
    }

    @Override
    public double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector) {
        if (normalizeQueryVector) {
            return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
        }
        return this.dotProduct(queryVector) / (double)this.getMagnitude();
    }

    @Override
    public double cosineSimilarity(List<Number> queryVector) {
        return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.docVector.length;
    }

    @Override
    public int size() {
        return 1;
    }
}

