/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Arrays;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongSupplier;
import org.elasticsearch.script.TimeSeries;

public class TimeSeriesCounter {
    public static final int SECOND = 1;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    protected LongAdder adder = new LongAdder();
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    protected Counter fiveMinutes = new Counter(15L, 300L);
    protected Counter fifteenMinutes = new Counter(90L, 900L);
    protected Counter twentyFourHours = new Counter(900L, 86400L);
    protected final LongSupplier timeProvider;

    public TimeSeriesCounter(LongSupplier timeProvider) {
        this.timeProvider = timeProvider;
    }

    public void inc() {
        long now = this.now();
        this.adder.increment();
        this.lock.writeLock().lock();
        try {
            if (now < this.twentyFourHours.earliestTimeInCounter()) {
                this.fiveMinutes.reset(now);
                this.fifteenMinutes.reset(now);
                this.twentyFourHours.reset(now);
            } else {
                this.fiveMinutes.inc(now);
                this.fifteenMinutes.inc(now);
                this.twentyFourHours.inc(now);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSeries timeSeries() {
        long now = this.now();
        this.lock.readLock().lock();
        try {
            TimeSeries timeSeries = new TimeSeries(this.fiveMinutes.sum(now), this.fifteenMinutes.sum(now), this.twentyFourHours.sum(now), this.count());
            return timeSeries;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected long now() {
        long t = this.timeProvider.getAsLong();
        t = t < 0L ? 0L : (t /= 1000L);
        return t;
    }

    public long count() {
        long total = this.adder.sum();
        return total < 0L ? 0L : total;
    }

    public static class Counter {
        protected final long resolution;
        protected final long duration;
        protected final long[] buckets;
        protected long startOfCurrentEpoch;
        protected int curBucket = 0;

        public Counter(long resolution, long duration) {
            if (resolution <= 0L) {
                throw new IllegalArgumentException("resolution [" + resolution + "] must be greater than zero");
            }
            if (duration <= 0L) {
                throw new IllegalArgumentException("duration [" + duration + "] must be greater than zero");
            }
            if (duration % resolution != 0L) {
                throw new IllegalArgumentException("duration [" + duration + "] must divisible by resolution [" + resolution + "]");
            }
            this.resolution = resolution;
            this.duration = duration;
            this.buckets = new long[(int)(duration / resolution)];
            this.startOfCurrentEpoch = 0L;
            assert (this.buckets.length > 0);
        }

        public void inc(long now) {
            if (now < this.nextBucketStartTime()) {
                int n = this.curBucket;
                this.buckets[n] = this.buckets[n] + 1L;
            } else if (now >= this.counterExpired()) {
                this.reset(now);
            } else {
                int dstBucket = this.bucket(now);
                int i = this.nextBucket(this.curBucket);
                while (i != dstBucket) {
                    this.buckets[i] = 0L;
                    i = this.nextBucket(i);
                }
                this.curBucket = dstBucket;
                this.buckets[this.curBucket] = 1L;
                if (now >= this.nextEpoch()) {
                    this.startOfCurrentEpoch = this.epoch(now);
                }
            }
        }

        public long sum(long now) {
            long start = now - this.duration;
            if (start >= this.nextBucketStartTime()) {
                return 0L;
            }
            if (start < this.earliestTimeInCounter()) {
                start = this.earliestTimeInCounter();
            }
            long total = 0L;
            int i = this.bucket(start);
            while (i != this.curBucket) {
                total += this.buckets[i];
                i = this.nextBucket(i);
            }
            return total + this.buckets[this.curBucket];
        }

        void reset(long now) {
            Arrays.fill(this.buckets, 0L);
            this.startOfCurrentEpoch = this.epoch(now);
            this.curBucket = this.bucket(now);
            this.buckets[this.curBucket] = 1L;
        }

        long epoch(long t) {
            return t / this.duration * this.duration;
        }

        long nextEpoch() {
            return this.startOfCurrentEpoch + this.duration;
        }

        long earliestTimeInCounter() {
            long time = this.nextBucketStartTime() - this.duration;
            return time <= 0L ? 0L : time;
        }

        long counterExpired() {
            return this.startOfCurrentEpoch + (long)this.curBucket * this.resolution + this.duration;
        }

        int bucket(long t) {
            return (int)(t / this.resolution) % this.buckets.length;
        }

        int nextBucket(int i) {
            return (i + 1) % this.buckets.length;
        }

        long nextBucketStartTime() {
            return this.startOfCurrentEpoch + (long)(this.curBucket + 1) * this.resolution;
        }
    }
}

