/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.action.admin.cluster.settings.ClusterGetSettingsAction;
import org.elasticsearch.action.admin.cluster.settings.RestClusterGetSettingsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestClusterGetSettingsAction
extends BaseRestHandler {
    public static final NodeFeature SUPPORTS_GET_SETTINGS_ACTION = new NodeFeature("rest.get_settings_action");
    private final Settings settings;
    private final ClusterSettings clusterSettings;
    private final SettingsFilter settingsFilter;
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public RestClusterGetSettingsAction(Settings settings, ClusterSettings clusterSettings, SettingsFilter settingsFilter, Predicate<NodeFeature> clusterSupportsFeature) {
        this.settings = settings;
        this.clusterSettings = clusterSettings;
        this.settingsFilter = settingsFilter;
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/settings"));
    }

    @Override
    public String getName() {
        return "cluster_get_settings_action";
    }

    private static void setUpRequestParams(MasterNodeReadRequest<?> clusterRequest, RestRequest request) {
        clusterRequest.local(request.paramAsBoolean("local", clusterRequest.local()));
        clusterRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterRequest.masterNodeTimeout()));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean renderDefaults = request.paramAsBoolean("include_defaults", false);
        if (!this.clusterSupportsFeature.test(SUPPORTS_GET_SETTINGS_ACTION)) {
            return this.prepareLegacyRequest(request, client, renderDefaults);
        }
        ClusterGetSettingsAction.Request clusterSettingsRequest = new ClusterGetSettingsAction.Request();
        RestClusterGetSettingsAction.setUpRequestParams(clusterSettingsRequest, request);
        return channel -> client.execute(ClusterGetSettingsAction.INSTANCE, clusterSettingsRequest, new RestToXContentListener<RestClusterGetSettingsResponse>((RestChannel)channel).map(r -> RestClusterGetSettingsAction.response(r, renderDefaults, this.settingsFilter, this.clusterSettings, this.settings)));
    }

    private BaseRestHandler.RestChannelConsumer prepareLegacyRequest(RestRequest request, NodeClient client, boolean renderDefaults) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest().routingTable(false).nodes(false);
        RestClusterGetSettingsAction.setUpRequestParams(clusterStateRequest, request);
        return channel -> client.admin().cluster().state(clusterStateRequest, new RestToXContentListener<RestClusterGetSettingsResponse>((RestChannel)channel).map(r -> RestClusterGetSettingsAction.response(new ClusterGetSettingsAction.Response(r.getState().metadata().persistentSettings(), r.getState().metadata().transientSettings(), r.getState().metadata().settings()), renderDefaults, this.settingsFilter, this.clusterSettings, this.settings)));
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static RestClusterGetSettingsResponse response(ClusterGetSettingsAction.Response response, boolean renderDefaults, SettingsFilter settingsFilter, ClusterSettings clusterSettings, Settings settings) {
        return new RestClusterGetSettingsResponse(settingsFilter.filter(response.persistentSettings()), settingsFilter.filter(response.transientSettings()), renderDefaults ? settingsFilter.filter(clusterSettings.diff(response.settings(), settings)) : Settings.EMPTY);
    }
}

