/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.toxcontent;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class XContentBuilderWrapper {
    public final XContentBuilder builder;

    public XContentBuilderWrapper(XContentBuilder builder) {
        this.builder = Objects.requireNonNull(builder);
    }

    public XContentBuilderWrapper() {
        XContentBuilder jsonBuilder;
        try {
            jsonBuilder = XContentFactory.jsonBuilder();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        this.builder = jsonBuilder.prettyPrint();
    }

    public void startObject() {
        try {
            this.builder.startObject();
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void startObject(String name) {
        try {
            this.builder.startObject(name);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void endObject() {
        try {
            this.builder.endObject();
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void startArray() {
        try {
            this.builder.startArray();
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void startArray(String name) {
        try {
            this.builder.startArray(name);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void endArray() {
        try {
            this.builder.endArray();
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void field(String name) {
        try {
            this.builder.field(name);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void field(String name, Object value) {
        try {
            if (value instanceof Character) {
                this.builder.field(name, ((Character)value).charValue());
            } else if (value instanceof Pattern) {
                this.builder.field(name, ((Pattern)value).pattern());
            } else {
                this.builder.field(name, value);
            }
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void field(String name, String value) {
        try {
            this.builder.field(name, value);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void field(String name, Class<?> value) {
        this.field(name, value.getName());
    }

    public void field(String name, int value) {
        try {
            this.builder.field(name, value);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void field(String name, boolean value) {
        try {
            this.builder.field(name, value);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void field(String name, List<String> values) {
        try {
            this.builder.field(name, (Collection<String>)values);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public void value(String value) {
        try {
            this.builder.value(value);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public String toString() {
        try {
            this.builder.flush();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        return this.builder.getOutputStream().toString();
    }
}

