/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FsInfo
implements Iterable<Path>,
Writeable,
ToXContentFragment {
    private final long timestamp;
    private final Path[] paths;
    private final IoStats ioStats;
    private final Path total;

    public FsInfo(long timestamp, IoStats ioStats, Path[] paths) {
        this.timestamp = timestamp;
        this.ioStats = ioStats;
        this.paths = paths;
        this.total = this.total();
    }

    public FsInfo(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.ioStats = in.readOptionalWriteable(IoStats::new);
        this.paths = new Path[in.readVInt()];
        for (int i = 0; i < this.paths.length; ++i) {
            this.paths[i] = new Path(in);
        }
        this.total = this.total();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeOptionalWriteable(this.ioStats);
        out.writeArray(this.paths);
    }

    public Path getTotal() {
        return this.total;
    }

    private Path total() {
        Path res = new Path();
        HashSet<String> seenDevices = Sets.newHashSetWithExpectedSize(this.paths.length);
        for (Path subPath : this.paths) {
            if (subPath.mount != null && !seenDevices.add(subPath.mount)) continue;
            res.add(subPath);
        }
        return res;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public IoStats getIoStats() {
        return this.ioStats;
    }

    @Override
    public Iterator<Path> iterator() {
        return Iterators.forArray(this.paths);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("fs");
        builder.field("timestamp", this.timestamp);
        builder.field("total");
        this.total().toXContent(builder, params);
        builder.startArray("data");
        for (Path path : this.paths) {
            path.toXContent(builder, params);
        }
        builder.endArray();
        if (this.ioStats != null) {
            builder.startObject("io_stats");
            this.ioStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class IoStats
    implements Writeable,
    ToXContentFragment {
        private static final String OPERATIONS = "operations";
        private static final String READ_OPERATIONS = "read_operations";
        private static final String WRITE_OPERATIONS = "write_operations";
        private static final String READ_KILOBYTES = "read_kilobytes";
        private static final String WRITE_KILOBYTES = "write_kilobytes";
        private static final String IO_TIMEMS = "io_time_in_millis";
        final DeviceStats[] devicesStats;
        final long totalOperations;
        final long totalReadOperations;
        final long totalWriteOperations;
        final long totalReadKilobytes;
        final long totalWriteKilobytes;
        final long totalIOTimeInMillis;

        public IoStats(DeviceStats[] devicesStats) {
            this.devicesStats = devicesStats;
            long totalOperations = 0L;
            long totalReadOperations = 0L;
            long totalWriteOperations = 0L;
            long totalReadKilobytes = 0L;
            long totalWriteKilobytes = 0L;
            long totalIOTimeInMillis = 0L;
            for (DeviceStats deviceStats : devicesStats) {
                totalOperations += deviceStats.operations() != -1L ? deviceStats.operations() : 0L;
                totalReadOperations += deviceStats.readOperations() != -1L ? deviceStats.readOperations() : 0L;
                totalWriteOperations += deviceStats.writeOperations() != -1L ? deviceStats.writeOperations() : 0L;
                totalReadKilobytes += deviceStats.readKilobytes() != -1L ? deviceStats.readKilobytes() : 0L;
                totalWriteKilobytes += deviceStats.writeKilobytes() != -1L ? deviceStats.writeKilobytes() : 0L;
                totalIOTimeInMillis += deviceStats.ioTimeInMillis() != -1L ? deviceStats.ioTimeInMillis() : 0L;
            }
            this.totalOperations = totalOperations;
            this.totalReadOperations = totalReadOperations;
            this.totalWriteOperations = totalWriteOperations;
            this.totalReadKilobytes = totalReadKilobytes;
            this.totalWriteKilobytes = totalWriteKilobytes;
            this.totalIOTimeInMillis = totalIOTimeInMillis;
        }

        public IoStats(StreamInput in) throws IOException {
            int length = in.readVInt();
            DeviceStats[] devicesStats = new DeviceStats[length];
            for (int i = 0; i < length; ++i) {
                devicesStats[i] = new DeviceStats(in);
            }
            this.devicesStats = devicesStats;
            this.totalOperations = in.readLong();
            this.totalReadOperations = in.readLong();
            this.totalWriteOperations = in.readLong();
            this.totalReadKilobytes = in.readLong();
            this.totalWriteKilobytes = in.readLong();
            this.totalIOTimeInMillis = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.devicesStats.length);
            for (int i = 0; i < this.devicesStats.length; ++i) {
                this.devicesStats[i].writeTo(out);
            }
            out.writeLong(this.totalOperations);
            out.writeLong(this.totalReadOperations);
            out.writeLong(this.totalWriteOperations);
            out.writeLong(this.totalReadKilobytes);
            out.writeLong(this.totalWriteKilobytes);
            out.writeLong(this.totalIOTimeInMillis);
        }

        public DeviceStats[] getDevicesStats() {
            return this.devicesStats;
        }

        public long getTotalOperations() {
            return this.totalOperations;
        }

        public long getTotalReadOperations() {
            return this.totalReadOperations;
        }

        public long getTotalWriteOperations() {
            return this.totalWriteOperations;
        }

        public long getTotalReadKilobytes() {
            return this.totalReadKilobytes;
        }

        public long getTotalWriteKilobytes() {
            return this.totalWriteKilobytes;
        }

        public long getTotalIOTimeMillis() {
            return this.totalIOTimeInMillis;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.devicesStats.length > 0) {
                builder.startArray("devices");
                for (DeviceStats deviceStats : this.devicesStats) {
                    builder.startObject();
                    deviceStats.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.startObject("total");
                builder.field(OPERATIONS, this.totalOperations);
                builder.field(READ_OPERATIONS, this.totalReadOperations);
                builder.field(WRITE_OPERATIONS, this.totalWriteOperations);
                builder.field(READ_KILOBYTES, this.totalReadKilobytes);
                builder.field(WRITE_KILOBYTES, this.totalWriteKilobytes);
                builder.field(IO_TIMEMS, this.totalIOTimeInMillis);
                builder.endObject();
            }
            return builder;
        }
    }

    public static class Path
    implements Writeable,
    ToXContentObject {
        String path;
        String mount;
        String type;
        long total = -1L;
        long free = -1L;
        long available = -1L;

        public Path() {
        }

        public Path(String path, String mount, long total, long free, long available) {
            this.path = path;
            this.mount = mount;
            this.total = total;
            this.free = free;
            this.available = available;
        }

        public Path(StreamInput in) throws IOException {
            this.path = in.readOptionalString();
            this.mount = in.readOptionalString();
            this.type = in.readOptionalString();
            this.total = in.readLong();
            this.free = in.readLong();
            this.available = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.path);
            out.writeOptionalString(this.mount);
            out.writeOptionalString(this.type);
            out.writeLong(this.total);
            out.writeLong(this.free);
            out.writeLong(this.available);
        }

        public String getPath() {
            return this.path;
        }

        public String getMount() {
            return this.mount;
        }

        public String getType() {
            return this.type;
        }

        public ByteSizeValue getTotal() {
            return ByteSizeValue.ofBytes(this.total);
        }

        public ByteSizeValue getFree() {
            return ByteSizeValue.ofBytes(this.free);
        }

        public ByteSizeValue getAvailable() {
            return ByteSizeValue.ofBytes(this.available);
        }

        private static long addLong(long current, long other) {
            if (current == -1L && other == -1L) {
                return 0L;
            }
            if (other == -1L) {
                return current;
            }
            if (current == -1L) {
                return other;
            }
            return current + other;
        }

        public void add(Path path) {
            this.total = FsProbe.adjustForHugeFilesystems(Path.addLong(this.total, path.total));
            this.free = FsProbe.adjustForHugeFilesystems(Path.addLong(this.free, path.free));
            this.available = FsProbe.adjustForHugeFilesystems(Path.addLong(this.available, path.available));
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.path != null) {
                builder.field("path", this.path);
            }
            if (this.mount != null) {
                builder.field("mount", this.mount);
            }
            if (this.type != null) {
                builder.field("type", this.type);
            }
            if (this.total != -1L) {
                builder.humanReadableField("total_in_bytes", "total", this.getTotal());
            }
            if (this.free != -1L) {
                builder.humanReadableField("free_in_bytes", "free", this.getFree());
            }
            if (this.available != -1L) {
                builder.humanReadableField("available_in_bytes", "available", this.getAvailable());
            }
            builder.endObject();
            return builder;
        }

        static final class Fields {
            static final String PATH = "path";
            static final String MOUNT = "mount";
            static final String TYPE = "type";
            static final String TOTAL = "total";
            static final String TOTAL_IN_BYTES = "total_in_bytes";
            static final String FREE = "free";
            static final String FREE_IN_BYTES = "free_in_bytes";
            static final String AVAILABLE = "available";
            static final String AVAILABLE_IN_BYTES = "available_in_bytes";

            Fields() {
            }
        }
    }

    static final class Fields {
        static final String FS = "fs";
        static final String TIMESTAMP = "timestamp";
        static final String DATA = "data";
        static final String TOTAL = "total";
        static final String IO_STATS = "io_stats";

        Fields() {
        }
    }

    public static class DeviceStats
    implements Writeable,
    ToXContentFragment {
        final int majorDeviceNumber;
        final int minorDeviceNumber;
        final String deviceName;
        final long currentReadsCompleted;
        final long previousReadsCompleted;
        final long currentSectorsRead;
        final long previousSectorsRead;
        final long currentWritesCompleted;
        final long previousWritesCompleted;
        final long currentSectorsWritten;
        final long previousSectorsWritten;
        final long currentIOTime;
        final long previousIOTime;

        public DeviceStats(int majorDeviceNumber, int minorDeviceNumber, String deviceName, long currentReadsCompleted, long currentSectorsRead, long currentWritesCompleted, long currentSectorsWritten, long currentIOTime, DeviceStats previousDeviceStats) {
            this(majorDeviceNumber, minorDeviceNumber, deviceName, currentReadsCompleted, previousDeviceStats != null ? previousDeviceStats.currentReadsCompleted : -1L, currentSectorsWritten, previousDeviceStats != null ? previousDeviceStats.currentSectorsWritten : -1L, currentSectorsRead, previousDeviceStats != null ? previousDeviceStats.currentSectorsRead : -1L, currentWritesCompleted, previousDeviceStats != null ? previousDeviceStats.currentWritesCompleted : -1L, currentIOTime, previousDeviceStats != null ? previousDeviceStats.currentIOTime : -1L);
        }

        private DeviceStats(int majorDeviceNumber, int minorDeviceNumber, String deviceName, long currentReadsCompleted, long previousReadsCompleted, long currentSectorsWritten, long previousSectorsWritten, long currentSectorsRead, long previousSectorsRead, long currentWritesCompleted, long previousWritesCompleted, long currentIOTime, long previousIOTime) {
            this.majorDeviceNumber = majorDeviceNumber;
            this.minorDeviceNumber = minorDeviceNumber;
            this.deviceName = deviceName;
            this.currentReadsCompleted = currentReadsCompleted;
            this.previousReadsCompleted = previousReadsCompleted;
            this.currentWritesCompleted = currentWritesCompleted;
            this.previousWritesCompleted = previousWritesCompleted;
            this.currentSectorsRead = currentSectorsRead;
            this.previousSectorsRead = previousSectorsRead;
            this.currentSectorsWritten = currentSectorsWritten;
            this.previousSectorsWritten = previousSectorsWritten;
            this.currentIOTime = currentIOTime;
            this.previousIOTime = previousIOTime;
        }

        public DeviceStats(StreamInput in) throws IOException {
            this.majorDeviceNumber = in.readVInt();
            this.minorDeviceNumber = in.readVInt();
            this.deviceName = in.readString();
            this.currentReadsCompleted = in.readLong();
            this.previousReadsCompleted = in.readLong();
            this.currentWritesCompleted = in.readLong();
            this.previousWritesCompleted = in.readLong();
            this.currentSectorsRead = in.readLong();
            this.previousSectorsRead = in.readLong();
            this.currentSectorsWritten = in.readLong();
            this.previousSectorsWritten = in.readLong();
            this.currentIOTime = in.readLong();
            this.previousIOTime = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.majorDeviceNumber);
            out.writeVInt(this.minorDeviceNumber);
            out.writeString(this.deviceName);
            out.writeLong(this.currentReadsCompleted);
            out.writeLong(this.previousReadsCompleted);
            out.writeLong(this.currentWritesCompleted);
            out.writeLong(this.previousWritesCompleted);
            out.writeLong(this.currentSectorsRead);
            out.writeLong(this.previousSectorsRead);
            out.writeLong(this.currentSectorsWritten);
            out.writeLong(this.previousSectorsWritten);
            out.writeLong(this.currentIOTime);
            out.writeLong(this.previousIOTime);
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public long operations() {
            if (this.previousReadsCompleted == -1L || this.previousWritesCompleted == -1L) {
                return -1L;
            }
            return this.currentReadsCompleted - this.previousReadsCompleted + (this.currentWritesCompleted - this.previousWritesCompleted);
        }

        public long readOperations() {
            if (this.previousReadsCompleted == -1L) {
                return -1L;
            }
            return this.currentReadsCompleted - this.previousReadsCompleted;
        }

        public long writeOperations() {
            if (this.previousWritesCompleted == -1L) {
                return -1L;
            }
            return this.currentWritesCompleted - this.previousWritesCompleted;
        }

        public long readKilobytes() {
            if (this.previousSectorsRead == -1L) {
                return -1L;
            }
            return (this.currentSectorsRead - this.previousSectorsRead) / 2L;
        }

        public long writeKilobytes() {
            if (this.previousSectorsWritten == -1L) {
                return -1L;
            }
            return (this.currentSectorsWritten - this.previousSectorsWritten) / 2L;
        }

        public long ioTimeInMillis() {
            if (this.previousIOTime == -1L) {
                return -1L;
            }
            return this.currentIOTime - this.previousIOTime;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("device_name", this.deviceName);
            builder.field("operations", this.operations());
            builder.field("read_operations", this.readOperations());
            builder.field("write_operations", this.writeOperations());
            builder.field("read_kilobytes", this.readKilobytes());
            builder.field("write_kilobytes", this.writeKilobytes());
            builder.field("io_time_in_millis", this.ioTimeInMillis());
            return builder;
        }
    }
}

