/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.elasticsearch.core.Nullable;

enum Database {
    City(Set.of(Property.IP, Property.COUNTRY_ISO_CODE, Property.COUNTRY_NAME, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.TIMEZONE, Property.LOCATION), Set.of(Property.COUNTRY_ISO_CODE, Property.COUNTRY_NAME, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION)),
    Country(Set.of(Property.IP, Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE), Set.of(Property.CONTINENT_NAME, Property.COUNTRY_NAME, Property.COUNTRY_ISO_CODE)),
    Asn(Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK), Set.of(Property.IP, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK)),
    AnonymousIp(Set.of(Property.IP, Property.HOSTING_PROVIDER, Property.TOR_EXIT_NODE, Property.ANONYMOUS_VPN, Property.ANONYMOUS, Property.PUBLIC_PROXY, Property.RESIDENTIAL_PROXY), Set.of(Property.HOSTING_PROVIDER, Property.TOR_EXIT_NODE, Property.ANONYMOUS_VPN, Property.ANONYMOUS, Property.PUBLIC_PROXY, Property.RESIDENTIAL_PROXY)),
    Enterprise(Set.of(Property.IP, Property.COUNTRY_ISO_CODE, Property.COUNTRY_NAME, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.TIMEZONE, Property.LOCATION, Property.ASN, Property.ORGANIZATION_NAME, Property.NETWORK, Property.HOSTING_PROVIDER, Property.TOR_EXIT_NODE, Property.ANONYMOUS_VPN, Property.ANONYMOUS, Property.PUBLIC_PROXY, Property.RESIDENTIAL_PROXY), Set.of(Property.COUNTRY_ISO_CODE, Property.COUNTRY_NAME, Property.CONTINENT_NAME, Property.REGION_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION));

    private static final String CITY_DB_SUFFIX = "-City";
    private static final String COUNTRY_DB_SUFFIX = "-Country";
    private static final String ASN_DB_SUFFIX = "-ASN";
    private static final String ANONYMOUS_IP_DB_SUFFIX = "-Anonymous-IP";
    private static final String ENTERPRISE_DB_SUFFIX = "-Enterprise";
    private final Set<Property> properties;
    private final Set<Property> defaultProperties;

    public static Database getDatabase(String databaseType, String databaseFile) {
        Database database = null;
        if (databaseType != null) {
            if (databaseType.endsWith(CITY_DB_SUFFIX)) {
                database = City;
            } else if (databaseType.endsWith(COUNTRY_DB_SUFFIX)) {
                database = Country;
            } else if (databaseType.endsWith(ASN_DB_SUFFIX)) {
                database = Asn;
            } else if (databaseType.endsWith(ANONYMOUS_IP_DB_SUFFIX)) {
                database = AnonymousIp;
            } else if (databaseType.endsWith(ENTERPRISE_DB_SUFFIX)) {
                database = Enterprise;
            }
        }
        if (database == null) {
            throw new IllegalArgumentException("Unsupported database type [" + databaseType + "] for file [" + databaseFile + "]");
        }
        return database;
    }

    private Database(Set<Property> properties, Set<Property> defaultProperties) {
        this.properties = properties;
        this.defaultProperties = defaultProperties;
    }

    public Set<Property> properties() {
        return this.properties;
    }

    public Set<Property> defaultProperties() {
        return this.defaultProperties;
    }

    public Set<Property> parseProperties(@Nullable List<String> propertyNames) {
        if (propertyNames != null) {
            HashSet<Property> parsedProperties = new HashSet<Property>();
            for (String propertyName : propertyNames) {
                parsedProperties.add(Property.parseProperty(this.properties, propertyName));
            }
            return Set.copyOf(parsedProperties);
        }
        return this.defaultProperties;
    }

    static enum Property {
        IP,
        COUNTRY_ISO_CODE,
        COUNTRY_NAME,
        CONTINENT_NAME,
        REGION_ISO_CODE,
        REGION_NAME,
        CITY_NAME,
        TIMEZONE,
        LOCATION,
        ASN,
        ORGANIZATION_NAME,
        NETWORK,
        HOSTING_PROVIDER,
        TOR_EXIT_NODE,
        ANONYMOUS_VPN,
        ANONYMOUS,
        PUBLIC_PROXY,
        RESIDENTIAL_PROXY;


        private static Property parseProperty(Set<Property> validProperties, String value) {
            try {
                Property property = Property.valueOf(value.toUpperCase(Locale.ROOT));
                if (!validProperties.contains((Object)property)) {
                    throw new IllegalArgumentException("invalid");
                }
                return property;
            }
            catch (IllegalArgumentException e) {
                Property[] properties = validProperties.toArray(new Property[0]);
                Arrays.sort((Object[])properties);
                throw new IllegalArgumentException("illegal property value [" + value + "]. valid values are " + Arrays.toString((Object[])properties));
            }
        }
    }
}

